%define oname pytest-sugar

%def_with python3
%def_disable check

Name: python-module-%oname
Version: 0.9.2
Release: alt1
Summary: Plugin for py.test that shows failures and errors instantly and shows a progress bar
License: BSD
Group: Development/Python
BuildArch: noarch
Url: https://pypi.python.org/pypi/pytest-sugar/

# https://github.com/Frozenball/pytest-sugar.git
Source: %name-%version.tar

BuildRequires: python-devel python-module-setuptools
BuildRequires: python-module-packaging >= 14.1
BuildRequires: python-module-pytest >= 2.9
BuildRequires: python-module-py
BuildRequires: python-module-termcolor >= 1.1.0
BuildRequires: python-module-pytest-xdist
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools
BuildRequires: python3-module-packaging >= 14.1
BuildRequires: python3-module-py
BuildRequires: python3-module-pytest >= 2.9
BuildRequires: python3-module-termcolor >= 1.1.0
BuildRequires: python3-module-pytest-xdist
%endif

%py_provides pytest_sugar

%description
pytest-sugar is a plugin for py.test that changes the default look and
feel of py.test (e.g. progressbar, show tests that fail instantly).

%package -n python3-module-%oname
Summary: Plugin for py.test that shows failures and errors instantly and shows a progress bar
Group: Development/Python3
%py3_provides pytest_sugar

%description -n python3-module-%oname
pytest-sugar is a plugin for py.test that changes the default look and
feel of py.test (e.g. progressbar, show tests that fail instantly).

%prep
%setup

%if_with python3
cp -fR . ../python3
%endif

%build
export LC_ALL=en_US.UTF-8
%python_build_debug

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
export LC_ALL=en_US.UTF-8
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%check
export LC_ALL=en_US.UTF-8
python setup.py test
py.test
%if_with python3
pushd ../python3
python3 setup.py test
py.test3
popd
%endif

%files
%doc *.rst
%python_sitelibdir/*

%if_with python3
%files -n python3-module-%oname
%doc *.rst
%python3_sitelibdir/*
%endif

%changelog
