%define oname rogue

%def_with python3

Name: python-module-%oname
Version: 0.0.1
Release: alt2.git20150217.1
Summary: A devious little programming language
License: GPLv3+
Group: Development/Python
BuildArch: noarch
Url: https://pypi.python.org/pypi/rogue/

# https://bitbucket.org/johannestaas/rogue.git
Source: %name-%version.tar

BuildRequires: python-devel python-module-setuptools
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools
BuildRequires: python-tools-2to3
%endif

%py_provides %oname

%description
A devious little programming language.

%package tests
Summary: Tests for %oname
Group: Development/Python
Requires: %name = %EVR

%description tests
A devious little programming language.

This package contains tests for %oname.

%if_with python3
%package -n python3-module-%oname
Summary: A devious little programming language
Group: Development/Python3
%py3_provides %oname

%description -n python3-module-%oname
A devious little programming language.

%package -n python3-module-%oname-tests
Summary: Tests for %oname
Group: Development/Python3
Requires: python3-module-%oname = %EVR

%description -n python3-module-%oname-tests
A devious little programming language.

This package contains tests for %oname.
%endif

%prep
%setup

%if_with python3
cp -fR . ../python3
find ../python3 -type f -name '*.py' -exec 2to3 -w -n '{}' +
%endif

%build
%python_build_debug

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
%if_with python3
pushd ../python3
%python3_install
install -p -m644 %oname/*.rg %buildroot%python3_sitelibdir/%oname/
popd
pushd %buildroot%_bindir
for i in $(ls); do
	mv $i $i.py3
done
popd
%endif

%python_install
install -p -m644 %oname/*.rg %buildroot%python_sitelibdir/%oname/

%check
python setup.py build_ext -i
python test_parser.py
%if_with python3
pushd ../python3
python3 setup.py build_ext -i
python3 test_parser.py
popd
%endif

%files
%doc *.md
%_bindir/*
%if_with python3
%exclude %_bindir/*.py3
%endif
%python_sitelibdir/*
%exclude %python_sitelibdir/*/test*

%files tests
%python_sitelibdir/*/test*

%if_with python3
%files -n python3-module-%oname
%doc *.md
%_bindir/*.py3
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/test*
%exclude %python3_sitelibdir/*/*/test*

%files -n python3-module-%oname-tests
%python3_sitelibdir/*/test*
%python3_sitelibdir/*/*/test*
%endif

%changelog
