%define oname rsa

%def_with python3

Name: python-module-%oname
Version: 4.0
Release: alt1
Summary: Pure-Python RSA implementation
License: ASLv2
Group: Development/Python
Url: https://pypi.python.org/pypi/rsa/

Source: %name-%version.tar
BuildArch: noarch

BuildPreReq: python-module-setuptools python-module-pyasn1
BuildPreReq: python-module-unittest2 python-module-pytest
BuildPreReq: python-module-mock
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-module-setuptools python3-module-pyasn1
BuildPreReq: python3-module-unittest2 python3-devel
BuildPreReq: python3-module-pytest
BuildPreReq: python3-module-mock
%endif

%py_provides %oname

%description
Python-RSA is a pure-Python RSA implementation. It supports encryption
and decryption, signing and verifying signatures, and key generation
according to PKCS#1 version 1.5. It can be used as a Python library as
well as on the commandline. The code was mostly written by Sybren A.
Stuvel.

%package -n python3-module-%oname
Summary: Pure-Python RSA implementation
Group: Development/Python3
%py3_provides %oname

%description -n python3-module-%oname
Python-RSA is a pure-Python RSA implementation. It supports encryption
and decryption, signing and verifying signatures, and key generation
according to PKCS#1 version 1.5. It can be used as a Python library as
well as on the commandline. The code was mostly written by Sybren A.
Stuvel.

%prep
%setup

%if_with python3
cp -fR . ../python3
%endif

%build
%python_build_debug

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
%if_with python3
pushd ../python3
%python3_install
popd
pushd %buildroot%_bindir
for i in $(ls); do
	mv $i $i.py3
done
popd
%endif

%python_install

%check
python setup.py test
py.test
%if_with python3
pushd ../python3
python3 setup.py test
py.test3
popd
%endif

%files
%doc LICENSE README.md
%_bindir/*
%if_with python3
%exclude %_bindir/*.py3
%endif
%python_sitelibdir/*

%if_with python3
%files -n python3-module-%oname
%doc LICENSE README.md
%_bindir/*.py3
%python3_sitelibdir/*
%endif

%changelog
