%define _unpackaged_files_terminate_build 1

%define oname setuptools_scm

%def_with python3

Name: python-module-%oname
Version: 2.1.0
Release: alt1
Summary: The blessed package to manage your versions by scm tags
License: MIT
Group: Development/Python
BuildArch: noarch
Url: https://pypi.python.org/pypi/setuptools_scm/
Packager: Python Development Team <python at packages.altlinux.org>

# https://github.com/pypa/setuptools_scm.git
Source: %name-%version.tar
Patch1: %oname-%version-alt-tests.patch

%py_provides %oname
Requires: git-core mercurial
%py_requires setuptools

BuildRequires: git-core mercurial
BuildRequires: python-module-setuptools
BuildRequires: python-module-pytest
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-pytest
%endif

%description
setuptools_scm is a simple utility for the setup_requires feature of
setuptools for use in Mercurial and Git based projects.

It uses metadata from the SCM to generate the version of a project and
is able to list the files belonging to that project (which makes the
MANIFEST.in file unnecessary in many cases).

It falls back to PKG-INFO/.hg_archival.txt when necessary.

%if_with python3
%package -n python3-module-%oname
Summary: The blessed package to manage your versions by scm tags
Group: Development/Python3
%py3_provides %oname
Requires: git-core mercurial
%py3_requires setuptools

%description -n python3-module-%oname
setuptools_scm is a simple utility for the setup_requires feature of
setuptools for use in Mercurial and Git based projects.

It uses metadata from the SCM to generate the version of a project and
is able to list the files belonging to that project (which makes the
MANIFEST.in file unnecessary in many cases).

It falls back to PKG-INFO/.hg_archival.txt when necessary.
%endif

%prep
%setup
%patch1 -p1

rm -f setuptools_scm/win_py31_compat.py

%if_with python3
cp -fR . ../python3
%endif

%build
export SETUPTOOLS_SCM_PRETEND_VERSION=%version

%python_build_debug

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
export SETUPTOOLS_SCM_PRETEND_VERSION=%version

python setup.py egg_info
%python_install

%if_with python3
pushd ../python3
python3 setup.py egg_info
%python3_install
popd
%endif

%check
export TESTS_NO_NETWORK=1

export SETUPTOOLS_SCM_PRETEND_VERSION=%version
python setup.py test
unset SETUPTOOLS_SCM_PRETEND_VERSION
export PYTHONPATH=$PWD
py.test -vv

%if_with python3
pushd ../python3
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
python3 setup.py test
unset SETUPTOOLS_SCM_PRETEND_VERSION
export PYTHONPATH=$PWD
py.test3 -vv
popd
%endif

%files
%doc *.rst
%python_sitelibdir/*

%if_with python3
%files -n python3-module-%oname
%doc *.rst
%python3_sitelibdir/*
%endif

%changelog
