%define _unpackaged_files_terminate_build 1
%define oname toml

%def_with check

Name: python-module-%oname
Version: 0.10.0
Release: alt2

Summary: A Python library for parsing and creating TOML.
License: MIT
Group: Development/Python
# Source-git: https://github.com/uiri/toml.git
Url: https://pypi.org/project/toml/

Source: %name-%version.tar
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3

%if_with check
BuildRequires: python2.7(pytest_cov)
BuildRequires: python3(pytest_cov)
BuildRequires: python3(tox)
%endif

BuildArch: noarch

%description
TOML aims to be a minimal configuration file format that's easy to read due to
obvious semantics. TOML is designed to map unambiguously to a hash table. TOML
should be easy to parse into data structures in a wide variety of languages.
This package loads toml file into python dictionary and dump dictionary into
toml file.

%package -n python3-module-%oname
Summary: A Python3 library for parsing and creating TOML.
Group: Development/Python3

%description -n python3-module-%oname
TOML aims to be a minimal configuration file format that's easy to read due to
obvious semantics. TOML is designed to map unambiguously to a hash table. TOML
should be easy to parse into data structures in a wide variety of languages.
This package loads toml file into python dictionary and dump dictionary into
toml file.

%prep
%setup
%patch -p1
rm -rf ../python3
cp -a . ../python3

%build
%python_build

pushd ../python3
%python3_build
popd

%install
pushd ../python3
%python3_install
popd

%python_install

%check
sed -i '/\[testenv\]/a whitelist_externals =\
    \/bin\/cp\
    \/bin\/sed\
commands_pre =\
    \/bin\/cp %_bindir\/py.test3 \{envbindir\}\/pytest\
    \/bin\/sed -i \x271c #!\{envpython\}\x27 \{envbindir\}\/pytest' tox.ini
export PIP_NO_INDEX=YES
export TOXENV=py%{python_version_nodots python},py%{python_version_nodots python3}
tox.py3 --sitepackages -p auto -o -v

%files
%python_sitelibdir/toml/
%python_sitelibdir/toml-*.egg-info/

%files -n python3-module-%oname
%python3_sitelibdir/toml/
%python3_sitelibdir/toml-*.egg-info/

%changelog
