%define oname urllib3
%def_disable check

Name: python-module-%oname
Version: 1.25.6
Release: alt1

Epoch: 2

Summary: Library with thread-safe connection pooling, file post support, sanity friendly etc
License: MIT
Group: Development/Python

Url: https://github.com/shazow/urllib3/

# make all imports of things in packages try system copies first
Patch: %name-%version.patch

# https://github.com/shazow/urllib3.git
Source: %oname-%version.tar
BuildArch: noarch

BuildRequires(pre): rpm-build-python
BuildRequires(pre): rpm-macros-sphinx

BuildRequires: python-module-six python-module-backports.ssl_match_hostname
BuildRequires: python-module-ndg-httpsclient
BuildRequires: python-module-sphinx-devel
BuildRequires: python-module-mock
BuildRequires: python-module-nose
BuildRequires: python-module-socks

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-six
BuildRequires: python3-module-mock
BuildRequires: python3-module-nose

%setup_python_module %oname

Requires: python-module-ndg-httpsclient
Requires: python-module-six python-module-backports.ssl_match_hostname ca-certificates
%py_requires ndg.httpsclient

%description
Python HTTP library with thread-safe connection pooling, file post
support, sanity friendly, and more.

%package -n python3-module-%oname
Summary: Library with thread-safe connection pooling, file post support, sanity friendly etc
Group: Development/Python3
Requires: python3-module-ndg-httpsclient
Requires: python3-module-six ca-certificates

%description -n python3-module-%oname
Python HTTP library with thread-safe connection pooling, file post
support, sanity friendly, and more.

%package -n python3-module-%oname-tests
Summary: Tests for urllib3
Group: Development/Python3
Requires: python3-module-%oname = %EVR

%description -n python3-module-%oname-tests
Python HTTP library with thread-safe connection pooling, file post
support, sanity friendly, and more.

This package contains tests for urllib3.

%package tests
Summary: Tests for urllib3
Group: Development/Python
Requires: %name = %EVR

%description tests
Python HTTP library with thread-safe connection pooling, file post
support, sanity friendly, and more.

This package contains tests for urllib3.

%package pickles
Summary: Pickles for urllib3
Group: Development/Python

%description pickles
Python HTTP library with thread-safe connection pooling, file post
support, sanity friendly, and more.

This package contains pickles for urllib3.

%package docs
Summary: Documentation for urllib3
Group: Development/Documentation

%description docs
Python HTTP library with thread-safe connection pooling, file post
support, sanity friendly, and more.

This package contains documentation for urllib3.

%prep
%setup -n %oname-%version
#rm -rf urllib3/packages/
%patch -p1

cp -fR . ../python3


%prepare_sphinx .
ln -s ../objects.inv docs/

%build
%python_build

pushd ../python3
%python3_build
popd

%install
%python_install

pushd ../python3
%python3_install
popd

export PYTHONPATH=%buildroot%python_sitelibdir
pushd docs
%make html
%make pickle
popd

cp -fR docs/_build/pickle %buildroot%python_sitelibdir/%oname/

%check
py.test

pushd ../python3
py.test-3
popd


%files
%doc *.txt *.rst
%python_sitelibdir/*
#exclude %python_sitelibdir/*/test*
%exclude %python_sitelibdir/*/pickle

#files tests
#python_sitelibdir/*/test*

%files pickles
%python_sitelibdir/*/pickle

%files docs
%doc docs/_build/html/*

%files -n python3-module-%oname
%doc *.txt *.rst
%python3_sitelibdir/*
#exclude %python3_sitelibdir/*/test*

#files -n python3-module-%oname-tests
#python3_sitelibdir/*/test*

%changelog
