%define _unpackaged_files_terminate_build 1

%define oname seqlearn

Name: python3-module-%oname
Version: 0.2
Release: alt4

Summary: Sequence learning toolkit for Python
License: MIT
Group: Development/Python3
Url: http://larsmans.github.io/seqlearn/

# https://github.com/larsmans/seqlearn.git
Source0: https://pypi.python.org/packages/25/2c/95da36839f647a6b15da1fd10f68d755c7fca549c92aabb3ff734f5c682c/%{oname}-%{version}.tar.gz

BuildRequires(pre): rpm-build-python3
BuildRequires: libnumpy-py3-devel
BuildRequires: python3-module-Cython
BuildRequires: python3-module-numpy-testing
BuildRequires: python3-module-pytest
BuildRequires: python3-module-six
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-numpydoc

%py3_provides %oname


%description
seqlearn is a sequence classification toolkit for Python. It is designed
to extend scikit-learn and offer as similar as possible an API.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
seqlearn is a sequence classification toolkit for Python. It is designed
to extend scikit-learn and offer as similar as possible an API.

This package contains tests for %oname.

%package pickles
Summary: Pickles for %oname
Group: Development/Python3

%description pickles
seqlearn is a sequence classification toolkit for Python. It is designed
to extend scikit-learn and offer as similar as possible an API.

This package contains pickles for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
seqlearn is a sequence classification toolkit for Python. It is designed
to extend scikit-learn and offer as similar as possible an API.

This package contains documentation for %oname.

%prep
%setup -q -n %{oname}-%{version}

sed -i 's|sphinx-build|sphinx-build-3|' doc/Makefile

# Don't depend on sklearn.externals.six, depend on six instead
find . -name '*.py' -type f -print0 | xargs -0 sed -i \
	-e 's:from sklearn\.externals ::g'

%build
%python3_build_debug

%install
%python3_install

export PYTHONPATH=%buildroot%python3_sitelibdir

mv %oname %oname.bak
%make -C doc pickle
%make -C doc html
mv %oname.bak %oname

cp -fR doc/_build/pickle %buildroot%python3_sitelibdir/%oname/

%check
%if 0
rm -fR build
export PYTHONPATH=%buildroot%python3_sitelibdir
py.test-%_python3_version
%endif

%files
%doc *.rst examples
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/pickle
%exclude %python3_sitelibdir/*/tests

%files tests
%python3_sitelibdir/*/tests

%files pickles
%python3_sitelibdir/*/pickle

%files docs
%doc doc/_build/html/*


%changelog
