# WARNING: Rebuild QGIS whenever a new version of GRASS is shipped! Even though the soname might stay the same, it won't work anymore.
# http://hub.qgis.org/issues/5274
%define grass_version 7.8.5

Name:    qgis
Version: 2.18.28
Release: alt4.1.p9

Summary: A user friendly Open Source Geographic Information System
License: GPLv3+ with exceptions
Group:   Sciences/Geosciences
Url:     http://qgis.org/

Packager: Andrey Cherepanov <cas@altlinux.org>

Source: %name-%version.tar
Source1: qbrowser.desktop
Source2: qgis.desktop
Source3: qgis-server-httpd.conf
Source4: qgis-server-README
Source5: qgis.xml
Source6: %name-mimelnk.tar

# Fix detection problem for GRASS libraries
Patch1: %name-ignore-bundled-modules.patch
Patch2: %name-sip-flags.patch
Patch3: %name-fix-unresolved-variable.patch
# Need to build otb-python for otbAppication
Patch4: %name-disable-otb-plugin.patch
Patch5: %name-alt-strict-sip-compat.patch
Patch6: qgis2-alt-gdal-3.0.patch

# Fix unresolved symbols in grass based libs
%set_verify_elf_method unresolved=relaxed

# Set proper libexec directory
%define _libexecdir %prefix/libexec

# TODO: Pyspatialite is included if you use the bundled libspatialite.
# Some plug-ins need it.
# The license is not totally clear, see:
# http://code.google.com/p/pyspatialite/issues/detail?id=3
# It also is sort of a fork of pysqlite, which is not elegant.

BuildRequires: gcc-c++
BuildRequires: cmake
BuildRequires: desktop-file-utils
BuildRequires: libexpat-devel
BuildRequires: libfcgi-devel
BuildRequires: flex bison
BuildRequires: libgdal-devel
BuildRequires: libgeos-devel
BuildRequires: grass-devel = %grass_version
BuildRequires: libgsl-devel
BuildRequires: libspatialite-devel
BuildRequires: postgresql-devel
BuildRequires: libproj-devel
BuildRequires: python-module-PyQt4-devel
BuildRequires: txt2tags
BuildRequires: python-devel
BuildRequires: libqt4-devel
# Fail to build with Qt-Mobility. See http://hub.qgis.org/issues/7753
#BuildRequires: qt4-mobility-devel
BuildRequires: libqt4-webkit
BuildRequires: qextserialport-devel
BuildRequires: libqwtpolar-devel
BuildRequires: python-module-sip-devel >= 4.15
BuildRequires: spatialindex-devel
BuildRequires: libsqlite3-devel
BuildRequires: python-module-qscintilla2-qt4-devel
BuildRequires: libqscintilla2-qt4-devel
BuildRequires: python-module-OWSLib
BuildRequires: python-module-nose2
BuildRequires: libqca2-devel
BuildRequires: gzip

Requires: libqt4-sql-sqlite
Requires: gpsbabel
Requires: qca2-ossl
Requires: libqwt6

# We don't want to provide private Python extension libs
%add_findprov_skiplist %%python_sitelibdir/%%name/*.so 

%description
Geographic Information System (GIS) manages, analyzes, and displays
databases of geographic information. Quantum GIS (QGIS) supports shape
file viewing and editing, spatial data storage with PostgreSQL/PostGIS,
projection on-the-fly, map composition, and a number of other features
via a plugin interface. QGIS also supports display of various
geo-referenced raster and Digital Elevation Model (DEM) formats
including GeoTIFF, Arc/Info ASCII Grid, and USGS ASCII DEM.

%package devel
Summary: Development Libraries for the Quantum GIS
Group: Development/C
Requires: %name = %version-%release

%description devel
Development packages for Quantum GIS including the C header files.

%package grass 
Summary: GRASS Support Libraries for Quantum GIS
Group: Sciences/Geosciences
Requires: %name = %version-%release
Requires: grass
  
%description grass
GRASS plugin for Quantum GIS required to interface with the GRASS
system.

%package python 
Summary: Python integration and plug-ins for Quantum GIS
Group: Sciences/Geosciences
Requires: %name = %version-%release
Requires: python-module-gdal
Requires: python-module-qscintilla2-qt4
# SPI API >= 9.1
Requires: python-module-sip

%description python
Python integration and plug-ins for Quantum GIS.

%package server 
Summary: FCGI based OGC web map server
Group: Sciences/Geosciences
Provides:  %name-mapserver = %version-%release
Obsoletes: %name-mapserver < %version-%release
Requires: %name = %version-%release
Requires: libfcgi

%description server
This FastCGI OGC web map server implements OGC WMS 1.3.0 and 1.1.1.
The services are prepared as regular projects in QGIS. They're rendered
using the QGIS libraries. The server also supports SLD (Styled Layer
Descriptor) for styling. Sample configurations for Httpd and Lighttpd
are included.

Please refer to %name-server-README for details!

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1

# Delete bundled libs
rm -rf src/core/gps/qextserialport
rm -rf "python/ext-libs/!(CMakeLists.txt|tests)"
rm -rf src/plugins/dxf2shp_converter/
sed -i '/dxf2shp_converter/d' src/plugins/CMakeLists.txt

gzip ChangeLog

%build
%add_optflags -DACCEPT_USE_OF_DEPRECATED_PROJ_API_H=1
CFLAGS="${CFLAGS:-%optflags}"; export CFLAGS;
CXXFLAGS="${CXXFLAGS:-%optflags}"; export CXXFLAGS;
export LD_LIBRARY_PATH=`pwd`/output/%_lib
cmake \
	-DCMAKE_C_FLAGS_RELEASE:STRING="-DNDEBUG" \
	-DCMAKE_CXX_FLAGS_RELEASE:STRING="-DNDEBUG" \
	-DCMAKE_Fortran_FLAGS_RELEASE:STRING="-DNDEBUG" \
	-DCMAKE_VERBOSE_MAKEFILE:BOOL=ON \
	-DCMAKE_INSTALL_PREFIX:PATH=%_prefix \
	-DINCLUDE_INSTALL_DIR:PATH=%_includedir \
	-DLIB_INSTALL_DIR:PATH=%_libdir \
	-DSYSCONF_INSTALL_DIR:PATH=%_sysconfdir \
	-DSHARE_INSTALL_PREFIX:PATH=%_datadir \
%if "%_lib" == "lib64"
	-DLIB_SUFFIX="64" \
%endif
	-DBUILD_SHARED_LIBS:BOOL=ON \
	-DCMAKE_SKIP_RPATH:BOOL=ON \
	-DQGIS_LIB_SUBDIR:PATH=%_lib \
	-DQGIS_MANUAL_SUBDIR:PATH=/share/man \
	-DQGIS_PLUGIN_SUBDIR:PATH=%_lib/%name \
	-DQGIS_CGIBIN_SUBDIR:PATH=%_libexecdir/%name \
	-DWITH_BINDINGS:BOOL=TRUE \
	-DGRASS_PREFIX:PATH=%_libdir/grass \
	-DGRASS_PREFIX7:PATH=%_libdir/grass \
	-DMAPSERVER_SKIP_ECW=TRUE \
	-DWITH_MAPSERVER:BOOL=TRUE \
	-DBINDINGS_GLOBAL_INSTALL:BOOL=TRUE \
	-DWITH_CUSTOM_WIDGETS:BOOL=TRUE \
	-DGDAL_INCLUDE_DIR:PATH=%_includedir/gdal \
	-DGDAL_LIBRARY:PATH=%_libdir/libgdal.so \
	-DGEOS_LIBRARY:PATH=%_libdir/libgeos_c.so \
	-DENABLE_TESTS:BOOL=FALSE \
	-DWITH_INTERNAL_DATEUTIL:BOOL=FALSE \
	-DWITH_INTERNAL_HTTPLIB2:BOOL=FALSE \
	-DWITH_INTERNAL_JINJA2:BOOL=FALSE \
	-DWITH_INTERNAL_MARKUPSAFE:BOOL=FALSE \
	-DWITH_INTERNAL_OWSLIB:BOOL=FALSE \
	-DWITH_INTERNAL_PYGMENTS:BOOL=FALSE \
	-DWITH_INTERNAL_PYTZ:BOOL=FALSE \
	-DWITH_INTERNAL_QEXTSERIALPORT:BOOL=FALSE \
	-DWITH_INTERNAL_QWTPOLAR:BOOL=FALSE \
	-DWITH_INTERNAL_SIX:BOOL=FALSE \
	-DWITH_INTERNAL_SPATIALITE:BOOL=FALSE \
	-DWITH_PYSPATIALITE:BOOL=FALSE \
	-DWITH_SERVER:BOOL=TRUE \
	-DWITH_SPATIALITE:BOOL=TRUE \
	-DQEXTSERIALPORT_LIBRARY:PATH=%_libdir/libqextserialport.so \
	-DQEXTSERIALPORT_INCLUDE_DIR:PATH=%_includedir/qt4/QtExtSerialPort \
	-DQWTPOLAR_INCLUDE_DIR:PATH=%_includedir/qwt \
	-DWITH_QTMOBILITY:BOOL=FALSE \
	-DWITH_TOUCH:BOOL=TRUE \
	.
%make_build VERBOSE=1

%install
%makeinstall_std

# Install desktop files
desktop-file-install --dir=%buildroot%_datadir/applications %SOURCE1
desktop-file-install --dir=%buildroot%_datadir/applications %SOURCE2

# Install MIME type definitions
install -pd %buildroot%_datadir/mime/packages
install -pm0644 %SOURCE5 %buildroot%_datadir/mime/packages/%name.xml
install -pd %buildroot%_datadir/mimelnk/application
tar xf %SOURCE6 -C %buildroot%_datadir/mimelnk/application

# Install application and MIME icons
install -pd %buildroot%_datadir/pixmaps
install -pd %buildroot%_datadir/icons/hicolor/16x16/apps
install -pd %buildroot%_datadir/icons/hicolor/scalable/apps
install -pd %buildroot%_datadir/icons/hicolor/128x128/mimetypes
install -pm0644 \
	%buildroot%_datadir/%name/images/icons/%name-icon.png \
	%buildroot%_datadir/pixmaps/%name.png
install -pm0644 \
	images/icons/%name-icon-16x16.png \
	%buildroot%_datadir/icons/hicolor/16x16/apps/%name.png
install -pm0644 \
	images/icons/%{name}_icon.svg \
	%buildroot%_datadir/icons/hicolor/scalable/apps/%name.svg
install -pm0644 \
	%buildroot%_datadir/%name/images/icons/%name-mime-icon.png \
	%buildroot%_datadir/icons/hicolor/128x128/mimetypes/application-x-qgis-layer-settings.png
install -pm0644 \
	%buildroot%_datadir/%name/images/icons/%name-mime-icon.png \
	%buildroot%_datadir/icons/hicolor/128x128/mimetypes/application-x-qgis-project.png

# Install basic QGIS Mapserver configuration for Apache
install -pd %buildroot%_sysconfdir/httpd/conf.d
install -pm0644 %SOURCE3 %buildroot%_sysconfdir/httpd/conf.d/qgis-server.conf

# Packed by %%doc in server, see qgis-server-README
rm -f %buildroot%_libexecdir/%name/wms_metadata.xml
rm -f %buildroot%_libexecdir/%name/admin.sld

# Remove files packaged by doc
pushd %buildroot%_datadir/%name/doc
rm -f BUGS \
	CHANGELOG \
	CODING \
	COPYING \
	INSTALL \
	PROVENANCE \
	README
popd

# Install server docs
mkdir -p %buildroot%_datadir/doc/%name-server-%version
cp src/server/admin.sld src/server/wms_metadata.xml %SOURCE4 %SOURCE3 \
   %buildroot%_datadir/doc/%name-server-%version

# Copy test utilities form tests to plugins/processing/tests
cp tests/src/python/utilities.py %buildroot%_datadir/qgis/python/plugins/processing/tests/

%find_lang %name --with-qt
# Add missing localization
echo "%%lang(zh) /usr/share/qgis/i18n/qgis_zh-Hans.qm" >> %name.lang


%files -f %name.lang
%doc BUGS NEWS COPYING Exception_to_GPL_for_Qt.txt PROVENANCE *.md ChangeLog.gz
# QGIS shows these files in the GUI
%_datadir/%name/doc
%dir %_datadir/%name/i18n/
%_libdir/lib%{name}_analysis.so.*
%_libdir/lib%{name}_app.so.*
%_libdir/lib%{name}_core.so.*
%_libdir/lib%{name}_gui.so.*
%_libdir/lib%{name}_networkanalysis.so.*
%_libdir/lib%{name}_server.so.*
%_libdir/%name
%_bindir/%name
%_bindir/qbrowser
%doc %_man1dir/*
%dir %_datadir/%name/
%_datadir/mime/packages/%name.xml
%_datadir/pixmaps/%name.png
%_datadir/icons/hicolor/16x16/apps/%name.png
%_datadir/icons/hicolor/128x128/mimetypes/application-x-%name-project.png
%_datadir/icons/hicolor/128x128/mimetypes/application-x-%name-layer-settings.png
%_datadir/icons/hicolor/scalable/apps/%name.svg
%_datadir/applications/*.desktop
%_datadir/%name/images
%_datadir/%name/resources
%_datadir/%name/svg
%exclude %_libdir/libqgisgrass*.so.*
%exclude %_libdir/%name/libgrassprovider*.so
%exclude %_libdir/%name/libgrassrasterprovider*.so
%exclude %_libdir/%name/grass
%_datadir/mimelnk/application/*

%files devel
%_datadir/%name/FindQGIS.cmake
%_includedir/%name
%_libdir/lib%{name}*.so
%_libdir/qt4/plugins/designer/libqgis_customwidgets.so*

%files grass
%_libdir/lib%{name}grass*.so.*
%_libdir/%name/libgrassprovider*.so
%_libdir/%name/libgrassrasterprovider*.so
%_libdir/%name/grass
%_datadir/%name/grass

%files python
%_libdir/libqgispython.so.*
%_datadir/%name/python
%python_sitelibdir/%name
%python_sitelibdir/PyQt4/uic/widget-plugins/

%files server
%doc %_datadir/doc/%name-server-%version
%config(noreplace) %_sysconfdir/httpd/conf.d/%{name}-server.conf
%_libexecdir/%name

%changelog
