%define        pkg_name ratpoison

Name:          %pkg_name
Version:       1.4.9
Release:       alt1

Group:         Graphical desktop/Other
Summary:       ratpoison - Simple window manager with no fat library dependencies
License:       GPL2
Url:           http://www.nongnu.org/ratpoison
# VCS:         https://git.savannah.nongnu.org/git/ratpoison.git

Source:        %name-%version.tar
Source1:       RATPOISON.xpm

# Automatically added by buildreq on Thu Apr 08 2010 (-bi)
# optimized out: elfutils fontconfig fontconfig-devel glibc-pthread libX11-devel libXrender-devel libfreetype-devel pkg-config xorg-inputproto-devel xorg-renderproto-devel xorg-xextproto-devel xorg-xproto-devel
BuildRequires: imake libICE-devel libXext-devel libXft-devel libXi-devel libXinerama-devel libXtst-devel libreadline-devel xorg-cf-files
BuildRequires: libXrandr-devel
BuildRequires(pre): emacs-devel
BuildRequires(pre): emacs-common
# explicitly added texinfo for info files
BuildRequires: texinfo

%description
ratpoison is a simple Window Manager with no fat library
dependencies, no fancy graphics, no window decorations,
and no flashy wank. It is largely modelled after GNU
Screen which has done wonders in virtual terminal market.

All interaction with the window manager is done through
keystrokes. ratpoison has a prefix map to minimize the
key clobbering that cripples EMACS and other quality
pieces of software.


%package       -n emacs-%name
Summary:       The Emacs Lisp bytecode included in %name
Group:         Development/Other
Requires:      %name = %EVR
Requires:      emacs-common

%description   -n emacs-%name
%name-el contains the Emacs Lisp bytecode
included in the %name package, that extends the Emacs editor.

You need to install %name-el only if you intend to modify any of the
%name code or see some Lisp examples.


%package       -n emacs-%name-el
Summary:       The Emacs Lisp sources for bytecode included in %name
Group:         Development/Other
Requires:      emacs-%name = %EVR

%description   -n emacs-%name-el
%name-el contains the Emacs Lisp sources for the bytecode
included in the %name package, that extends the Emacs editor.

You need to install %name-el only if you intend to modify any of the
%name code or see some Lisp examples.


%prep
%setup

%build
%autoreconf
%configure \
    --prefix=%_prefix \
    --infodir=%_infodir \
    --mandir=%_mandir \
		--with-x

%make_build
%byte_compile_file contrib/%pkg_name.el

%install
%makeinstall_std

install -d %buildroot/%_docdir %buildroot/%_niconsdir

# startfile
cat > %buildroot/%_bindir/start%name << EOF
#!/bin/sh
exec %_bindir/%name
EOF
chmod 755 %buildroot/%_bindir/start%name

# session file
install -d %buildroot/%_sysconfdir/X11/wmsession.d
install -m 644 %SOURCE1 %buildroot/%_niconsdir/RATPOISON.xpm
cat > %buildroot/%_sysconfdir/X11/wmsession.d/16%name << EOF
NAME=%name
ICON=%_niconsdir/RATPOISON.xpm
EXEC=%_bindir/start%name
DESC=%name window manager
SCRIPT:
exec %_bindir/start%name
EOF

install -D -m 644 contrib/%pkg_name.elc %buildroot%_emacslispdir/%pkg_name.elc

%files
%config(noreplace) %_sysconfdir/X11/wmsession.d/16%name
%_defaultdocdir/*
%_bindir/*
%_datadir/%name
%_man1dir/%name.1*
%_infodir/%name.info*
%_niconsdir/RATPOISON.xpm
%doc README TODO AUTHORS NEWS ChangeLog doc/sample.ratpoisonrc doc/ipaq.ratpoisonrc

%files       -n emacs-%name-el
%_emacslispdir/%name.el

%files       -n emacs-%name
%_emacslispdir/%name.elc

%changelog
