# python-module-rpm overrides %%version
%define rpm_version 4.0.4

%define oname rpm

Name: rpm-build
Version: 4.0.4
Release: alt164

%define ifdef() %if %{expand:%%{?%{1}:1}%%{!?%{1}:0}}
%define get_dep() %(rpm -q --qf '%%{NAME} >= %%|SERIAL?{%%{SERIAL}:}|%%{VERSION}-%%{RELEASE}' %1 2>/dev/null || echo '%1 >= unknown')
%define def_with() %{expand:%%{!?_with_%{1}: %%{!?_without_%{1}: %%global _with_%{1} --with-%{1}}}}
%define def_without() %{expand:%%{!?_with_%{1}: %%{!?_without_%{1}: %%global _without_%{1} --without-%{1}}}}
%define if_with() %if %{expand:%%{?_with_%{1}:1}%%{!?_with_%{1}:0}}
%define if_without() %if %{expand:%%{?_without_%{1}:1}%%{!?_without_%{1}:0}}
%define _rpmlibdir %_prefix/lib/rpm

%def_without python
%def_with libelf
%def_without apidocs
%def_without db
%def_without build_topdir
%def_with selinux
%def_with profile

# XXX enable at your own risk, CDB access to rpmdb isn't cooked yet.
%define enable_cdb create cdb

Summary: Scripts and executable programs used to build packages
Summary(ru_RU.UTF-8): Файлы, необходимые для установки SRPM-пакетов и сборки RPM-пакетов
License: GPLv2+
Group: Development/Other
Obsoletes: spec-helper
Requires: librpmbuild = %version-%release
Requires: %_bindir/subst
Requires: autoconf
Requires: autoconf-common
Requires: automake
Requires: automake-common
Requires: bash >= 0:3.1.17-alt4
# Due to 'readelf --dyn-syms':
Requires: binutils >= 1:2.20.51.0.7
Requires: bison
Requires: bzip2 >= 1:1.0.2-alt4
Requires: coreutils
Requires: cpio
Requires: elfutils >= 0.143-alt1
Requires: file
Requires: gcc
Requires: gettext-tools
Requires: glibc-devel
Requires: gnu-config
Requires: gzip >= 0:1.3.3-alt2
Requires: info-install >= 4.11
Requires: kernel-headers
Requires: libtool
Requires: m4
# due to -O option in $MAKEFLAGS
Requires: make >= 4.0
Requires: mktemp >= 1:1.3.1
Requires: patch >= 2.5
Requires: pkgconfig-recursion
Requires: pkgconfig-reqprov
Requires: procps
Requires: psmisc
Requires: rpm-build-perl >= 0.76
Requires: rpm-build-python >= 0.31
Requires: rpmspec
Requires: sed
Requires: service
Requires: shadow-utils
Requires: tar >= 0:1.13.22-alt1
Requires: which
Requires: xz
Conflicts: rpm-build-tcl <= 0.2
Conflicts: rpm-build-mono <= 1.0

Url: http://www.rpm.org/

# http://git.altlinux.org/gears/r/rpm.git
Source: rpm-%version-%release.tar

%{?_with_python:BuildPreReq: python-devel}
%{?_with_apidocs:BuildPreReq: ctags doxygen}
%{?_with_libelf:BuildPreReq: libelf-devel}
%{?_with_selinux:BuildPreReq: libselinux-devel >= 2.0.96}
%{?_with_profile:BuildPreReq: coreutils >= 6.0}

BuildPreReq: automake >= 1.7.1, autoconf >= 2.53, libbeecrypt-devel >= 4.2.1
BuildPreReq: rpm >= 3.0.6-ipl24mdk, %_bindir/subst

# For debugedit.
BuildPreReq: elfutils-devel
BuildRequires: librpm-devel

# Automatically added by buildreq on Thu Apr 23 2009 and edited manually.
BuildRequires: libdb4.7-devel libelf-devel liblzma-devel libpopt-devel python-devel zlib-devel

%package -n lib%oname
Summary: Shared libraries required for applications which will manipulate RPM packages
Summary(ru_RU.UTF-8): Файлы, необходимые для разработки приложений, взаимодействующих с RPM-пакетами
License: GPLv2+ or LGPLv2.1+
Group: System/Libraries

%package -n librpmbuild
Summary: Shared library required for applications which will build RPM packages
Summary(ru_RU.UTF-8): Разделяемая библиотека для разработки приложений, собирающих RPM-пакеты
License: GPLv2+ or LGPLv2.1+
Group: System/Libraries
Requires: lib%oname = %version-%release

%package -n lib%oname-devel
Summary: Development files for applications which will manipulate RPM packages
Summary(ru_RU.UTF-8): Файлы, необходимые для разработки приложений, взаимодействующих с RPM-пакетами
License: GPLv2+ or LGPLv2.1+
Group: Development/C
Provides: %oname-devel = %version-%release
Obsoletes: %oname-devel
Requires: lib%oname = %version-%release, librpmbuild = %version-%release
Requires: libpopt-devel

%package -n lib%oname-devel-static
Summary: Static libraries for developing statically linked applications which will manipulate RPM packages
Summary(ru_RU.UTF-8): Статические библиотеки, необходимые для разработки статических приложений, взаимодействующих с RPM-пакетами
License: GPLv2+ or LGPLv2.1+
Group: Development/C
Requires: lib%oname-devel = %version-%release
Requires: libbeecrypt-devel-static, libdb4.7-devel-static, libpopt-devel-static, zlib-devel-static


%package build-topdir
Summary: RPM package installation and build directory tree
Summary(ru_RU.UTF-8): Сборочное дерево, используемое для установки SRPM-пакетов и сборки RPM-пакетов
License: GPL
Group: Development/Other
Requires: %oname-build = %version-%release

%package static
Summary: Static version of the RPM package management system
Summary(ru_RU.UTF-8): Статическая версия менеджера пакетов RPM
License: GPL
Group: System/Configuration/Packaging
Requires: %oname = %version-%release

%description -l ru_RU.UTF-8
RPM - это мощный неинтерактивный менеджер пакетов, используемый для сборки,
установки, инспекции, проверки, обновления и удаления отдельных программных
пакетов.  Каждый такой пакет состоит из набора файлов и информации о пакете,
включающей название, версию, описание пакета, и т.д.

%description -n lib%oname
This package contains shared libraries required to run dynamically linked
programs manipulating with RPM packages and databases.

%description -n librpmbuild
This package contains shared library required to run dynamically linked
programs building RPM packages.

%description -n lib%oname-devel
This package contains the RPM C library and header files.  These
development files will simplify the process of writing programs
which manipulate RPM packages and databases and are intended to make
it easier to create graphical package managers or any other tools
that need an intimate knowledge of RPM packages in order to function.

This package should be installed if you want to develop programs that
will manipulate RPM packages and databases.

%description -n lib%oname-devel-static
This package contains the RPM C library and header files.  These
development files will simplify the process of writing programs
which manipulate RPM packages and databases and are intended to make
it easier to create graphical package managers or any other tools
that need an intimate knowledge of RPM packages in order to function.

This package should be installed if you want to develop statically linked
programs that will manipulate RPM packages and databases.

%description
This package contains scripts and executable programs that are used to
build packages using RPM.

%description build-topdir
This package contains RPM package installation and build directory tree.

%description static
This package contains statically linked version of the RPM program.

%if_with python
%package -n python-module-rpm
Version: %{rpm_version}_%__python_version
Summary: Python bindings for apps which will manipulate RPM packages
Summary(ru_RU.UTF-8): Интерфейс для разработки Python-приложений, взаимодействующих с RPM-пакетами
License: GPLv2+ or LGPLv2.1+
Group: Development/Python
Requires: lib%oname = %rpm_version-%release
Requires: python = %__python_version
Provides: rpm-python = %{rpm_version}_%__python_version-%release
Obsoletes: rpm-python

%description -n python-module-rpm
This package contains a module which permits applications written in
the Python programming language to use the interface supplied by RPM
(RPM Package Manager) libraries.
%endif #with python

%package checkinstall
Summary: Run tests for %name immediately when this package is installed
Group: Other
BuildArch: noarch
Requires: %name
# rpminstall-tests-checkinstall first uses rpm-build to build packages,
# then tests how rpm installs them. Useful for testing rpm-build, too.
Requires: rpminstall-tests-archcompat-checkinstall
Requires: rpminstall-tests-checkinstall

%description checkinstall
%summary

%prep
%setup -n rpm-%rpm_version-%release

%build
gettextize --force --quiet --no-changelog --symlink
install -pv -m0644 /usr/share/automake/mkinstalldirs .
autoreconf -fisv -I m4
# avoid extra build dependencies
export ac_cv_path___CPIO=/bin/cpio
export ac_cv_path___UNZIP=/usr/bin/unzip
export ac_cv_path___LZMA=/usr/bin/lzma
export ac_cv_path___XZ=/usr/bin/xz
export ac_cv_path___GPG=/usr/bin/gpg
export ac_cv_path___SSH=/usr/bin/ssh
export LDFLAGS="-L$PWD/stub"
%configure \
	%{?_with_python} %{?_without_python} \
	%{?_with_apidocs} %{?_without_apidocs} \
	%{?_with_db} %{?_without_db} \
	%{subst_with selinux} \
	--disable-static \
	--program-transform-name=

# create a stub libselinux.a so that -lselinux would work in -static mode
mkdir stub
ar cq stub/libselinux.a
ln -s %_libdir/libselinux.so stub/

set_c_cflags="$(sed -n 's/^CFLAGS = //p' lib/Makefile) -W -Wno-missing-prototypes -Wno-override-init %{!?_enable_debug:-O3} -fno-builtin-memcmp"
%make_build -C lib set.lo CFLAGS="$set_c_cflags"
%make_build

rpmquery -a --provides |fgrep '= set:' |sort >P
rpmquery -a --requires |fgrep '= set:' |sort >R
join -o 1.3,2.3 P R |shuf >setcmp-data

%if_with profile
rm lib/set.lo lib/librpm.la
%make_build -C lib set.lo librpm.la CFLAGS="$set_c_cflags -fprofile-generate"
./tools/setcmp <setcmp-data >/dev/null
ls -l lib/.libs/set.gcda
rm lib/set.lo lib/librpm.la
%make_build -C lib set.lo CFLAGS="$set_c_cflags -fprofile-use"
%make_build
%else
./tools/setcmp <setcmp-data >/dev/null
%endif #with profile

%if_with apidocs
rm -rf apidocs
make apidocs
%endif #with apidocs

# check
lib/test-set
make check

%install
%make_install DESTDIR='%buildroot' install
chmod a-w %buildroot%_usrsrc/RPM{,/RPMS/*}

rm %buildroot%_libdir/librpm{,build,db,io}.so

# buildreq ignore rules.
install -pD -m0644 rpm-build.buildreq -T %buildroot%_sysconfdir/buildreqs/files/ignore.d/rpm-build

chmod a+x scripts/find-lang
# Manpages have been moved to their own packages.
#./scripts/find-lang --with-man %oname rpm2cpio --output %oname.lang
RPMCONFIGDIR=./scripts ./scripts/find-lang %oname rpm2cpio --output %oname.lang

pushd %buildroot%_rpmlibdir
	for f in *-alt-%_target_os; do
		n=`echo "$f" |sed -e 's/-alt//'`
		[ -e "$n" ] || ln -s "$f" "$n"
	done
popd

ls -d %buildroot%_rpmlibdir/*-%{_target_os}* |
	grep -Fv /brp- |
	sed -e "s|^%buildroot|%%attr(-,root,%oname) |g" >>rpmbuild.platform

%if "%_lib" == "lib"
if [ -s /lib/libc.so.6 -a -s /lib/libz.so.1 -a -s /lib/librt.so.1 -a -n "$(getconf LFS_CFLAGS)" ]; then
	readelf --wide --symbols /lib/libc.so.6 /lib/libz.so.1 /lib/librt.so.1 |
		sed -n 's/^[[:space:]]*[0-9]\+:[[:space:]]\+[0-9a-f]\+[[:space:]]\+[0-9]\+[[:space:]]\+FUNC[[:space:]]\+[^[:space:]]\+[[:space:]]\+DEFAULT[[:space:]]\+[0-9]\+[[:space:]]\+\([^@[:space:]]\+\)@\?.*/\1/p' |
		sort -u
fi > all-funcs
sed -r -n 's/^(.+)64(_.*|$)/\1\2/p' all-funcs |
	sort -u |
	egrep -v '^(wcs|str)' |
	comm -12 - all-funcs |
	LC_ALL=C sort -u \
	> %buildroot%_rpmlibdir/verify-elf-non-lfs-funcs.list
%endif

mv -T %buildroot%_rpmlibdir/rpm{,build}rc
mv -T %buildroot%_rpmlibdir/{,build}macros

%pre
[ ! -L %_rpmlibdir/noarch-alt-%_target_os ] || rm -f %_rpmlibdir/noarch-alt-%_target_os ||:

%files -n librpmbuild
%_libdir/librpmbuild-*.so

%define rpmattr %attr(755,root,%oname)
%define rpmdirattr %attr(2755,root,%oname) %dir
%define rpmdatattr %attr(644,root,%oname)
%define rpmdbattr %attr(644,root,%oname) %verify(not md5 size mtime) %ghost %config(missingok,noreplace)

%files -n lib%oname
%rpmdirattr %_rpmlibdir
%rpmdatattr %_rpmlibdir/rpmbuildrc
%rpmdatattr %_rpmlibdir/buildmacros
%_libdir/librpm-*.so
%_libdir/librpmdb-*.so
%_libdir/librpmio-*.so

%files -f rpmbuild.platform
%config %_sysconfdir/buildreqs/files/ignore.d/*
%rpmattr %_bindir/gendiff
%_bindir/rpmbuild
%_bindir/relative
%_rpmlibdir/rpmt
%rpmattr %_rpmlibdir/rpmb
%rpmattr %_rpmlibdir/debugedit
%rpmattr %_rpmlibdir/debuginfo.*
%rpmattr %_rpmlibdir/dump_ld_config
%rpmattr %_rpmlibdir/filesize
%rpmattr %_rpmlibdir/relative
%rpmattr %_rpmlibdir/brp-alt
%rpmattr %dir %_rpmlibdir/brp.d
%rpmattr %_rpmlibdir/brp.d/*
%rpmattr %_rpmlibdir/*_files
%rpmattr %_rpmlibdir/cpp.*
%rpmattr %_rpmlibdir/is_elf_so_executable
%rpmattr %_rpmlibdir/ldd
%rpmattr %_rpmlibdir/rpm2cpio.sh
%rpmattr %_rpmlibdir/find-lang
%rpmattr %_rpmlibdir/find-provides
%rpmattr %_rpmlibdir/find-requires
%rpmattr %_rpmlibdir/find-debuginfo-files
%rpmattr %_rpmlibdir/process-debuginfo
%rpmattr %_rpmlibdir/find-scriptlet-requires
%rpmattr %_rpmlibdir/fixup-*
%rpmattr %_rpmlibdir/files.*
%rpmattr %config %_rpmlibdir/*-files.req.list
%rpmattr %_rpmlibdir/lib.*
%rpmattr %_rpmlibdir/pam.*
%rpmattr %_rpmlibdir/percolate
%rpmattr %_rpmlibdir/pkgconfig.*
%rpmattr %_rpmlibdir/pkgconfiglib.*
%rpmattr %_rpmlibdir/provided_symbols
%rpmattr %_rpmlibdir/rpmlib.*
%rpmattr %_rpmlibdir/shell.*
%rpmattr %_rpmlibdir/shebang.*
%rpmattr %_rpmlibdir/static.*
%rpmattr %_rpmlibdir/suggest_bpp
%rpmattr %_rpmlibdir/symlinks.*
%rpmattr %_rpmlibdir/systemd-services.*
%rpmattr %_rpmlibdir/tmpdir.sh
%rpmattr %_rpmlibdir/verify-elf
%rpmattr %_rpmlibdir/*.awk
# set-version helpers
%rpmattr %_rpmlibdir/mkset
%rpmattr %_rpmlibdir/setcmp
%rpmattr %_prefix/libexec/rpm-build
%if "%_lib" == "lib"
%rpmdatattr %_rpmlibdir/verify-elf-non-lfs-funcs.list
%endif
%rpmdatattr %_rpmlibdir/rpmpopt*

%_mandir/man?/gendiff.*
%_man8dir/rpmbuild.*

%if_with build_topdir
%files build-topdir
%attr(0755,root,%oname) %dir %_usrsrc/RPM
%attr(0770,root,%oname) %dir %_usrsrc/RPM/BUILD
%attr(2770,root,%oname) %dir %_usrsrc/RPM/SPECS
%attr(2770,root,%oname) %dir %_usrsrc/RPM/SOURCES
%attr(2775,root,%oname) %dir %_usrsrc/RPM/SRPMS
%attr(0755,root,%oname) %dir %_usrsrc/RPM/RPMS
%attr(2775,root,%oname) %dir %_usrsrc/RPM/RPMS/*
%endif #with build_topdir

%if_with python
%files -n python-module-rpm
%_libdir/python*/site-packages/*module.so
%endif #with python

%files checkinstall

%changelog
