%def_without bootstrap
%def_enable shared
%def_enable rubygems
%define ruby_version 2.5.0
%define libdir %_prefix/lib/%name
%define includedir %_includedir
%define ridir %_datadir/ri
%define vendordir %libdir/vendor_%name
%define lname lib%name

Name:     ruby
Version:  2.5.9
Release:  alt1
Summary:  An Interpreted Object-Oriented Scripting Language
License:  BSD 2-clause Simplified License/Ruby
Group:    Development/Ruby
URL:      http://www.%name-lang.org/
Source0:  %name-%version.tar
Source3:  fakeruby.sh
Source4:  miniruby.sh
Requires: %lname = %version-%release
Requires: ruby-stdlibs = %version-%release
Requires: gem irb erb ri rdoc rake bundle

%define obsolete() \
Provides: %1 = %version-%release \
Obsoletes: %1
%define mobsolete() \
%(for m in %*; do \
echo "Provides: %name-module-$m = %version-%release"; \
echo "Obsoletes: %name-module-$m"; \
done)

BuildRequires(pre): rpm-build-ruby >= 1:1.0.0
BuildRequires: doxygen groff-base libdb4-devel libffi-devel
BuildRequires: libgdbm-devel libncursesw-devel libreadline-devel libssl-devel
BuildRequires: zlib-devel libyaml-devel gcc-c++
BuildRequires: valgrind-devel
%{?!_with_bootstrap:BuildRequires: ruby ruby-stdlibs rpm-build-ruby >= 1:1.0.0}
%{?_with_bootstrap:BuildRequires: ruby-miniruby-src = %EVR}

%description
Ruby is an interpreted scripting language for quick and easy object-oriented
programming. It has many features for processing text files and performing
system management tasks (as in Perl). It is simple, straight-forward, and
extensible.

This package contains interpreter of object-oriented scripting language Ruby.


%package -n %lname
Summary: Ruby shared libraries
Group: System/Libraries
Provides: ruby(enumerator)

%description -n %lname
Ruby is an interpreted scripting language for quick and easy object-oriented
programming. It has many features for processing text files and performing system
management tasks (as in Perl). It is simple, straight-forward, and extensible.

This package contains Ruby shared libraries.


%package -n %lname-devel
Summary: Files for compiling extension modules for Ruby
Group: Development/C
%{?_enable_shared:Requires: %lname = %version-%release}
Requires: rpm-build-%name >= 1.0.0

%description -n %lname-devel
Ruby is an interpreted scripting language for quick and easy object-oriented
programming. It has many features for processing text files and performing system
management tasks (as in Perl). It is simple, straight-forward, and extensible.

This package contains files, necessary to make extension library for Ruby.


%package -n %lname-devel-static
Summary: Files for compiling extension modules for Ruby
Group: Development/C
Requires: %lname-devel = %version-%release

%description -n %lname-devel-static
Ruby is an interpreted scripting language for quick and easy object-oriented
programming. It has many features for processing text files and performing system
management tasks (as in Perl). It is simple, straight-forward, and extensible.

This package contains static Ruby library needed for embedding Ruby.

%package -n %name-stdlibs
Summary: Standard Ruby libraries
Group: Development/Ruby
Requires: %lname = %version-%release
Requires: libyaml2 libgdbm libssl1.1 libcrypto1.1
Requires: gem(rubygems-update) >= 3.0.1
Requires: gem(did_you_mean) >= 1.3.0
Requires: gem(minitest) >= 5.11.3
Requires: gem(net-telnet) >= 0.2
Requires: gem(power_assert) >= 1.1.4
Requires: gem(rake) >= 12.3.2
Requires: gem(test-unit) >= 3.2.9
Requires: gem(xmlrpc) >= 0.3.0
Requires: gem(rdoc) >= 6.1.1
Provides: %name-libs = %version-%release
Provides: %name-racc-runtime = %version
Provides: ruby(%ruby_version)
Provides: ruby(thread)
%mobsolete English bigdecimal cgi curses date-time dbm debug digest dl drb e2mmap
%mobsolete erb etc fcntl fileutils gdbm iconv math misc net nkf open3 openssl
%mobsolete optparse patterns pty readline rexml rss sdbm shell socket stringio
%mobsolete strscan syslog tracer uri wait webrick xmlrpc yaml zlib

%description -n %name-stdlibs
Ruby is an interpreted scripting language for quick and easy object-oriented
programming. It has many features for processing text files and performing
system management tasks (as in Perl). It is simple, straight-forward, and
extensible.

This package contains standard Ruby runtime libraries.


%package -n gem
Summary:   Ruby gem executable and framefork
Group:     Development/Ruby
BuildArch: noarch
Requires:  %name-stdlibs = %version
Provides:  %_bindir/gem
Provides:  %{name}gems = 3.0.1
Provides:  %name-tools
Obsoletes: %name-tools

%description -n gem
Ruby gem executable and framework.

%package -n erb
Summary:   ERB template library
Group:     Development/Ruby
BuildArch: noarch
Requires:  %name-stdlibs = %version
Provides:  %_bindir/erb
Obsoletes: %name-tools

%description -n erb
ERB template library executable and manual.

%package -n irb
Summary:   Interactive Ruby Shell
Group:     Development/Ruby
BuildArch: noarch
Requires:  %name-stdlibs = %version
Provides:  %_bindir/irb
Obsoletes: %name-tools
%obsolete  %name-tool-irb

%description -n irb
irb is the REPL(read-eval&print loop) environment for Ruby programs.

%package -n ri-doc
Summary: Ruby ri executable man page
Group: Development/Documentation
BuildArch: noarch
Requires:   %_bindir/ri
Requires:   %name = %version

%description -n ri-doc
Ruby ri executable man page

%package       doc
Summary:       Ruby ri documentation
Group:         Development/Documentation
BuildArch:     noarch
AutoReq:       no
AutoProv:      no
Provides:      %name-doc-ri
Obsoletes:     %name-doc-ri
Requires:      ri
Requires:      ruby = %version-%release

%description   doc
Ruby is an interpreted scripting language for quick and easy object-oriented
programming. It has many features for processing text files and performing system
management tasks (as in Perl). It is simple, straight-forward, and extensible.

This package contains Ruby documentation in ri format.


%if_without bootstrap
%package miniruby-src
Summary: Preprocessed miniruby sources
Group: Development/Ruby
BuildArch: noarch

%description miniruby-src
Contains generated files for preprocessed miniruby sources in patch
format. This files are required for ruby bootstrapping, especially
on different arches.
%endif

%prep
%setup -q
# More strict shebang
sed -i '1s|^#!/usr/bin/env ruby|#!%_bindir/%name|' bin/*
# Remove $ruby_version from libs path
sed -i 's|/\$(ruby_version)||g;s|\(/%name/\)#{version}/|\1|g' tool/mkconfig.rb
sed -i 's|/\${ruby_version}||' template/%name.pc.in configure.ac
sed -i -r "/ridatadir[[:blank:]]*=/s/[[:blank:]]+CONFIG\['ruby_version'\],//" tool/rbinstall.rb
sed -i 's|[[:blank:]]*"/"RUBY_LIB_VERSION$||' version.c
# capi-docs
sed -i -e '/doc\/capi/s|"/capi|"/html/capi|' -e '/doc\/capi/s|doc/capi|&/html|' tool/rbinstall.rb
# put config.guess and config.sub from /usr/share/gnu-config
cp -a /usr/share/gnu-config/config.* tool

%build
%define ruby_arch %(echo %_target | sed 's/^ppc/powerpc/')%([ -z "%_gnueabi" ] || echo "-eabi")
%autoreconf
%__setup_rb config --gem-version-replace="$RPM_RUBY_GEMVERSION_REPLACE_LIST" --use=rdoc --join=doc:lib
my_configure() {
    %configure \
        %{subst_enable shared} \
        %{subst_enable valgrind} \
        %{subst_enable rubygems} \
        --with-rubylibprefix=%libdir \
        --with-rubyhdrdir=%includedir \
        --with-sitearchdir=%libdir/site_ruby/%version/%ruby_arch \
        --with-vendorarchdir=%libdir/vendor_ruby/%version/%ruby_arch \
        --with-ridir=%ridir \
        --docdir=%_docdir/%name-%version \
        %{?ruby_version:--with-ruby-version=%ruby_version} \
        --disable-rpath "$@"
}

%if_with bootstrap
# *** 1st stage ***
# Build miniruby with preprocessed files from miniruby-src in a
# separate directory

cd %_builddir
cp -a %name-%version %name-%version-miniruby
cd %name-%version-miniruby
cp %SOURCE3 %SOURCE4 .

my_configure --with-baseruby=$PWD/fakeruby.sh
patch -p1 -l < %_datadir/%name-%version-miniruby/miniruby-src.patch
%make_build miniruby

# *** 2nd stage ***
# Build ruby with host miniruby frome 1st stage as baseruby
cd %_builddir/%name-%version
my_configure --with-baseruby=%_builddir/%name-%version-miniruby/miniruby.sh

%else #_with_bootstrap
my_configure

# Copy sources after configure, so that generated files for
# miniruby can be extracted later to facilitate bootstrapping.
cp -a %_builddir/%name-%version %_builddir/%name-%version-configured

# Build miniruby only, so that we can diff only minimal generated data.
%make_build miniruby

# Create diff for changed sources files with non-essential filtered out.
# For diff !0 exit status is normal.
pushd %_builddir
diff -Nur -x "*.o" -x miniruby -x "*.log" -x autom4te.cache \
    %name-%version-configured %name-%version > miniruby-src.patch || :
popd
%endif #_with_bootstrap

%make_build

%install
%makeinstall_std
echo "VENDOR_SPECIFIC=true" > %buildroot%vendordir/vendor-specific.rb
install -Dm 0755 %lname-static.a %buildroot%_libdir/%lname-static.a
ln -s %lname-static.a %buildroot%_libdir/%lname.a
mv %buildroot%_pkgconfigdir/%name{*,}.pc
install -d -m 0755 %buildroot%_docdir/%name-%version
mkdir -p %buildroot%ridir/%ruby_version
mv %buildroot%ridir/system %buildroot%ridir/%ruby_version/
install -d -m 0755 %buildroot%ridir/%ruby_version/site
install -p -m 0644 COPYING* LEGAL NEWS README* %buildroot%_docdir/%name-%version/
# install compiled header config.h
install -D .ext/include/%ruby_arch/ruby/config.h %buildroot%ruby_includedir/ruby/config.h

%define ruby_libdir %libdir
%define __ruby env LD_LIBRARY_PATH=%buildroot%_libdir RUBYLIB=%buildroot%libdir:%buildroot%libdir/site_ruby/%version/%ruby_arch %buildroot%_bindir/%name
export RUBYLIB=%buildroot%libdir:%buildroot%libdir/site_ruby/%version/%ruby_arch
export LD_LIBRARY_PATH=%buildroot%_libdir:%buildroot%_libdir/site_ruby/%version%ruby_arch

%add_findreq_skiplist %libdir/gems/*/gems/*/bin/*
%add_findreq_skiplist %libdir/*

%if_without bootstrap
mkdir -p %buildroot%_datadir/%name-%version-miniruby
mv %_builddir/miniruby-src.patch %buildroot%_datadir/%name-%version-miniruby/
%endif

# Make empty dir for ri documentation
mkdir -p %buildroot%_datadir/ri/site/%version
rm -rf %buildroot%_bindir/{ri,rdoc}

%check
%make_build test
%gem_test

%files
%doc %dir %_docdir/%name-%version
%doc %_docdir/%name-%version/COPYING
%doc %_docdir/%name-%version/LEGAL
%doc %_docdir/%name-%version/NEWS
%doc %_docdir/%name-%version/README.*
%lang(ja) %doc %_docdir/%name-%version/*.ja
%_bindir/%name
%_man1dir/%name.*
%dir %_datadir/ri

%files -n %lname
%{?_enable_shared:%_libdir/*.so.*}

%files -n %lname-devel
%_pkgconfigdir/*
%includedir/*
%{?_enable_shared:%_libdir/*.so}

%files -n %lname-devel-static
%_libdir/*.a

%files stdlibs
%libdir

%files -n gem
%_bindir/gem

%files -n erb
%_bindir/erb
%_man1dir/erb.*

%files -n irb
%lang(ja) %doc doc/irb/*.ja
%_bindir/irb
%_man1dir/irb.*

%files         doc
%dir %ridir/%ruby_version/site
%ridir/*

%files -n ri-doc
%_man1dir/ri.*

%if_without bootstrap
%files miniruby-src
%_datadir/%name-%version-miniruby/miniruby-src.patch
%endif

%changelog
