Name: scribus
Version: 1.5.6
Release: alt1.git742765f.1
Epoch: 1

Summary: DeskTop Publishing application written in Qt

Group: Publishing
License: GPLv2+
Url: http://www.scribus.net/

Packager: Paul Wolneykien <manowar@altlinux.ru>

# Source-url: https://github.com/scribusproject/scribus/archive/master.zip
Source: %name-%version.tar
Patch1: alt-qt5.15.patch

BuildRequires: cmake zlib-devel libssl-devel
BuildRequires: libpoppler-devel libpoppler-cpp-devel
BuildRequires: qt5-imageformats qt5-declarative-devel qt5-tools-devel

# Required from BUILDING file
BuildRequires: qt5-base-devel >= 5.5.0
BuildRequires: libfreetype-devel >= 2.1.7
BuildRequires: libcairo-devel >= 1.14.0
BuildRequires: libtiff-devel >= 3.6.0
BuildRequires: liblcms2-devel >= 2.1
BuildRequires: libjpeg-devel
BuildRequires: libharfbuzz-devel >= 0.9.42
BuildRequires: libicu-devel

# Recommended from BUILDING file
BuildRequires: libcups-devel
BuildRequires: fontconfig-devel >= 2.0
BuildRequires: libxml2-devel >= 2.6.0
BuildRequires: ghostscript > 9.0
BuildRequires: libhunspell-devel
BuildRequires: libpodofo-devel >= 0.9.6
# boost used only for 2geom
BuildRequires: boost-devel-headers
BuildRequires: GraphicsMagick
BuildRequires: libGraphicsMagick-c++-devel

BuildRequires: rpm-build-python3 python3-dev
BuildRequires: python3-module-Pillow

# TODO: build with OSG

# TODO: use system libs instead third_party
#BuildPreReq: libhyphen-devel lib2geom-devel

# For import filters
BuildRequires: libfreehand-devel libpagemaker-devel libmspub-devel libcdr-devel 
BuildRequires: libwmf-devel libvisio-devel libqxp-devel libzmf-devel

Requires: %name-doc >= %epoch:%version
Requires: %name-data >= %epoch:%version
Requires: aspell-en

%add_verify_elf_skiplist %_libdir/%name/plugins/*.so
%add_findreq_skiplist %_datadir/%name/samples/*
%add_findreq_skiplist %_datadir/%name/scripts/*

%description
Scribus is an desktop open source page layout program with
the aim of producing commercial grade output in PDF and
Postscript, primarily, though not exclusively for Linux.

While the goals of the program are for ease of use and simple easy to
understand tools, Scribus offers support for professional publishing
features, such as CMYK color, easy PDF creation, Encapsulated Postscript
import/export and creation of color separations.

%if 0
%package devel
Summary: Header files for Scribus
Group: Development/C++
BuildArch: noarch
Requires: %name = %epoch:%version-%release

%description devel
Header files for Scribus.
%endif

%package data
Summary: Data files of Scribus
Group: Publishing
BuildArch: noarch
Conflicts: %name < %epoch:%version

%description data
Data files of Scribus.

%package doc
Summary: Documentation files for Scribus
Group: Development/Tools
Conflicts: %name < %epoch:%version
BuildArch: noarch

%description doc
%summary

%prep
%setup
%patch1 -p1

%ifarch %e2k
# until lcc-1.24: strip UTF-8 BOM
find -name '*.cpp' -o -name '*.h' | xargs sed -ri 's,^\xEF\xBB\xBF,,'
%endif

%build
%cmake \
%ifarch x86_64
	-DWANT_LIB64=true \
%endif
	-DWANT_NORPATH=true \
	-DWANT_DISTROBUILD=true \
	-DWANT_CCACHE=true \
	-DWANT_GRAPHICSMAGICK=true \
	-DFONTCONFIG_CONFIG:FILEPATH=%_pkgconfigdir/fontconfig.pc \
	-DCMAKE_C_FLAGS:STRING="%optflags" \
	-DCMAKE_CXX_FLAGS:STRING="%optflags"

%cmake_build VERBOSE=1

%install
%cmakeinstall_std

pushd %buildroot%_docdir/%name
for i in $(ls ChangeLog*); do
	bzip2 $i
done
popd

%files
%dir %_docdir/%name
%doc %_docdir/%name/AUTHORS
%doc %_docdir/%name/ChangeLog*
%doc %_docdir/%name/COPYING
%doc %_docdir/%name/README
#%doc %_docdir/%name/TODO
%_bindir/%name
%_desktopdir/scribus.desktop
%_datadir/metainfo/scribus.appdata.xml
%_datadir/mime/packages/scribus.xml
%_iconsdir/hicolor/*/apps/scribus.png
%_libdir/%name/
%attr(0755,root,root) %_libdir/%name/plugins/*.so
%_man1dir/*
%exclude %_mandir/de
%exclude %_mandir/pl

%files data
%_datadir/%name

#%files devel
#%doc AUTHORS COPYING
#%_includedir/%name

%files doc
%dir %_docdir/%name
#%_docdir/%name/BUILDING
#%_docdir/%name/NEWS
#%_docdir/%name/PACKAGING
%_docdir/%name/LINKS
%_docdir/%name/TRANSLATION
%_docdir/%name/en
%exclude %_docdir/%name/de
%exclude %_docdir/%name/it

%changelog
