Name: seafile
Version: 7.0.10
Release: alt1

Summary: Full-fledged cloud storage platform

Group: Networking/File transfer
License: GPLv2 with permissions for OpenSSL
Url: https://github.com/haiwen/seafile

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/haiwen/seafile/archive/v%version.tar.gz
Source: %name-%version.tar

Source1: README.ALT.utf8.txt
Source2: nginx.conf.example

Patch: seafile-curl-7.62.patch

Requires: lib%name = %version-%release

BuildRequires: intltool libssl-devel libuuid-devel
BuildRequires: zlib-devel libjson-glib-devel
BuildRequires: vala
BuildRequires: rpm-build-python3 python3-devel

BuildRequires: libsearpc-devel >= 3.2.0

BuildRequires: libsqlite3-devel >= 3.7
BuildRequires: libevent-devel >= 2.0
BuildRequires: libarchive-devel >= 2.8.5
BuildRequires: libcurl-devel >= 7.17

%description
Seafile is a next-generation open source cloud storage system
with advanced support for file syncing, privacy protection and teamwork.

Collections of files are called libraries, and each library can be synced separately.
A library can be encrypted with a user chosen password.
This password is not stored on the server,
so even the server admin cannot view a file's contents.

Seafile allows users to create groups with file syncing,
wiki, and discussion to enable easy collaboration around documents within a team.

%package -n fuse-seafile
Summary: Seafile FUSE access
Group: Networking/File transfer
Requires: lib%name = %version-%release

%description -n fuse-seafile
Seafile FUSE access.
Seafile is a next-generation open source cloud storage system
with advanced support for file syncing, privacy protection and teamwork.

%package cli
Summary: Seafile CLI client
Group: Networking/File transfer
Requires: lib%name = %version-%release

%description cli
Seafile CLI client.

Seafile is a next-generation open source cloud storage system
with advanced support for file syncing, privacy protection and teamwork.

%package -n python3-module-seafile
Summary: Seafile client python3 module
Group: Networking/File transfer

%description -n python3-module-seafile
The python3 module with Seafile client.

%package -n lib%name
Summary: Seafile library files
Group: Networking/File transfer

%description -n lib%name
The lib%name package contains libraries for Seafile.

%package -n lib%name-devel
Summary: Development files for lib%name
Requires: lib%name = %version-%release
Group: Development/C

%description -n lib%name-devel
The lib%name-devel package contains libraries and header files for
developing applications that use lib%name.

%prep
%setup
#patch -p1
cp %SOURCE1 .
# remove buildroot from .pc file
%__subst 's/(DESTDIR)//' lib/libseafile.pc.in
#%__subst 's@#!/usr/bin/env python@#!%__python3@' app/seaf-cli

%build
%autoreconf
%configure --disable-static PYTHON=%__python3
# FIXME: breakes build
%make_build || %make

%install
%makeinstall_std

%files
%_bindir/seaf-daemon
%_man1dir/seaf-daemon*.1.*

%files cli
%_bindir/seaf-cli
%_man1dir/seaf-cli.1.*

%files -n lib%name
%_libdir/*.so.*

%files -n python3-module-seafile
%python3_sitelibdir/%name/

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/lib%name.pc

%changelog
