Name: shadow
Version: 4.5
Release: alt8
Epoch: 1

Summary: Utilities for managing shadow password files and user/group accounts
License: BSD-style
Group: System/Base
Url: ftp://ftp.pld.org.pl/software/shadow

Source0: %url/%name-%version.tar
Source1: login.defs
Source2: useradd.default
Source3: user-group-mod.pamd
Source4: chage-chfn-chsh.pamd
Source5: chpasswd-newusers.pamd
Source6: chage.control
Source7: chfn.control
Source8: chsh.control
Source9: gpasswd.control
Source10: newgrp.control
Source11: groupmems.control
Source12: groupmems.pamd
Source13: newuidmap.control
Source14: newgidmap.control

Patch: %name-%version-%release.patch

%def_disable shared
%def_with selinux
%def_with audit

BuildPreReq: mktemp >= 1:1.3.1, rpm-build >= 4.0.4-alt10
# for man pages generation
BuildRequires: xsltproc docbook-style-xsl docbook-dtds

%if_with selinux
BuildPreReq: libselinux-devel libsemanage-devel
%endif

%{?_with_audit:BuildRequires: libaudit-devel}

BuildRequires: libpam-devel libtcb-devel pam_userpass-devel
BuildRequires: libcrypt-devel >= 4.0.1-alt1

%description
This package includes the tools necessary for manipulating local user and
group databases. It supports both traditional and tcb shadow password files.

%package -n lib%name
Summary: Shadow password file routines library
Group: System/Libraries

%description -n lib%name
Shadow library manipulates local user and group databases. It supports both
traditional and tcb shadow password files.
This package contains shared library required for various shadow utils.

%package -n lib%name-devel
Summary: Development files for the shadow password file routines library
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
Shadow library manipulates local user and group databases. It supports both
traditional and tcb shadow password files.
This package contains files required for development software based
on lib%name.

%package -n lib%name-devel-static
Summary: Shadow password file routines static library
Group: Development/C
Requires: lib%name-devel = %EVR

%description -n lib%name-devel-static
Shadow library manipulates local user and group databases. It supports both
traditional and tcb shadow password files.
This package contains static library required for development statically
linked software based on lib%name.

%package utils
Summary: Utilities for managing shadow password files and user/group accounts
Group: System/Base
Requires: %name-convert = %EVR, tcb-utils >= 0.9.8
Obsoletes: adduser

%description utils
This package includes utilities for managing shadow password files and
user/group accounts:
+ useradd: creates a new user or updates default new user information;
+ userdel: deletes a user account and related files;
+ usermod: modifies a user account;
+ groupadd: creates a new group;
+ groupdel: deletes a group;
+ groupmod: modifies a group;
+ newusers: updates and creates new users in batch;
+ chpasswd: updates password file in batch.

%package check
Summary: Utilities for checking integrity of the password, group, shadow-password, or shadow-group files
Group: System/Base
Requires: %name-convert = %EVR

%description check
This package includes utilities for checking integrity of the password, group,
shadow-password, or shadow-group files:
+ pwck: verifies the integrity of the system password authentication information;
+ grpck: verifies the integrity of the system group authentication information.

%package convert
Summary: Utilities for convertion to and from shadow passwords and groups
Group: System/Base
%if_enabled shadow
Requires: lib%name = %EVR
%endif

%description convert
This package includes utilities for convertion to and from shadow passwords
and groups:
+ pwconv: creates shadow from passwd and an optionally existing shadow;
+ pwunconv: creates passwd from passwd and shadow and then removes shadow;
+ grpconv: creates gshadow from group and an optionally existing gshadow;
+ grpunconv: creates group from group and gshadow and then removes gshadow.

%package change
Summary: Utilities for changing user shell, finger and password information
Group: System/Base
Requires: %name-utils = %EVR

%description change
This package includes utilities for changing user shell, finger and password
information:
+ chage: changes the number of days between password changes and the date of
         the last password change;
+ chfn: changes user fullname, office number, office extension, and home phone
        number information for a user's account;
+ chsh: changes the user login shell.

%package edit
Summary: Utilities for editing the password, group, shadow-password, or shadow-group files
Group: System/Base
Requires: %name-utils = %EVR

%description edit
This package includes utilities for editing the password, group,
shadow-password, or shadow-group files:
+ vipw: edits the /etc/passwd and /etc/shadow files;
+ vigr: edits the /etc/group and /etc/gshadow files.

%package groups
Summary: Utilities for execute command as different group ID
Group: System/Base
Requires: %name-utils = %EVR

%description groups
This package includes utilities for execute command as different group ID:
+ gpasswd: is used to administer the /etc/group and etc/gshadow files;
+ newgrp: is used to change the current group ID during a login session;
+ sg: is used to execute command as different group ID.

%package submap
Summary: Utilities for creating uid and gid mappings in user namespaces
Group: System/Base
Requires: %name-utils = %EVR

%description submap
This package includes utilities for creating uid and gid mappings
in user namespaces:
* newuidmap: set the uid mapping of a user namespace;
* newgidmap: set the gid mapping of a user namespace.

%package log
Summary: Utilities for examining lastlog and faillog files
Group: System/Base
Requires: %name-utils = %EVR

%description log
This package includes utilities for examining lastlog and faillog files:
+ faillog: formats the contents of the system failure log file, and maintains
           failure counts and limits;
+ lastlog: formats the contents of the system last login file.

%package suite
Summary: The shadow suite
Group: System/Base
BuildArch: noarch
Requires: %name-change = %EVR
Requires: %name-check = %EVR
Requires: %name-convert = %EVR
Requires: %name-edit = %EVR
Requires: %name-groups = %EVR
Requires: %name-log = %EVR
Requires: %name-utils = %EVR
Requires: %name-submap = %EVR

%description suite
This virtual package unifies all shadow suite subpackages.

%prep
%setup
%patch -p1

%build
%autoreconf
%ifnarch %e2k
%add_optflags -Werror -Wno-error=address -Wno-error=cpp
%endif
%add_optflags -DEXTRA_CHECK_HOME_DIR
%configure \
	%{subst_enable shared} \
	--with-tcb \
	--with-libpam \
	--without-libcrack \
	%{subst_with selinux} \
	%{subst_with audit} \
	--with-group-name-max-length=32 \
	--without-sha-crypt \
	--enable-man
%make_build

%install
%makeinstall

install -pD -m640 %_sourcedir/login.defs %buildroot%_sysconfdir/login.defs
install -pD -m600 %_sourcedir/useradd.default %buildroot%_sysconfdir/default/useradd

rm -rf %buildroot%_sysconfdir/pam.d
mkdir -p %buildroot%_sysconfdir/pam.d
pushd %buildroot%_sysconfdir/pam.d
install -pm600 %_sourcedir/user-group-mod.pamd user-group-mod
ln -s user-group-mod groupadd
ln -s user-group-mod groupdel
ln -s user-group-mod groupmod
ln -s user-group-mod useradd
ln -s user-group-mod userdel
ln -s user-group-mod usermod
install -pm640 %_sourcedir/chage-chfn-chsh.pamd chage-chfn-chsh
ln -s chage-chfn-chsh chage
ln -s chage-chfn-chsh chfn
ln -s chage-chfn-chsh chsh
install -pm600 %_sourcedir/chpasswd-newusers.pamd chpasswd-newusers
ln -s chpasswd-newusers chpasswd
ln -s chpasswd-newusers newusers
install -pm600 %_sourcedir/groupmems.pamd groupmems
popd

ln -s useradd %buildroot%_sbindir/adduser

install -pD -m755 %_sourcedir/chage.control %buildroot%_controldir/chage
install -pD -m755 %_sourcedir/chfn.control %buildroot%_controldir/chfn
install -pD -m755 %_sourcedir/chsh.control %buildroot%_controldir/chsh
install -pD -m755 %_sourcedir/gpasswd.control %buildroot%_controldir/gpasswd
install -pD -m755 %_sourcedir/newgrp.control %buildroot%_controldir/newgrp
install -pD -m755 %_sourcedir/groupmems.control %buildroot%_controldir/groupmems
install -pD -m755 %_sourcedir/newuidmap.control %buildroot%_controldir/newuidmap
install -pD -m755 %_sourcedir/newgidmap.control %buildroot%_controldir/newgidmap

touch %buildroot%_sysconfdir/subuid
touch %buildroot%_sysconfdir/subgid

%find_lang %name
%define _unpackaged_files_terminate_build 1

%post convert
if [ $1 = 1 ]; then
	if [ ! -e /etc/gshadow ]; then
		%_sbindir/grpconv
	fi
	if [ ! -e /etc/shadow -a ! -e /etc/tcb ]; then
		%_sbindir/pwconv
	fi
fi

%pre change
%pre_control chage chfn chsh

%post change
%post_control -s restricted chage chfn chsh

%pre groups
%pre_control gpasswd newgrp groupmems

%post groups
%post_control -s restricted gpasswd newgrp groupmems

%pre submap
%pre_control newuidmap newgidmap

%post submap
%post_control -s restricted newuidmap newgidmap

%if_enabled shadow
%files -n lib%name
%_libdir/*.so*

%files -n lib%name-devel
%_libdir/*.so
%_man3dir/*

%files -n lib%name-devel-static
%_libdir/*.a
%endif

%files convert
%_sbindir/*conv
%_mandir/man?/*conv.*

%files utils -f %name.lang
%attr(600,root,root) %config(noreplace) %_sysconfdir/default/useradd
%attr(640,root,shadow) %config(noreplace) %_sysconfdir/login.defs
%config(noreplace) %_sysconfdir/pam.d/user-group-mod
%_sysconfdir/pam.d/groupadd
%_sysconfdir/pam.d/groupdel
%_sysconfdir/pam.d/groupmod
%_sysconfdir/pam.d/useradd
%_sysconfdir/pam.d/userdel
%_sysconfdir/pam.d/usermod
%config(noreplace) %_sysconfdir/pam.d/chpasswd-newusers
%_sysconfdir/pam.d/chpasswd
%_sysconfdir/pam.d/newusers
%_sbindir/user*
%_sbindir/group*
%_sbindir/adduser
%_sbindir/newusers
%_sbindir/chpasswd
%_man5dir/login.defs.*
%_man5dir/shadow.*
%_man8dir/chpasswd.*
%_man8dir/group*.*
%_man8dir/newusers.*
%_man8dir/user*.*
%doc README TODO
%exclude %_bindir/groupmems
%exclude %_man8dir/groupmems.*

%files check
%_sbindir/*ck
%_mandir/man?/*ck.*

%files change
%config %_controldir/chage
%config %_controldir/chfn
%config %_controldir/chsh
%attr(640,root,shadow) %config(noreplace) %_sysconfdir/pam.d/chage-chfn-chsh
%_sysconfdir/pam.d/chage
%_sysconfdir/pam.d/chfn
%_sysconfdir/pam.d/chsh
%attr(700,root,root) %verify(not mode,group) %_bindir/chage
%attr(700,root,root) %verify(not mode) %_bindir/chfn
%attr(700,root,root) %verify(not mode) %_bindir/chsh
%_mandir/man?/chage.*
%_mandir/man?/chfn.*
%_mandir/man?/chsh.*

%files edit
%_sbindir/vi??
%_mandir/man?/vi??.*

%files groups
%_sysconfdir/pam.d/groupmems
%config %_controldir/gpasswd
%config %_controldir/newgrp
%config %_controldir/groupmems
%attr(700,root,root) %verify(not mode,group) %_bindir/gpasswd
%attr(700,root,root) %verify(not mode,group) %_bindir/newgrp
%_bindir/sg
%attr(700,root,root) %verify(not mode,group) %_bindir/groupmems
%_mandir/man?/gpasswd.*
%_mandir/man?/newgrp.*
%_mandir/man?/sg.*
%_man8dir/groupmems.*

%files submap
%config(noreplace) %_sysconfdir/subuid
%config(noreplace) %_sysconfdir/subgid
%config %_controldir/newuidmap
%config %_controldir/newgidmap
%attr(700,root,root) %verify(not mode,group) %_bindir/newuidmap
%attr(700,root,root) %verify(not mode,group) %_bindir/newgidmap
%_man1dir/newuidmap.*
%_man1dir/newgidmap.*
%_man5dir/subuid.*
%_man5dir/subgid.*

%files log
%_bindir/*log
%_mandir/man?/*log.*

%files suite

%exclude %_bindir/expiry
%exclude %_sbindir/chgpasswd
%exclude %_sbindir/logoutd
%exclude %_sbindir/nologin
%exclude %_man1dir/expiry.1.*
%exclude %_man3dir/getspnam.3.*
%exclude %_man3dir/shadow.3.*
%exclude %_man5dir/gshadow.5.*
%exclude %_man5dir/passwd.5.*
%exclude %_man5dir/suauth.5.*
%exclude %_man8dir/chgpasswd.8.*
%exclude %_man8dir/logoutd.8.*
%exclude %_man8dir/nologin.8.*

%changelog
