%set_verify_elf_method unresolved=relaxed
%def_disable snapshot
%define _libexecdir %_prefix/libexec

%def_enable face_detection

%define ver_major 0.30
%define api_ver 1.0
%define gst_api_ver 1.0

Name: shotwell
Version: %ver_major.7
Release: alt1

Summary: digital photo organizer designed for the GNOME desktop environment
Group: Graphics
License: LGPL
Url: https://wiki.gnome.org/Apps/Shotwell

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%define gtk_ver 3.22
%define gexiv_ver 0.10.4
%define soup_ver 2.42

Requires: dconf
# for video-thumbnailer
Requires: gst-plugins-base%gst_api_ver gst-plugins-good%gst_api_ver gst-libav

BuildRequires(pre): meson
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libsoup-devel >= %soup_ver
BuildRequires: gstreamer%gst_api_ver-devel gst-plugins%gst_api_ver-devel
BuildRequires: libdconf-devel libdbus-glib-devel libgexiv2-devel >= %gexiv_ver
BuildRequires: libgphoto2-devel libgudev-devel libjson-glib-devel
BuildRequires: libraw-devel libexif-devel libgomp-devel
BuildRequires: libsqlite3-devel libstdc++-devel libwebkit2gtk-devel
BuildRequires: librest-devel libgee0.8-devel gcr-libs-devel
BuildRequires: desktop-file-utils yelp-tools libappstream-glib-devel
BuildRequires: vala gcr-libs-vala
BuildRequires: libgdata-devel
%{?_enable_face_detection:BuildRequires: gcc-c++ libopencv-devel}

%description
Shotwell is a digital photo organizer designed for the GNOME desktop
environment.  It allows you to import photos from disk or camera,
organize them in various ways, view them in full-window or fullscreen
mode, and export them to share with others.


%prep
%setup

%build
%add_optflags -D_GIT_VERSION=%(echo %version | tr -d .)
%meson -Dunity-support=false \
       -Dinstall-apport-hook=false \
       %{?_enable_face_detection:-Dface-detection=true}
#%%meson_build %name-pot %name-update-po
%meson_build

%install
%meson_install

%find_lang --with-gnome --output=%name.lang %name %name-extras

%files -f %name.lang
%_bindir/%name
%dir %_libexecdir/%name
%_libexecdir/%name/%name-video-thumbnailer
%_libexecdir/%name/%name-settings-migrator
%if_enabled face_detection
%_libexecdir/%name/%name-facedetect
%dir %_datadir/%name
%_datadir/%name/facedetect-haarcascade.xml
%endif
%_libdir/lib%name-plugin-common.so.*
%_libdir/lib%name-plugin-dev-%api_ver.so.*
%_libdir/lib%name-authenticator.so.*

%exclude %_libdir/lib%name-*.so

%_libdir/%name/
%_desktopdir/%{name}*
%_iconsdir/hicolor/*x*/apps/%name.png
%_iconsdir/hicolor/symbolic/apps/%name-symbolic.svg
%_datadir/glib-2.0/schemas/*
%_datadir/metainfo/%name.appdata.xml
%_man1dir/%name.1.*
%doc AUTHORS COPYING NEWS README* THANKS


%changelog
