%def_disable snapshot
%define ver_major 3.36
%define xdg_name org.gnome.SimpleScan

%def_enable packagekit

Name: simple-scan
Version: %ver_major.6
Release: alt0.p9.1

Summary: Simple scanning utility
License: GPLv3+
Group: Graphics
Url: http://launchpad.net/%name

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

Requires: sane xdg-utils gnome-icon-theme colord
%{?_enable_packagekit:Requires: packagekit}

%define gtk_ver 3.22
%define gusb_ver 0.2.7

BuildRequires(pre): meson
BuildRequires: yelp-tools libappstream-glib-devel
BuildRequires: libgtk+3-devel >= %gtk_ver libgusb-devel >= %gusb_ver
BuildRequires: libsane-devel zlib-devel
BuildRequires: vala-tools libcolord-vala
BuildRequires: libcolord-devel libwebp-devel
%{?_enable_packagekit:BuildRequires: libpackagekit-glib-devel}

%description
Simple Scan is an easy-to-use application, designed to let users connect their
scanner and quickly have the image/document in an appropriate format.

%prep
%setup
find ./ -name "*.stamp" -delete

%build
%meson %{?_disable_packagekit:-Dpackagekit=false}
%meson_build

%install
%meson_install

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/*
%_desktopdir/*
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_iconsdir/hicolor/*/apps/%{xdg_name}*.svg
%_datadir/metainfo/%name.appdata.xml
%_man1dir/*

%changelog
