# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: simplescreenrecorder
Version: 0.4.3
Release: alt1

Summary: Simple Screen Recording with OpenGL capture
License: GPL-3.0 and ISC and GPL-3.0+ and Zlib
Group: Video

Url: https://www.maartenbaert.be/simplescreenrecorder/
Source: https://github.com/MaartenBaert/ssr/archive/%version/ssr-%version.tar.gz

BuildRequires(pre): rpm-build-ninja
BuildRequires: gcc-c++
BuildRequires: cmake
BuildRequires: libavformat-devel
BuildRequires: libswscale-devel
BuildRequires: libswresample-devel
BuildRequires: pkgconfig(Qt5) >= 5.7.0
BuildRequires: pkgconfig(Qt5X11Extras)
BuildRequires: pkgconfig(alsa)
BuildRequires: pkgconfig(libpulse)
BuildRequires: pkgconfig(jack)
BuildRequires: pkgconfig(x11)
BuildRequires: pkgconfig(xfixes)
BuildRequires: pkgconfig(gl)
BuildRequires: pkgconfig(glu)
BuildRequires: pkgconfig(xi)
BuildRequires: qt5-linguist
BuildRequires: libappstream-glib
BuildRequires: libXinerama-devel
BuildRequires: libv4l-devel
BuildRequires: qt5-tools-devel

Obsoletes: simplescreenrecording

%description
%summary

%prep
%setup -n ssr-%version
f="data/simplescreenrecorder.desktop"
for s in "GenericName=Simple screen recorder" \
	"GenericName[ru]=Запись видео с экрана" \
	"Comment[ru]=Программа записи видео с экрана" ; do
	fgrep -q "${s%%=}" "$f" || echo "$s" >> "$f"
done
# XXX waiting for support for channels
##sed -i '/#define SSR_USE_AVFRAME_CHANNELS/s/TEST_AV_VERSION.*/TEST_AV_VERSION(LIBAVCODEC, 57, 0, 57, 0)/' src/Global.h

%ifarch %e2k
sed -i 's,^#ifdef __x86_64__,#if defined (__x86_64__) || defined (__e2k__),' \
	glinject/elfhacks.h
%endif

%build
%cmake \
    -GNinja \
%ifnarch %ix86 x86_64
    -DENABLE_X86_ASM=FALSE \
%endif
%ifarch %arm aarch64
    -DWITH_GLINJECT=FALSE \
%endif
%ifarch ppc64le
    -DWITH_GLINJECT=FALSE \
%endif
    -DCMAKE_BUILD_TYPE=Release \
    -DWITH_QT5=TRUE
%ninja_build -C BUILD

%install
%ninja_install -C BUILD
rm -f %buildroot%_libdir/*.la

%files
%_bindir/*
%ifnarch %arm aarch64 ppc64le
%_libdir/lib*
%endif
%_desktopdir/*
%_iconsdir/hicolor/*/apps/*
%_man1dir/*.1.*
%_datadir/%name
%_datadir/metainfo/*

%changelog
