Name: squashfs-tools
Version: 4.5.1
Release: alt1

Summary: squashfs support
License: GPLv2
Group: System/Kernel and hardware
Url: https://git.kernel.org/cgit/fs/squashfs/squashfs-tools.git/
Source: %name-%version.tar
Patch0: %name-%version-%release.patch
BuildRequires: zlib-devel liblzma-devel liblzo2-devel libzstd-devel
Provides: squashfsprogs = %version-%release
Obsoletes: squashfsprogs

%description
Squashfs is a compressed read-only filesystem for Linux. Squashfs is
intended for general read-only filesystem use, for archival use
(i.e. in cases where a .tar.gz file may be used), and in constrained
block device/memory systems (e.g. embedded systems) where low overhead
is needed.

This package contains the utilities to (un)compress squashfs images.

%prep
%setup
%patch0 -p1

%build
export CFLAGS="%optflags"
%make_build XZ_SUPPORT=1 LZO_SUPPORT=1 ZSTD_SUPPORT=1 COMP_DEFAULT=xz

%install
install -pDm755 mksquashfs %buildroot/sbin/mksquashfs
install -pDm755 unsquashfs %buildroot/%_bindir/unsquashfs
ln -sf mksquashfs %buildroot/sbin/mkfs.squashfs
ln -sf ../../sbin/mksquashfs %buildroot%_bindir/mksquashfs

%files
/sbin/*
%_bindir/*

%changelog
