%def_with boost
%def_with caml
%def_with doc
%def_with java
%def_with lua
%def_with perl5
%def_with python
%def_with python3
%def_with R
%def_with ruby
%def_with scheme
%def_with tcl

# vim:set ft=spec:
Name: swig
Version: 3.0.12
Release: alt8
Epoch: 1

Summary: Simplified Wrapper and Interface Generator (SWIG)
License: Open Source
Group: Development/C

# http://download.sourceforge.net/swig/%name-%version.tar.gz
Source: %name-%version.tar
Patch0: fix_import_package.patch
Patch1: swig308-Do-not-use-isystem.patch
Patch2: disable_gdb_interface.patch
Patch3: fix-ocaml-int64-type.patch
Patch4: fix-ocaml-tests.patch
Patch5: fix-chicken-tests.patch
# Based on https://github.com/swig/swig/commit/7c034ead322faa79ad7b94fe72250ce8a4fd5848
Patch6: upstream-issue-1259-preparation.patch
# Based on https://github.com/swig/swig/commit/7f9883011029674553a2a4b623d459f02b512458
Patch7: upstream-issue-1259.patch
# Based on https://github.com/swig/swig/commit/9825fcbab5c4ddd867432f9922bebfbec7b78af0
Patch8: upstream-issue-898.patch

%def_disable testsuite

%{?_with_boost:BuildPreReq: boost-devel}
%{?_with_caml:BuildPreReq: ocaml-findlib}
%{?_with_doc:BuildPreReq: yodl tidy htmldoc}
%{?_with_java:BuildPreReq: java-devel}
%{?_with_lua:BuildPreReq: liblua5-devel lua5}
%{?_with_perl5:BuildPreReq: perl-devel libpcre-devel}
%{?_with_python:BuildPreReq: python-devel}
%{?_with_python3:BuildPreReq: rpm-build-python3 python3-devel python-tools-2to3}
%{?_with_R:BuildPreReq: R-devel}
%{?_with_ruby:BuildPreReq: libruby-devel ruby ruby-module-etc}
%{?_with_scheme:BuildPreReq: chicken guile22-devel}
%ifarch %ix86 x86_64
%{?_with_scheme:BuildPreReq: libracket-devel racket}
%endif
%{?_with_tcl:BuildPreReq: tcl-devel}

BuildRequires: gcc-c++
BuildRequires: libXt-devel imake xorg-cf-files
BuildRequires: zlib-devel

%if_enabled testsuite
BuildRequires: perl(Math/BigInt.pm) ocaml-camlp4-devel
%endif

Provides: %name-devel = %version
Obsoletes: %name-deve
Obsoletes: %name-runtime-guile   %name-runtime-python  %name-runtime-perl  %name-runtime-ruby  %name-runtime-tcl
Requires: %name-data = %EVR

%package data
BuildArch: noarch
Summary: SWIG data files
Group: Development/C
Conflicts: %name < %EVR

%package doc
BuildArch: noarch
Summary: SWIG documentation
Group: Books/Other
Requires: %name = %EVR

%package runtime-guile
Group: System/Libraries
Summary: SWIG runtime guile library

%package runtime-perl
Group: System/Libraries
Summary: SWIG runtime perl library
Requires: %name = %EVR

%package runtime-python
Group: System/Libraries
Summary: SWIG runtime python library

%package runtime-ruby
Group: System/Libraries
Summary: SWIG runtime ruby library

%package runtime-tcl
Group: System/Libraries
Summary: SWIG runtime tcl library

%description
SWIG takes an interface description file written in a combination of C/C++
and special directives and produces interfaces to Perl, Python, and Tcl.
It allows scripting languages to use C/C++ code with minimal effort.

%description doc
SWIG takes an interface description file written in a combination of C/C++
and special directives and produces interfaces to Perl, Python, and Tcl.
It allows scripting languages to use C/C++ code with minimal effort.

This package contains SWIG documentation.

%description data
SWIG takes an interface description file written in a combination of C/C++
and special directives and produces interfaces to Perl, Python, and Tcl.
It allows scripting languages to use C/C++ code with minimal effort.

This package contains SWIG data files.

%description runtime-guile
SWIG takes an interface description file written in a combination of C/C++
and special directives and produces interfaces to Perl, Python, and Tcl.
It allows scripting languages to use C/C++ code with minimal effort.

This package contains SWIG runtime guile library.

%description runtime-perl
SWIG takes an interface description file written in a combination of C/C++
and special directives and produces interfaces to Perl, Python, and Tcl.
It allows scripting languages to use C/C++ code with minimal effort.

This package contains SWIG runtime perl library.

%description runtime-python
SWIG takes an interface description file written in a combination of C/C++
and special directives and produces interfaces to Perl, Python, and Tcl.
It allows scripting languages to use C/C++ code with minimal effort.

This package contains SWIG runtime python library.

%description runtime-ruby
SWIG takes an interface description file written in a combination of C/C++
and special directives and produces interfaces to Perl, Python, and Tcl.
It allows scripting languages to use C/C++ code with minimal effort.

This package contains SWIG runtime ruby library.

%description runtime-tcl
SWIG takes an interface description file written in a combination of C/C++
and special directives and produces interfaces to Perl, Python, and Tcl.
It allows scripting languages to use C/C++ code with minimal effort.

This package contains SWIG runtime tcl library.

%prep
%setup
%patch0 -p2
%patch1 -p1
%patch2 -p1
%if_enabled testsuite
%patch3 -p2
%patch4 -p2
%patch5 -p2
%endif
%patch6 -p2
%patch7 -p2
%patch8 -p1

%build
./autogen.sh
sed -i 's/PYLIBDIR="lib"/PYLIBDIR="%_lib"/' configure
sed -i 's/PY3LIBDIR="lib"/PY3LIBDIR="%_lib"/' configure
%configure \
	%{?_with_python:--with-python=python} \
	%{?_with_python3:--with-python3=python3} \
	%{?_with_caml:--with-ocamlc=ocamlc} \
	%{subst_with boost} \
	%{subst_with java} \
	%{subst_with perl5} \
	%{subst_with ruby} \
	%{subst_with tcl} \
	--with-pyinc=%_includedir/python%_python_version \
	--with-pylib=%_libdir/python%_python_version \
	--with-tclconfig=%_libdir
	#--with-tcl --with-python --with-perl5 --with-java --with-guile --with-ruby

#%__subst -p 's,/usr/local/include/Py,%_includedir/python%__python_version,g' Runtime/Makefile
# SMP incompatible
# no `all' target
%make_build
#%make docs
#%make runtime
#pushd Runtime
#%make
#popd
xz -9fk CHANGES TODO

%install
%makeinstall_std \
	M4_INSTALL_DIR=%buildroot%_datadir/aclocal
mkdir -p %buildroot%_includedir
cp -aL Source/Swig/*.h Source/DOH/*.h Source/Include/*.h \
	%buildroot%_includedir/
# symlinks
#__rm -fv Examples/perl Examples/test-suite/perl Examples/GIFPlot/Php4

%define docdir %_docdir/%name-%version
rm -rf %buildroot%docdir
mkdir -p %buildroot%docdir
install -p -m644 ANNOUNCE CHANGES* COPYRIGHT LICENSE* README RELEASENOTES TODO* \
	%buildroot%docdir/
cp -a Examples Doc %buildroot%docdir/

#pushd Runtime
#%make_install install DESTDIR=%buildroot
#popd

%if_enabled testsuite
%check
%__make check
%endif

%files
%_bindir/*
#%_datadir/aclocal/%name.m4
%_includedir/*
%dir %docdir
%docdir/[A-Z][A-Z]*

%files doc
%dir %docdir
%docdir/[A-Z][a-z]*
#%_man1dir/*

%files data
%_datadir/%{name}

#%files runtime-guile
#%_libdir/libswigguile*.so*
#%doc CHANGES.current LICENSE

#files runtime-perl
#_libdir/libswigpl*.so*
#doc CHANGES.current LICENSE

#%files runtime-python
#%_libdir/libswigpy*.so*
#%doc CHANGES.current LICENSE

#%files runtime-ruby
#%_libdir/libswigrb*.so*
#%doc CHANGES.current LICENSE

#%files runtime-tcl
#%_libdir/libswigtcl*.so*
#%doc CHANGES.current LICENSE

%changelog
