# BEGIN SourceDeps(oneline):
BuildRequires: rpm-build-java
# END SourceDeps(oneline)
BuildRequires: /proc
BuildRequires: jpackage-generic-compat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Because dash is not allowed in RPM version numbers
%global real_version 1.6.5-1

Name:           swingx
Version:        1.6.5.1
Release:        alt2_9jpp8
Summary:        A collection of Swing components
License:        LGPLv2
Group:          Development/Other
Url:            https://swingx.java.net/
# Generated by
# svn export https://svn.java.net/svn/swingx~svn/tags/swingx-project-1.6.5-1/
# tar -cJf swingx-project-1.6.5-1.tar.xz swingx-project-1.6.5-1
Source0:        swingx-project-%{real_version}.tar.xz

# Remove dep that is not needed for successful test run
Patch0:         swingx-remove-jhlabs-filters.patch
# Remove use of internal com.sun API for Java 7 compatibility
Patch1:         swingx-java7-swing-painter-compat.patch
# Accomodate in tests for extra validation performed in Java 7
Patch2:         swingx-java7-treepath-compat.patch
# These two tests fail for an unknown reason
Patch3:         swingx-uititlelabel-test-failure.patch
# Handle Java 8 verisons
Patch4:         swingx-java8-compat.patch

BuildArch:      noarch

BuildRequires:      maven-local
BuildRequires:      mvn(net.java:jvnet-parent:pom:)
BuildRequires:      mvn(org.kohsuke.metainf-services:metainf-services)
BuildRequires:      mvn(org.mockito:mockito-core)
BuildRequires:      java-devel >= 1.6.0
BuildRequires:      jpackage-utils

Requires:           java >= 1.6.0
Requires:           jpackage-utils
Source44: import.info

%description
SwingX contains a collection of powerful, useful, and just plain fun Swing
components. Each of the Swing components have been extended, providing
data-aware functionality out of the box. New useful components have been
created like the JXDatePicker, JXTaskPane, and JXImagePanel.


%package javadoc
Summary:        Javadocs for %{name}
Group:          Development/Java
Requires:       jpackage-utils
BuildArch: noarch

%description javadoc
This package contains the API documentation for %{name}.


%prep
%setup -q -n %{name}-project-%{real_version}
%patch0 -p1 -b .orig
%patch1 -p0 -b .orig
%patch2 -p0 -b .orig
%patch3 -p0 -b .orig
%patch4 -p0 -b .orig

# Remove all binaries
find . -name "*.jar" -exec rm -f {} \;
find . -name "*.class" -exec rm -f {} \;
find . -name "*.so" -exec rm -f {} \;
find . -name "*.dll" -exec rm -f {} \;

# Remove test dep not in Fedora
%pom_remove_dep com.jhlabs:filters
%pom_remove_dep com.jhlabs:filters swingx-core
%pom_remove_dep com.jhlabs:filters swingx-painters


%build
%mvn_build -f


%install
%mvn_install


%files -f .mfiles
%doc COPYING


%files javadoc -f .mfiles-javadoc
%doc COPYING


%changelog
