%define oname synergy

Summary:	Mouse and keyboard sharing utility
Name:		synergy1
Version:	1.12.0
Release:	alt1
License:	GPLv2
Group:		Accessibility
URL:		http://synergy-project.org/
Source0:	%oname-%version.tar
Source1:	googletest.tar.gz
Patch0:		%oname-%version-alt.patch

Packager:	Evgeny Sinelnikov <sin@altlinux.org>

# Automatically added by buildreq on Fri Sep 28 2007
BuildRequires: gcc-c++ libXtst-devel
BuildRequires: libcurl-devel
BuildRequires: libcryptopp-devel
BuildRequires: libssl-devel
BuildRequires: qt5-base-devel
BuildRequires: qt5-tools-devel
BuildRequires: libavahi-devel
BuildRequires: cmake

Conflicts: synergy

%description
Synergy lets you easily share a single mouse and keyboard between
multiple computers with different operating systems, each with its own
display, without special hardware. It's intended for users with
multiple computers on their desk since each system uses its own
display.

%prep
%setup -q -n %oname-%version
%patch0 -p1
tar -xf %SOURCE1

%build
%cmake
%cmake_build VERBOSE=1 WITH_TEST=1

%install
%cmakeinstall_std
install -D -m0644 doc/synergy.conf.alt %buildroot%_sysconfdir/synergy.conf
install -D -m0644 doc/synergys.man %buildroot/%_man1dir/synergys.1
install -D -m0644 doc/synergyc.man %buildroot/%_man1dir/synergyc.1

%files
%doc ChangeLog LICENSE README.md
%doc doc/synergy.conf*
%_bindir/synergy
%_bindir/syntool
%_bindir/synergyc
%_bindir/synergys
%_desktopdir/synergy*
%_iconsdir/hicolor/scalable/apps/synergy.svg
%config(noreplace) %_sysconfdir/synergy.conf
%_man1dir/synergys*
%_man1dir/synergyc*

%changelog
