# vim: set ft=spec: -*- rpm-spec -*-
%define        pkgname taskjuggler

Name:          %pkgname
Version:       3.6.0
Release:       alt2
Summary:       TaskJuggler - Project Management beyond Gantt chart drawing
Group:         Office
License:       GPLv2
URL:           http://www.taskjuggler.org
%vcs           https://github.com/taskjuggler/TaskJuggler.git
BuildArch:     noarch

Source:        %name-%version.tar
BuildRequires(pre): rpm-build-ruby
BuildRequires: gem(term-ansicolor)
BuildRequires: gem(mail)

%add_findreq_skiplist %ruby_gemslibdir/**/*

%description
TaskJuggler is a modern and powerful project management tool. Its new
approach to project planning and tracking is far superior to the
commonly used Gantt chart editing tools. It has already been
successfully used in many projects and scales easily to projects with
hundreds of resources and thousands of tasks. It covers the complete
spectrum of project management tasks from the first idea to the
completion of the project. It assists you during project scoping,
resource assignment, cost and revenue planning, and risk and
communication management.


%package       -n gem-%pkgname
Summary:       Library for %gemname gem
Summary(ru_RU.UTF-8): Библиотечные файлы для самоцвета %gemname
Group:         Development/Ruby
BuildArch:     noarch

%description   -n gem-%pkgname
Library for %gemname gem.

%description   -n gem-%pkgname -l ru_RU.UTF8
Библиотечные файлы для %gemname самоцвета.


%package       -n gem-%pkgname-doc
Summary:       Documentation files for %gemname gem
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета %gemname
Group:         Development/Documentation
BuildArch:     noarch
Provides:      %pkgname-doc
Obsoletes:     %pkgname-doc

%description   -n gem-%pkgname-doc
Documentation files for %gemname gem.

%description   -n gem-%pkgname-doc -l ru_RU.UTF8
Файлы сведений для самоцвета %gemname.


%prep
%setup

%build
%ruby_build

%install
%ruby_install

%check
%ruby_test

%files
%doc README*
#%_bindir/tj3*
#%_mandir/*

%files         -n gem-%pkgname
%ruby_gemspec
%ruby_gemlibdir

%files         -n gem-%pkgname-doc
%ruby_gemdocdir

%changelog
