%def_with test
%define major 8.6

Name: tcl
Version: 8.6.9
Release: alt1

Summary: A Tool Command Language (TCL)
License: BSD
Group: Development/Tcl
Url: http://www.tcl.tk/

# git://git.altlinux.org/gears/t/tcl.git
Source: %name-%version-%release.tar

BuildRequires(pre): rpm-build-tcl >= 0.4-alt1
%{?_with_test:BuildConflicts: tcl-vfs}
BuildRequires: zlib-devel

Conflicts: tcl-readline < 2.1.1-alt8

%package -n lib%name
Summary: A Tool Command Language (TCL) - shared library
Group: System/Libraries
Provides: %_tcllibdir
Provides: %_tcldatadir

%package devel
Summary: Header files and C programming manual for TCL
Group: Development/C
Requires: %name
Requires: rpm-build-tcl >= 0.5-alt1

%description
The Tcl (Tool Command Language) provides a powerful platform for
creating integration applications that tie together diverse
applications, protocols, devices, and frameworks.  When paired with
the Tk toolkit, Tcl provides the fastest and most powerful way to
create GUI applications that run on PCs, Unix, and the Macintosh.  Tcl
can also be used for a variety of web-related tasks and for creating
powerful command languages for applications.

%description -n lib%name
The Tcl (Tool Command Language) provides a powerful platform for
creating integration applications that tie together diverse
applications, protocols, devices, and frameworks.  When paired with
the Tk toolkit, Tcl provides the fastest and most powerful way to
create GUI applications that run on PCs, Unix, and the Macintosh.  Tcl
can also be used for a variety of web-related tasks and for creating
powerful command languages for applications.

This package includes shared Tcl library only.

%description devel
The Tcl (Tool Command Language) provides a powerful platform for
creating integration applications that tie together diverse
applications, protocols, devices, and frameworks.  When paired with
the Tk toolkit, Tcl provides the fastest and most powerful way to
create GUI applications that run on PCs, Unix, and the Macintosh.  Tcl
can also be used for a variety of web-related tasks and for creating
powerful command languages for applications.

This package includes header files and C programming manuals for Tcl.

%prep
%setup

%build
pushd unix
%autoreconf
%configure --disable-rpath --enable-threads
make all
popd

%install
%define docdir %_defaultdocdir/%name-%version
%define __tclsh %buildroot%_bindir/.tclsh

%make_install INSTALL_ROOT=%buildroot install -C unix
mkdir -p %buildroot%_tcllibdir %buildroot%_tcldatadir %buildroot%docdir
install -p -m0644 -D tcl.m4 %buildroot%_datadir/aclocal/tea.m4
ln -sf tclsh%major %buildroot%_bindir/tclsh
ln -sf lib%name%major.so %buildroot%_libdir/lib%name.so
ln -s ../unix/tclUnixPort.h %buildroot%_includedir/tcl/generic/tclUnixPort.h
cat <<EOF > %__tclsh
#!/bin/sh
LD_LIBRARY_PATH=%buildroot%_libdir; export LD_LIBRARY_PATH
TCL_LIBRARY=%buildroot%_tcldatadir/%name%major; export TCL_LIBRARY
exec %buildroot%_bindir/tclsh "\$@"
EOF
chmod +x %__tclsh
bzip -9f ChangeLog changes
install -pm0644 README license.terms changes.bz2 ChangeLog.bz2 %buildroot%docdir

%check
# skip clock.test due lack of /etc/localtime in the build environment (ALT#35848)
rm -f tests/clock.test
pushd unix
make test
popd

%files
%dir %docdir
%docdir/README
%docdir/license.terms
%docdir/changes.*

%_bindir/tclsh*

%_tcldatadir/tcl8
%_tcldatadir/%name%major
%exclude %_tcldatadir/%name%major/%{name}AppInit.c
%exclude %_tcldatadir/%name%major/auto.tcl
%exclude %_tcldatadir/%name%major/init.tcl
%exclude %_tcldatadir/%name%major/package.tcl

%_man1dir/*
%_mandir/mann/*

%files -n lib%name
%dir %_tcllibdir
%dir %_tcldatadir
%dir %_tcldatadir/%name%major
%_libdir/lib%name%major.so

%_tcldatadir/%name%major/auto.tcl
%_tcldatadir/%name%major/init.tcl
%_tcldatadir/%name%major/package.tcl

%files devel
%docdir/ChangeLog.*
%_includedir/*
%_pkgconfigdir/%name.pc
%_libdir/lib%name.so
%_libdir/lib%{name}stub%{major}.a
%_libdir/%{name}Config.sh
%_libdir/%{name}ooConfig.sh
%_tcldatadir/%name%major/%{name}AppInit.c
%_datadir/aclocal/*.m4
%_man3dir/*

%changelog
