%def_disable static
%def_disable gtk_doc
%def_enable introspection
%define api_ver 0.2

Name: telepathy-logger
Version: 0.8.2
Release: alt1

Summary: Telepathy client that logs information received by the Telepathy framework
License: LGPLv2.1+
Group: Networking/Instant messaging
Url: http://telepathy.freedesktop.org/

Source: http://telepathy.freedesktop.org/releases/%name/%name-%version.tar.bz2

Requires: lib%name = %version-%release
Requires: libtelepathy-mission-control >= 5.4.0

BuildRequires: gtk-doc intltool libgio-devel >= 2.28.0
BuildRequires: libdbus-devel libdbus-glib-devel libtelepathy-glib-devel >= 0.19.2
BuildRequires: libxml2-devel
BuildRequires: libsqlite3-devel python-module-twisted-words python-module-xmpp
%{?_enable_introspection:BuildRequires: libtelepathy-glib-gir-devel}

# some tests require x11
# for check
#BuildRequires: /proc dbus

%description
tp-logger is a headless observer client that logs information received by the
Telepathy framework. It features pluggable backends to log different sorts of
messages, in different formats.

%package -n lib%name
Summary: Telepathy framework - tp-logger library
Group: System/Libraries

%description -n lib%name
tp-logger is a headless observer client that logs information received by the
Telepathy framework. It features pluggable backends to log different sorts of
messages, in different formats.

This package contains telepathy-logger shared library.

%package -n lib%name-devel
Summary: Development libraries and header files for %name library
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
Development libraries and header files for %name.

%package -n lib%name-devel-doc
Summary: Development documentation for %name
Group: Development/C
BuildArch: noarch
Conflicts: lib%name < %version

%description -n lib%name-devel-doc
This package contains development documentation for %name library.

%package -n lib%name-gir
Summary: GObject introspection data for %name library
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for %name library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for %name library
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %version-%release
Requires: lib%name-devel = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for %name library.


%prep
%setup

%build
%autoreconf
%configure \
	--disable-schemas-compile \
	%{subst_enable static} \
	%{?_enable_gtk_doc:--enable-gtk-doc}

%make_build

%check
# x11 session required
#%%make check

%install
%makeinstall_std

%files
%_libexecdir/%name
%_datadir/telepathy/clients/Logger.client
%_datadir/dbus-1/services/*
%config %_datadir/glib-2.0/schemas/*
%doc AUTHORS NEWS README

%files -n lib%name
%_libdir/lib%name.so.*

%files -n lib%name-devel
%_includedir/%name-%api_ver
%_libdir/lib%name.so
%_libdir/pkgconfig/%name-%api_ver.pc

%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/*

%if_enabled introspection
%files -n lib%name-gir
%_libdir/girepository-1.0/*

%files -n lib%name-gir-devel
%_datadir/gir-1.0/*
%endif


%changelog
