%def_enable largefile
%def_with remap
%def_with readline
%def_with ipv6

Name: tftp
%define dname %{name}d
Version: 5.2
Release: alt2
Summary: The client for the Trivial File Transfer Protocol (TFTP)
License: BSD
Group: Networking/File transfer
URL: http://www.kernel.org/pub/software/network/%name
Source0: %url/%name-hpa-%version.tar
Source1: %name.xinetd.in
Source2: %dname.init.in
Source3: %dname.sysconfig.in
Source4: tftp.service.in
Source5: tftp.socket
Patch: %name-%version-%release.patch
%define sys_user %name
%define sys_group %name
%define bootdir %_localstatedir/%{name}boot

%{?_with_readline:BuildRequires: libreadline-devel}

%description
The Trivial File Transfer Protocol (TFTP) is normally used only for
booting diskless workstations. This package provides the user interface
for TFTP, which allows users to transfer files to and from a remote
machine. This program, and TFTP, provide very little security, and
should not be enabled unless it is expressly needed.


%package -n %{name}d
Summary: The server for the Trivial File Transfer Protocol (TFTP)
Group: System/Servers
Provides: %name-server-common = %version-%release
Conflicts: %name-server < 5.0-alt1

%description -n %{name}d
The Trivial File Transfer Protocol (TFTP) is normally used only for
booting diskless workstations. This package provides the server for
TFTP, which allows users to transfer files to and from a remote
machine. TFTP provides very little security, and should not be enabled
unless it is expressly needed.


%package server-standalone
Summary: The server for the Trivial File Transfer Protocol (TFTP) - standalone mode
Group: System/Servers
BuildArch: noarch
Requires: %{name}d >= 0.49-alt1
Conflicts: %name-server = 0.49-alt1

%description server-standalone
The Trivial File Transfer Protocol (TFTP) is normally used only for
booting diskless workstations. This package provides the server for
TFTP, which allows users to transfer files to and from a remote
machine. TFTP provides very little security, and should not be enabled
unless it is expressly needed.
This package provides script for run TFTP server in standalone mode
with /sbin/service, disabled by default on a ALT Linux systems.


%package server-xinetd
Summary: The server for the Trivial File Transfer Protocol (TFTP) - xinetd mode
Group: System/Servers
Provides: %name-server = %version-%release
Obsoletes: %name-server < %version-%release
BuildArch: noarch
Requires: %{name}d
Conflicts: %name-server < 5.0-alt1

%description server-xinetd
The Trivial File Transfer Protocol (TFTP) is normally used only for
booting diskless workstations. This package provides the server for
TFTP, which allows users to transfer files to and from a remote
machine. TFTP provides very little security, and should not be enabled
unless it is expressly needed.
This package provides script for run TFTP server via xinetd, disabled
by default on a ALT Linux systems.


%package doc
Summary: Documentation for TFTP server and client
Group: Documentation
BuildArch: noarch

%description doc
The Trivial File Transfer Protocol (TFTP) is normally used only for
booting diskless workstations.
This package provides documentation for TFTP client and server.


%prep
%setup -n %name-hpa-%version
%patch -p1
install -m 0644 %SOURCE1 ./%name.xinetd.in
install -m 0644 %SOURCE2 ./%dname.init.in
install -m 0644 %SOURCE3 ./%dname.sysconfig.in
install -m0644 %SOURCE4  .

%build
%define _optlevel s
%autoreconf
%configure \
    %{subst_enable largefile} \
    %{subst_with remap} \
    %{subst_with readline} \
    %{subst_with ipv6}

%make_build

for f in %name.xinetd %dname.sysconfig %dname.init tftp.service; do
    sed 's|@USER@|%sys_user|g;s|@BOOTDIR@|%bootdir|g' $f.in > $f
done

bzip2 --best --keep --force CHANGES


%install
%make_install INSTALLROOT=%buildroot install
ln -sf {in.,%buildroot%_sbindir/}%dname
install -D -m 0640 %name.xinetd %buildroot%_sysconfdir/xinetd.d/%name
install -D -m 0644 %dname.sysconfig %buildroot%_sysconfdir/sysconfig/%dname
install -D -m 0755 %dname.init %buildroot%_initdir/%dname
install -D -m 0644 %name.service %buildroot%_unitdir/%name.service
install    -m 0644 %SOURCE5 %buildroot%_unitdir/%name.socket
install -d -m 0755 %buildroot{%bootdir,%_docdir/%name-%version}
install -m 0644 CHANGES.* README* %buildroot%_docdir/%name-%version/


%post -n %{name}d
%_sbindir/groupadd -rf %sys_group ||:
%_sbindir/useradd -r -g %sys_group -d /dev/null -s /dev/null -n %sys_user &>/dev/null ||:

%post server-standalone
%post_service %dname ||:

%preun server-standalone
%preun_service %dname ||:


%files
%_bindir/*
%_man1dir/*


%files -n %{name}d
%_unitdir/*
%_sbindir/*
%_man8dir/*
%dir %bootdir


%files server-standalone
%config(noreplace) %_sysconfdir/sysconfig/*
%_initdir/*


%files server-xinetd
%config(noreplace) %_sysconfdir/xinetd.d/*


%files doc
%_docdir/%name-%version


%changelog
