# Spec file for TinyCA2 utility
# --with/--without options: 'ru'

%define with_ru 0
%if_with ru
  %define with_ru 1
%endif

Name: tinyca2
Version: 0.7.5
Release: alt5

Summary: graphical tool for managing a Certification Authority
Summary(ru_RU.UTF-8): графическая утилита для управления Certification Authority

License: GPL
Group: Security/Networking
#URL: http://tinyca.sm-zone.net/
URL: https://github.com/simonswine/tinyca2_debian

Packager: Nikolay A. Fetisov <naf@altlinux.ru>
BuildArch: noarch

Provides: tinyca = %version
Obsoletes: tinyca

Source0: %name-%version.tar
#Source1: %%name.png
Source2: %name.po

Source3: %name-16.png
Source4: %name-32.png
Source5: %name-48.png

Patch0: %name-0.7.0-alt-ru_po.patch
Patch1: %name-0.7.2-alt-Gtk2_init.patch
Patch2: %name-0.72-alt-desktop_l10n.patch

Patch3: %name-0.7.5_6-alt-sha1.patch
Patch4: %name-0.7.5_6-alt-sha256.patch
Patch5: %name-0.7.5_6-alt-sort.patch

BuildRequires: perl-devel, perl-Glib, perl-Gtk2, perl-Locale-gettext
Requires: openssl

%description
TinyCA2 is a graphical tool written in Perl/Gtk2 to manage a small
Certification Authority (CA) using openssl.

TinyCA2 supports
- creation and revocation of x509 - S/MIME certificates.
- PKCS#10 requests.
- exporting certificates as PEM, DER, TXT, and PKCS#12.
- server certificates for use in web servers, email servers, IPsec,
  and more.
- client certificates for use in web browsers, email clients, IPsec,
  and more.
- creation and management of SubCAs


%description -l ru_RU.UTF-8
TinyCA2  -  написанная на Perl/GTK2 графическая утилита для 
управления Certification Authority (CA) небольших размеров, 
с использованием openssl.

TinyCA2 поддерживает:
- создание и отзыв сертификатов x509 и S/MIME
- запросы PKCS#10
- экспорт сертификатов в форматах PEM, DER, TXT и PKCS#12
- управление серверными сертификатами для использования с серверами 
  web, email, с IPsec, и т.д.
- управление клиентскими сертификатами для использования в браузерах,
  почтовых клиентах, для IPsec и пр.
- создание и управление SubCA


%define libdir		%_datadir/tinyca
%define templatesdir	%_sysconfdir/tinyca
%define localedir	%_datadir/locale

# Defining _perl_lib_path for correct work of AutoReqProv
%define _perl_lib_path %libdir

%prep
%setup

%if "%with_ru" == "1"
%patch0 -p1
%endif

%patch1 -p1
%patch2

%patch3
%patch4
%patch5

%if "%with_ru" == "1"
  /bin/install -m 0644 %SOURCE2 po/ru.po
  /bin/mkdir -p locale/ru/LC_MESSAGES
%endif

%build
# Configure sources
./install.sh

sed -e 's@./lib@%libdir@g' -i %name
sed -e 's@./templates@%templatesdir@g' -i %name
sed -e 's@./locale@%localedir@g' -i %name
/usr/bin/make -C po

%install
%if "%with_ru" == "1"
  LANGUAGES="de es cs fr sv ru"
%else
  LANGUAGES="de es cs fr sv"
%endif

/bin/mkdir -p -- %buildroot%_bindir
/bin/mkdir -p -- %buildroot%libdir
/bin/mkdir -p -- %buildroot%libdir/GUI
/bin/mkdir -p -- %buildroot%templatesdir

/bin/install -m 0644 -- lib/*.pm %buildroot%libdir/
/bin/install -m 0644 -- lib/GUI/*.pm %buildroot%libdir/GUI/
/bin/install -m 0644 -- templates/openssl.cnf %buildroot%templatesdir/
/bin/install -m 0755 -- %name %buildroot%_bindir/

for LANG in $LANGUAGES; do
   /bin/mkdir -p -- %buildroot%localedir/$LANG/LC_MESSAGES/
   /bin/install -D -m 0644 -- locale/$LANG/LC_MESSAGES/%name.mo %buildroot%localedir/$LANG/LC_MESSAGES/%name.mo
done

/bin/mkdir -p -- %buildroot%_desktopdir
/bin/install -m 0644 -- %name.desktop %buildroot%_desktopdir

/bin/mkdir -p -- %buildroot%_miconsdir %buildroot%_liconsdir %buildroot%_niconsdir
/bin/install -m 0644 -- %SOURCE3 %buildroot%_miconsdir/%name.png
/bin/install -m 0644 -- %SOURCE4 %buildroot%_niconsdir/%name.png
/bin/install -m 0644 -- %SOURCE5 %buildroot%_liconsdir/%name.png

%find_lang %name

%files -f %name.lang
%doc CHANGES INSTALL

%_bindir/%name
%{libdir}*
%dir %templatesdir
%config %templatesdir/openssl.cnf
%_desktopdir/%name.desktop
%_miconsdir/%{name}*
%_niconsdir/%{name}*
%_liconsdir/%{name}*

%changelog
