%define major 8.6

%add_tcl_req_skip ttk::theme::default

Name: tk
Version: 8.6.9
Release: alt1

Summary: A Tk toolkit fot Tcl scripting language
License: BSD
Group: Development/Tcl
Url: http://www.tcl.tk/

# git://git.altlinux.org/gears/t/tk.git
Source: %name-%version-%release.tar

BuildRequires(pre): rpm-build-tcl >= 0.5-alt1
BuildRequires: tcl-devel = %version libXt-devel libXft-devel libXScrnSaver-devel
Requires: tcl = %version lib%name

Provides: tcl(Ttk) = %version

%package -n lib%name
Summary: A Tk toolkit fot Tcl scripting language - shared library
Group: System/Libraries

%package devel
Summary: Header files and C programming manual for Tk
Group: Development/C
Requires: %name  tcl-devel = %version

%package demos
Summary: A collection of programs to demonstrate the features of the Tk toolkit
Group: Development/Tcl
BuildArch: noarch
Requires: %name

%description
Tk is a X Windows widget set designed to work closely with the tcl
scripting language. It allows you to write simple programs with full
featured GUI's in only a little more time then it takes to write a
text based interface. Tcl/Tk applications can also be run on Windows
and Macintosh platforms.

%description -n lib%name
Tk is a X Windows widget set designed to work closely with the tcl
scripting language. It allows you to write simple programs with full
featured GUI's in only a little more time then it takes to write a
text based interface. Tcl/Tk applications can also be run on Windows
and Macintosh platforms.

This package includes shared tk library only.

%description devel
Tk is a X Windows widget set designed to work closely with the tcl
scripting language. It allows you to write simple programs with full
featured GUI's in only a little more time then it takes to write a
text based interface. Tcl/Tk applications can also be run on Windows
and Macintosh platforms.

This package includes header files and C programming manual for Tk.

%description demos
Tk is a X Windows widget set designed to work closely with the tcl
scripting language. It allows you to write simple programs with full
featured GUI's in only a little more time then it takes to write a
text based interface. Tcl/Tk applications can also be run on Windows
and Macintosh platforms.

This package contains a collection of programs to demonstrate
the features of the Tk toolkit.

%prep
%setup

%build
pushd unix
%autoreconf
%configure \
	--disable-rpath \
	--enable-threads \
	--enable-xft \
	#
%make_build
popd

%install
%define docdir %_defaultdocdir/%name-%version
%make_install INSTALL_ROOT=%buildroot install -C unix
ln -sf wish%major %buildroot%_bindir/wish
ln -sf lib%name%major.so %buildroot%_libdir/lib%name.so
ln -s ../unix/tkUnixPort.h %buildroot%_includedir/tk/generic/tkUnixPort.h

mkdir -p %buildroot%docdir
bzip -9f changes ChangeLog
install -pm0644 README license.terms changes.bz2 ChangeLog.bz2 %buildroot%docdir

%files
%dir %docdir
%docdir/README
%docdir/license.terms
%docdir/changes.*

%_bindir/wish*
%dir %_tcldatadir/%name%major
%_tcldatadir/%name%major/*
%_tcllibdir/%name%major/pkgIndex.tcl
%exclude %_tcldatadir/%name%major/demos
%exclude %_tcldatadir/%name%major/%{name}AppInit.c
%_man1dir/*
%_mandir/mann/*

%files -n lib%name
%_libdir/lib%name%major.so

%files devel
%docdir/ChangeLog.*
%_includedir/*
%_pkgconfigdir/%name.pc
%_libdir/lib%name.so
%_libdir/lib%{name}stub%{major}.a
%_libdir/%{name}Config.sh
%_tcldatadir/%name%major/%{name}AppInit.c
%_man3dir/*

%files demos
%_tcldatadir/%name%major/demos

%changelog
