%define _unpackaged_files_terminate_build 1

%define _optlevel s
%def_enable qt

%define rname Transmission
%define dname transmission-daemon

Name: transmission
Version: 3.00
Release: alt2

Group: Networking/File transfer
Summary: Llightweight BitTorrent client
License: GPLv2 + MIT
Url: http://www.transmissionbt.com/

Provides: %rname = %EVR

Obsoletes: %name-benc2php
Obsoletes: %name-proxy

Requires: %name-gui = %EVR
Requires: %name-cli = %EVR
Requires: %name-remote = %EVR
Requires: %name-daemon = %EVR

Requires(post,postun): desktop-file-utils

Source: http://download.m0k.org/%name/files/%name-%version.tar
Patch1: %name-alt-desktop.patch
Patch2: %name-alt-extra-doc-disable.patch
Source1: %dname.init
Source2: %dname.logrotate
Source3: %dname.service
Source4: %name-%version-third-party-dht.tar
Source5: %name-%version-third-party-libutp.tar

BuildPreReq: desktop-file-utils

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake
BuildRequires: ctest
BuildRequires: gcc-c++ glibc-devel libcurl-devel libevent-devel libnotify-devel libcanberra-devel libdbus-glib-devel libgtk+3-devel
BuildRequires(pre): rpm-utils desktop-file-utils libalternatives-devel rpm-build-ubt openssl-devel
BuildRequires: libb64-devel
BuildRequires: libnatpmp-devel
BuildRequires: libminiupnpc-devel
%if "%(rpmvercmp '%{get_version glibc-core}' '2.9')" >= "0"
BuildRequires: libgio-devel
%endif
%if_enabled qt
BuildRequires: qt5-base-devel qt5-tools-devel
%endif

%description
Transmission has been built from the ground up to be a lightweight,
yet powerful BitTorrent client. Its simple, intuitive interface
strikes a balance between providing useful functionality without
feature bloat. Furthermore, it is free for anyone to use or modify.

%package common
Group: Networking/File transfer
Summary: Common files for %name
Conflicts: %name < 1.00-alt10
%description common
Common files for %name

%package gui-common
Group: Networking/File transfer
Summary: Common files for %name
Requires: %name-common = %EVR
%description gui-common
Common files for %name

%package gtk
Group: Networking/File transfer
Summary: Graphical BitTorrent client
Provides: %name-gui = %EVR
Requires: %name-common = %EVR
Requires: %name-gui-common = %EVR
%description gtk
GTK-based graphical BitTorrent client

%if_enabled qt
%package qt
Group: Networking/File transfer
Summary: Graphical BitTorrent client
Provides: %name-gui = %EVR
Requires: %name-common = %EVR
Requires: %name-gui-common = %EVR
%description qt
Qt-based graphical BitTorrent client
%endif

%package cli
Group: Networking/File transfer
Summary: Command line BitTorrent client
Requires: %name-common = %EVR
%description cli
Command line BitTorrent client

%package remote
Group: Networking/Remote access
Summary: Command line remote interface to %name-daemon
Requires: %name-common = %EVR
%description remote
Command line remote interface to %name-daemon

%package daemon
Group: Networking/File transfer
Summary: Daemonised BitTorrent client
Requires: %name-common = %EVR
%description daemon
Daemonised BitTorrent client

%prep
%setup -a4 -a5
%patch1 -p1
%patch2 -p1

%build
%cmake \
	-DENABLE_GTK:BOOL=YES \
%if_enabled qt
	-DENABLE_QT:BOOL=YES \
%endif
	-DENABLE_CLI:BOOL=YES \
	-DUSE_SYSTEM_EVENT2:BOOL=YES \
	-DUSE_SYSTEM_MINIUPNPC:BOOL=YES \
	-DUSE_SYSTEM_NATPMP:BOOL=YES \
	-DUSE_SYSTEM_B64:BOOL=YES \
	%nil

%cmake_build

%install
%cmakeinstall_std

# made alternatives entries
mkdir -p %buildroot/%_altdir

cat >%buildroot/%_altdir/%name-gtk <<__EOF__
%_bindir/%name %_bindir/%name-gtk 30
__EOF__

%if_enabled qt
cat >%buildroot/%_altdir/%name-qt <<__EOF__
%_bindir/%name %_bindir/%name-qt 20
__EOF__
%endif

%find_lang %name-gtk

# install daemonic stuff

install -pD -m640 %SOURCE2 %buildroot%_sysconfdir/logrotate.d/%dname
install -pD -m755 %SOURCE1 %buildroot%_initdir/%dname
install -pD -m644 %SOURCE3 %buildroot%systemd_unitdir/transmission-daemon.service

mkdir -p %buildroot/%_sysconfdir/transmission-daemon/
BUILD/daemon/transmission-daemon -d 2> %buildroot/%_sysconfdir/transmission-daemon/settings.json
sed -i 's,/usr/src/,/var/lib/transmission-daemon/,' %buildroot/%_sysconfdir/transmission-daemon/settings.json

mkdir -p %buildroot/%_sysconfdir/sysconfig/
echo "TRANSMISSION_OPTIONS=\"-e %_logdir/%dname/%dname.log -g %_localstatedir/%dname\"" > %buildroot/%_sysconfdir/sysconfig/%dname

mkdir -p %buildroot/%_logdir/%dname
mkdir -p %buildroot/%_localstatedir/%dname

%check
pushd BUILD
ctest
popd

%pre daemon
/usr/sbin/groupadd -r -f _%dname
/usr/sbin/useradd -r -g _%dname -d %_localstatedir/%dname -s /dev/null -c 'The Transmission Torrent Client' _%dname >/dev/null 2>&1 ||:
if [ $1 -gt 1 ]; then
        /usr/sbin/usermod -d %_localstatedir/%dname _%dname
fi

%files

%files common
%dir %_datadir/%name
%_datadir/%name/web/

%files gui-common
%_iconsdir/hicolor/*/*/*
%_datadir/applications/%name.desktop

%files gtk -f %name-gtk.lang
%doc AUTHORS COPYING NEWS.md README.md ChangeLog
%_bindir/%name-gtk
%_altdir/%name-gtk
%_man1dir/%name-gtk.1*
%_datadir/appdata/transmission-gtk.appdata.xml

%if_enabled qt
%files qt
%doc AUTHORS COPYING NEWS.md README.md ChangeLog
%_bindir/%name-qt
%_altdir/%name-qt
%_datadir/%name/translations/%{name}_*.qm
%_man1dir/%name-qt.1*
%endif

%files cli
%doc AUTHORS COPYING NEWS.md README.md ChangeLog
%_bindir/%name-create
%_man1dir/%name-create.*
%_bindir/%name-edit
%_man1dir/%name-edit.*
%_bindir/%name-show
%_man1dir/%name-show.*
%_bindir/transmission-cli
%_man1dir/transmission-cli.*

%files remote
%doc AUTHORS COPYING NEWS.md README.md ChangeLog
%_bindir/%name-remote
%_man1dir/%name-remote.*

%files daemon
%doc AUTHORS COPYING NEWS.md README.md ChangeLog
%_bindir/%name-daemon
%_man1dir/%name-daemon.*
%systemd_unitdir/transmission-daemon.service
%config(noreplace) %_sysconfdir/logrotate.d/%dname
%config(noreplace) %_sysconfdir/sysconfig/%dname
%config %_initdir/%dname
%attr(710,root,_%dname) %dir %_sysconfdir/%dname
%config(noreplace) %_sysconfdir/%dname/settings.json
%attr(771,root,_%dname) %dir %_localstatedir/%dname
%attr(770,root,_%dname) %dir %_logdir/%dname

%changelog
