%set_verify_elf_method unresolved=relaxed
%add_findreq_skiplist  %_libdir/trikStudio/*.so* %_libdir/trikStudio/plugins/tools/kitPlugins/*.so %_libdir/trikStudio/plugins/tools/*.so %_libdir/trikStudio/plugins/editors/*.so
%def_without separate_trikruntime
%def_without sanitize
%def_without debug
%define appname trik-studio

Name: trikStudio
Version: 2021.1
Release: alt2
Summary: Intuitive programming environment robots
Summary(ru_RU.UTF-8): Интуитивно-понятная среда программирования роботов
License: Apache-2.0
Group: Education
Url: https://github.com/qreal/qreal/

Packager: Evgeny Sinelnikov <sin@altlinux.org>
Source: %name-%version.tar
Patch: %name-%version-alt.patch
Patch1: gamepad.patch
Patch2: alt-ftbfs.patch

BuildRequires: gcc-c++ qt5-base-devel qt5-svg-devel qt5-script-devel qt5-multimedia-devel libusb-devel libudev-devel libgmock-devel
BuildRequires: libqscintilla2-qt5-devel zlib-devel libquazip-qt5-devel python3-dev libhidapi-devel libusb-devel
# Workaround due project build with -fsanitize=undefined natively
# https://bugzilla.altlinux.org/show_bug.cgi?id=38106
#if_with sanitize
BuildRequires: libubsan-devel-static
#endif
BuildRequires: rsync qt5-tools

Requires: libquazip-qt5 libhidapi
Requires: %name-data = %version-%release
Conflicts: lib%name

%description
Intuitive programming environment allows you to program robots using a sequence
of pictures. With TRIK Studio programming is easy and fun.

TRIK Studio perfectly as universal for teaching programming, provided the
transition from the chart to the textual programming language that is planned to
implement the language of block diagrams. The environment is also implemented
programming robots Lego Mindsorms NXT 2.0 and EV3, but the possibility of such
robots are very limited in comparison with the TRIK.

%description -l ru_RU.UTF-8
Интуитивно-понятная среда программирования позволяет программировать роботов с
помощью последовательности картинок. С TRIK Studio программирование становится
простым и увлекательным.

TRIK Studio прекрасно подходит как универсальное ПО преподавания основ
программирования, предусмотрен переход от диаграмм к текстовым языкам
программирования, планируется реализация языка блок-схем. В среде также
реализовано программирование роботов Lego Mindsorms NXT 2.0 и EV3, но
возможности таких роботов сильно ограничены в сравнении с ТРИК.

%package data
Summary: Data files for %name
Group: Education
BuildArch: noarch

%description data
Data files for %name

%package -n trikRuntime
Summary: Trik runtime libraries for %name
Group: Education
BuildArch: noarch

%description -n trikRuntime
Trik runtime libraries for %name

%package -n trikRuntime-devel
Summary: Trik runtime development files for %name
Group: Education
BuildArch: noarch

%description -n trikRuntime-devel
Trik runtime development files for %name

%prep
%setup
%patch -p1
sed -e '2 a export LD_LIBRARY_PATH=%_libdir\/%name\/' -i installer/platform/trikStudio.sh
sed -e 's|^trik-studio|%_libdir/%name/trik-studio|' -i installer/platform/trikStudio.sh

pushd plugins/robots/thirdparty/Box2D
tar -xf Box2D.tar.bz2
popd
pushd plugins/robots/thirdparty/trikRuntime
tar -xf trikRuntime.tar.bz2
popd
pushd thirdparty/gamepad
rm -rf qscintilla quazip
tar -xf gamepad.tar.bz2
%patch1
popd
pushd qrgui/thirdparty
tar -xf qt-solutions.tar.bz2
popd
pushd thirdparty/qslog
tar -xf qslog.tar.bz2
popd
%patch2 -p1

if pushd plugins/robots/thirdparty/trikRuntime/trikRuntime/PythonQt/PythonQt ; then
	[ -e generated_cpp_5.15 ] \
	    || ln -s generated_cpp_5.14 generated_cpp_5.15
    popd
fi

%build
%qmake_qt5 -r \
%if_with debug
    CONFIG+=debug CONFIG-=release \
%else
    CONFIG-=debug CONFIG+=release \
%endif
%if_with sanitize
    CONFIG+=!nosanitizers \
%endif
    CONFIG+=no_rpath \
    PREFIX=%_prefix LIBDIR=%_libdir TRIK_STUDIO_VERSION=%version studio.pro
%make_build

%install
for N in Kernel Network Hal Control ScriptRunner ; do
    [ -e bin/release/libtrik${N}.la ] || ln -sf libtrik${N}.so bin/release/libtrik${N}.la ||:
    [ -e bin/release/trik${N}.pc ] || echo > bin/release/trik${N}.pc ||:
done
%make_install INSTALL_ROOT=%buildroot install
mv %buildroot%_libdir/*.so* %buildroot%_libdir/%name
mv %buildroot%_bindir/trik-studio %buildroot%_libdir/%name/
ln -fs %name %buildroot%_bindir/trik-studio
%if_with separate_trikruntime
mv %buildroot%_prefix/lib/libqslog*.so* %buildroot%_libdir
mv %buildroot%_prefix/lib/libtrik*.so* %buildroot%_libdir
%else
rm -rf %buildroot%_sysconfdir/trik
rm -f %buildroot%_prefix/lib/libqslog*.so*
rm -f %buildroot%_prefix/lib/libtrik*.so*
rm -rf %buildroot%_datadir/trikRuntime
rm -rf %buildroot%_prefix/local/share/qslog/
rm -rf %buildroot%_includedir/trik*
rm -rf %buildroot%_includedir/qslog*
rm -rf %buildroot%_includedir/QsLog*
%endif
rm -f %buildroot/lib/*PythonQt_QtAll* %buildroot/include/PythonQt_QtAll.h
rm -f %buildroot%_libdir/%name/plugins/tools/kitPlugins/librobots-null-interpreter.so

pushd bin/release
for d in examples help translations images; do
    cp -fr $d %buildroot%_datadir/%name/
done
#cp -fr trikSharp %buildroot%_libdir/%name/
cp -f gamepad %buildroot%_bindir/
mkdir -p %buildroot%_datadir/%name/languages
cp -f ../../thirdparty/gamepad/gamepad/languages/*.qm %buildroot%_datadir/%name/languages/
popd

%files
%_bindir/*
%_libdir/%name
%_sysconfdir/%appname.config

%files data
%_datadir/%name
%_miconsdir/*
%_liconsdir/*
%_niconsdir/*
%_desktopdir/*
%doc LICENSE NOTICE README.md

%if_with separate_trikruntime
%files -n trikRuntime
%_sysconfdir/trik
%_libdir/libqslog*.so.*
%_libdir/libtrik*.so.*
%_datadir/trikRuntime

%files -n trikRuntime-devel
%_libdir/libqslog*.so
%_libdir/libtrik*.so
%_includedir/trik*
%_includedir/qslog*
%_includedir/QsLog*
%endif

%changelog
