Name: u-boot-rpi3
Version: 2021.01
Release: alt1

Summary: Das U-Boot
License: GPLv2+
Group: System/Kernel and hardware

ExclusiveArch: armh aarch64

Source: %name-%version-%release.tar

BuildRequires: bc dtc >= 1.4 flex

%description
boot loader for embedded boards based on PowerPC, ARM, MIPS and several
other processors, which can be installed in a boot ROM and used to
initialize and test the hardware or to download and run application code.
This package supports Raspberry Pi 3/4 boards.

%ifarch armh
%define rpi rpi_3_32b rpi_3_b_plus_32b rpi_4_32b
%define img kernel7.img
%endif
%ifarch aarch64
%define rpi rpi_3 rpi_3_b_plus rpi_4
%define img kernel8.img
%endif

%prep
%setup

%build
for board in %rpi; do
	mkdir build
        %make_build O=build ${board}_defconfig all
        install -pm0644 -D build/u-boot.bin out/${board}/%img
        rm -rf build
done

%install
mkdir -p %buildroot%_datadir/u-boot
cd out
find . -type f | cpio -pmd %buildroot%_datadir/u-boot

%files
%doc README
%_datadir/u-boot/*

%changelog
