%def_enable snapshot
%define _localstatedir %_var
%define git 08d9ec0
%define _group usbmux

Name: usbmuxd
Version: 1.1.1
Release: alt0.2.g%git

Summary: Daemon for communicating with Apple's iPod Touch and iPhone
Group: System/Servers
License: GPLv3+
Url: http://www.libimobiledevice.org/

%if_disabled snapshot
Source: http://www.libimobiledevice.org/downloads/%name-%version.tar.bz2
%else
# VCS: https://github.com/libimobiledevice/usbmuxd.git
Source: %name-%version.tar
%endif

%define plist_ver 1.11
%define usb_ver 1.0.9
%define imobiledevice_ver 1.1.6

BuildRequires: gcc-c++ cmake
BuildRequires: libplist-devel >= %plist_ver
BuildRequires: libusb-devel >= %usb_ver
BuildRequires: libimobiledevice-devel >= %imobiledevice_ver
BuildRequires: libudev-devel systemd-devel

%description
usbmuxd (USB Multiplex Daemon) is a daemon used for communicating with
Apple's iPod Touch and iPhone devices. It allows multiple services on
the device to be accessed simultaneously.

%prep
%setup

%build
%autoreconf
%configure --disable-static
%make_build

%install
%makeinstall_std

%pre
/usr/sbin/groupadd -rf %_group ||:
/usr/sbin/useradd -M -r -s /dev/null -c "USB Multiplex Daemon" \
	-d %_localstatedir/empty -g %_group %_group &>/dev/null ||:

%files
%_sbindir/usbmuxd
/lib/udev/rules.d/39-%name.rules
%_unitdir/%name.service
%_man8dir/%name.*
%doc AUTHORS README

%changelog
