Name: uucp
Version: 1.07
Release: alt4

Summary: The %name utility for copying files between systems
License: GPL
Group: Networking/File transfer
Url: http://www.airs.com/ian/uucp.html

Source: %name-%version.tar.bz2

Patch1: %name-alt-misc.patch
Patch2: %name-1.06.1-sigfpe.patch

PreReq: coreutils, /var/lock/serial

Requires: syslog-common >= 1.4.1-alt1
Requires: cu = %version-%release

BuildRequires: autoconf_2.13 makeinfo

%description
The %name command copies files between systems. Uucp is primarily used
by remote machines downloading and uploading email and news files to
local machines.

Install the %name package if you need to use %name to transfer files
between machines.

%package -n cu
Summary: %name cu utility
Group: Networking/File transfer
Conflicts: uucp < 1.07-alt4

%description -n cu
The %name command copies files between systems. Uucp is primarily used
by remote machines downloading and uploading email and news files to
local machines.

This package contains only cu(1) utility.

%prep
%setup
%patch1 -p1

%set_autoconf_version 2.13

# Fix wrong paths.
#find -type f |
#	xargs fgrep -l /usr/local/conf |
#	xargs -r perl -pi -e 's,/usr/local/conf,%_sysconfdir,g'
#
#find -type f |
#	xargs fgrep -l /usr/local |
#	xargs -r perl -pi -e 's,/usr/local,%prefix,g'

# Fix manpages.
find -type f |
	xargs grep -l "^''' " |
	xargs -r perl -pi -e "s/^''' /"'.\\" /'

%build
autoconf
%configure --with-user=%name --with-newconfigdir=/etc/uucp \
	   --with-oldconfigdir=/etc/uucp/old
# SMP-incompatible
make

%install
mkdir -p %buildroot{%_bindir,%_mandir/man{1,8},%_sysconfdir/%name}
#,%_libdir/%name}
%makeinstall install-info

install -d -m750 %buildroot%_spooldir/%name{,public}

#ln -sf ../../sbin/uucico %buildroot%_libdir/%name

rm -rf %buildroot%_logdir/%name
mkdir -p %buildroot%_logdir/%name
touch %buildroot%_logdir/%name/{Log,Stats,Debug}

# the following is kind of gross, but it is effective
for i in dial passwd port dialcode sys call ; do
cat >%buildroot%_sysconfdir/%name/$i <<EOF
# This is an example of a $i file. This file have the syntax compatible
# with Taylor UUCP (not HDB nor anything else). Please check %name
# documentation if you are not sure how Taylor config files are supposed to
# look like. Edit it as appropriate for your system.

# Everything after a '#' character is a comment.
EOF
done

%post
umask 077
for f in Debug Log Stats; do
	if [ ! -f "%_logdir/%name/$f" ]; then
		:>>"%_logdir/%name/$f"
		chown %name.%name "%_logdir/%name/$f"
	fi
done
chmod go-rwx %_logdir/%name/Debug

%files
%_bindir/uulog
%_bindir/uupick
%_bindir/uuto
%_sbindir/uuchk
%_sbindir/uuconv
%_sbindir/uusched
%attr(6511,%name,%name) %_bindir/uucp
%attr(6511,%name,%name) %_bindir/uuname
%attr(6511,%name,%name) %_bindir/uustat
%attr(6511,%name,%name) %_bindir/uux
%attr(6511,%name,%name) %_sbindir/uucico
%attr(6511,%name,%name) %_sbindir/uuxqt
%attr(770,%name,%name) %dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/call
%config(noreplace) %_sysconfdir/%name/dial
%config(noreplace) %_sysconfdir/%name/dialcode
%config(noreplace) %_sysconfdir/%name/passwd
%config(noreplace) %_sysconfdir/%name/sys
%_man1dir/uucp.1*
%_man1dir/uustat.1*
%_man1dir/uux.1*
%_man8dir/uucico.8*
%_man8dir/uuxqt.8*
%attr(600,%name,%name) %ghost %_logdir/%name/Debug
%attr(644,%name,%name) %ghost %_logdir/%name/Log
%attr(644,%name,%name) %ghost %_logdir/%name/Stats
%attr(-,%name,%name) %_spooldir/*
%_infodir/*.info*
%doc AUTHORS COPYING TODO README ChangeLog NEWS
%doc sample contrib

%files -n cu
%attr(6511,%name,%name) %_bindir/cu
%attr(770,%name,%name) %dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/port
%_man1dir/cu.1*

%changelog
