%def_enable introspection
%def_enable gtk_doc
%def_disable static

Name: vips
Version: 8.10.1
Release: alt1

Summary: Large image processing library

License: LGPLv2.1
Group: Graphics
Url: https://libvips.github.io/libvips/

# Source0-url: https://github.com/libvips/libvips/archive/v%version.tar.gz
Source0: %name-%version.tar
Source100: vips.watch

BuildRequires: rpm-build-python3
BuildRequires: libxml2-devel libexpat-devel
BuildRequires: gcc-c++ libImageMagick-devel libcfitsio-devel libexif-devel libfftw3-devel
BuildRequires: liblcms2-devel libmatio-devel liborc-devel libpango-devel openexr-devel
BuildRequires: libjpeg-devel libpng-devel libtiff-devel libgif-devel libimagequant-devel
BuildRequires: libwebp-devel libopenslide-devel librsvg-devel libpoppler-glib-devel

%{?_enable_gtk_doc:BuildRequires: gtk-doc}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libgdk-pixbuf-gir-devel}


%define majorver %(echo %version |cut -d. -f1,2)

%description
VIPS is an image processing library. It is good for very large
images (ie.  larger than the amount of RAM in your machine),
and for working with colour.  It includes a C++ API, complete
man pages, a command-line interface, automatic threading and
an operation database. There are several user interfaces built
on top of VIPS: for example "nip2".

%package -n lib%name
Summary: VIPS development kit
Group: System/Libraries

%package -n lib%name-devel
Summary: VIPS development kit
Group: Development/C
Requires: lib%name = %version-%release
Provides: %name-devel = %version-%release
Obsoletes: %name-devel < 7.16.3-alt3

%package -n lib%name-devel-doc
Summary: VIPS development kit documentation
Group: Development/C
BuildArch: noarch

%package -n lib%name-devel-static
Summary: VIPS static libraries
Group: Development/C
Requires: lib%name-devel = %version-%release
Provides: %name-devel-static = %version-%release
Obsoletes: %name-devel-static < 7.16.3-alt3

%package -n lib%name-gir
Summary: GObject introspection data for VIPS
Group: System/Libraries
Requires: %name = %EVR

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for VIPS
Group: Development/Other
BuildArch: noarch
Requires: lib%name-devel = %EVR
Requires: lib%name-gir = %EVR

%description -n lib%name
Shared libraries for VIPS.

%description -n lib%name-devel
Development libraries and header files for VIPS.

%description -n lib%name-devel-doc
This package contains development documentation for VIPS.

%description -n lib%name-devel-static
Static libraries for developing statically linked VIPS applications.

%description -n lib%name-gir
GObject introspection data for VIPS.

%description -n lib%name-gir-devel
GObject introspection devel data for VIPS.

%prep
%setup
%__subst "s|/usr/bin/python$|%__python3|" tools/vipsprofile
# Avoid setting RPATH to /usr/lib64 on 64-bit builds
# The DIE_RPATH_DIE trick breaks the build wrt gobject-introspection
#sed -i 's|sys_lib_dlsearch_path_spec="|sys_lib_dlsearch_path_spec="/%{_lib} %{_libdir} |' configure

%build
gtkdocize --copy --docdir doc --flavour no-tmpl
glib-gettextize --force --copy
%autoreconf
%configure %{subst_enable static} \
           %{subst_enable introspection} \
           %{?_enable_gtk_doc --enable-gtk-doc}
%make_build

%install
%makeinstall_std
%find_lang vips%majorver
find %buildroot \( -name '*.la' -o -name '*.a' \) -exec rm -f {} ';'
# remove unneeded wrapper
rm -fv %buildroot%_bindir/vips%majorver

%files -f vips%{majorver}.lang
%_bindir/*
%_man1dir/*
#_docdir/vips

%files -n lib%name
%_libdir/lib*.so.*

%files -n lib%name-devel
%_includedir/vips/
%_libdir/lib*.so
%_pkgconfigdir/*.pc

%if_enabled gtk_doc
%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/*
%endif

%if_enabled static
%files -n lib%name-devel-static
%_libdir/lib*.a
%endif

%if_enabled introspection
%files -n lib%name-gir
%_typelibdir/*.typelib

%files -n lib%name-gir-devel
%_girdir/*.gir
%endif

# TODO:
# - OpenSlide, v4l
# - package python bindings

%changelog
