%def_disable freerdp
%def_disable goom
%def_enable firewire
%def_enable visualization
%def_enable wayland

Name: vlc
Version: 3.0.16
Release: alt1

Summary: VLC media player
License: GPLv2
Group: Video

Url: http://www.videolan.org
Source: vlc-%version.tar
Patch: vlc-3.0.6-alt-e2k-lcc123.patch
Patch1: 0001-configure-fix-linking-on-RISC-V-ISA.patch

BuildRequires: gcc-c++
BuildRequires: freetype2-devel glib2-devel flex
BuildRequires: libdvdcss-devel libavcodec-devel libnotify-devel
BuildRequires: libavutil-devel libpostproc-devel libavformat-devel
BuildRequires: libswscale-devel libmpeg2-devel libebml-devel >= 1.3.5-alt1
BuildRequires: libmatroska-devel libcddb-devel liblive-devel aalib-devel
BuildRequires: libtwolame-devel libssh2-devel liba52-devel libalsa-devel
BuildRequires: libcdio-devel libdvbpsi-devel libdvdnav-devel >= 6.1.0
BuildRequires: libdvdread-devel >= 6.1.0 libflac-devel libgcrypt-devel librsvg-devel
BuildRequires: libgnutls-devel libgpg-error-devel libjpeg-devel liblirc-devel
BuildRequires: libmad-devel libmodplug-devel libspeex-devel libspeexdsp-devel libmpcdec-devel
BuildRequires: libncurses-devel libncursesw-devel libogg-devel libpng-devel
BuildRequires: libstdc++-devel libtheora-devel libtiff-devel libtinfo-devel
BuildRequires: libvcd-devel libvorbis-devel libxml2-devel
BuildRequires: libpulseaudio-devel libx264-devel vim-devel
BuildRequires: jackit-devel liblame-devel zlib-devel libavahi-devel dbus
BuildRequires: libtag-devel libfluidsynth-devel libdbus-devel
BuildRequires: libzvbi-devel libfribidi-devel
BuildRequires: libass-devel libbluray-devel libpcre-devel libopus-devel
BuildRequires: libkate-devel libv4l-devel libmtp-devel libshout2-devel
BuildRequires: libtar-devel libva-devel libvpx-devel libx265-devel
BuildRequires: libxcb-devel libxcbutil-devel libxcbutil-keysyms-devel
BuildRequires: libEGL-devel libGL-devel libGLES-devel
BuildRequires: libschroedinger-devel libsmbclient-devel
BuildRequires: libupnp-devel liblua5-devel lua5
BuildRequires: libtiger-devel libudev-devel libsqlite3-devel
BuildRequires: libgtk+3-devel libXpm-devel libXt-devel libminizip-devel
BuildRequires: libchromaprint-devel libvncserver-devel
BuildRequires: qt5-x11extras-devel libsecret-devel libgtk+2-devel libsoxr-devel libmpg123-devel qt5-svg-devel
BuildRequires: libnfs-devel libdca-devel libarchive-devel libprotobuf-lite-devel protobuf-compiler 
BuildRequires: libaom-devel libsamplerate-devel libsidplay2-devel
BuildRequires: libdav1d-devel libSDL_image-devel libsystemd-devel
%{?_enable_freerdp:BuildRequires: libfreerdp-devel}
%{?_enable_goom:BuildRequires: libgoom-devel}
%{?_enable_firewire:BuildRequires: libdc1394-devel libraw1394-devel libavc1394-devel}
%{?_enable_visualization:BuildRequires: libprojectM-devel}
%{?_enable_wayland:BuildRequires: libwayland-egl-devel wayland-protocols}
BuildRequires: fortune-mod >= 1.0-ipl33mdk

%define allplugins aa ass audiocd bluray chromaprint dbus %{?_enable_firewire:dv} dvdnav dvdread ffmpeg flac framebuffer fluidsynth freetype globalhotkeys gnutls h264 h265 jack linsys live555 matroska modplug mpeg2 mtp musepack notify ogg opus png podcast pulseaudio realrtsp schroedinger shout smb speex svg taglib theora twolame upnp v4l videocd vpx xcb xml %{?_enable_goom:goom} %{?_enable_visualization:projectm}
%define baseplugins ass bluray dbus dvdnav dvdread ffmpeg freetype globalhotkeys live555 matroska mpeg2 ogg pulseaudio taglib v4l xcb xml
%define restplugins %(echo %allplugins %baseplugins |tr '[[:space:]]' '\\n'|sort |uniq -u|tr '\\n' ' ')
%define mergedplugins alsa dvb ts

%define vlcrequires() %(for p in %{*}; do printf 'Requires: vlc-plugin-%%s = %%s\\n' $p %version-%release; done)
%define vlcobsolete() %(for p in %{*}; do printf 'Provides: vlc-plugin-%%s = %%s\\nObsoletes: vlc-plugin-%%s\\n' $p %version-%release $p;done)

Requires: vlc-mini = %EVR
Requires: vlc-interface-qt = %EVR
%vlcrequires %baseplugins

Provides: %name-common = %EVR
Obsoletes: %name-common < %EVR
Provides: %name-normal = %EVR
Obsoletes: %name-normal < %EVR
Provides: %name-kde4 = %EVR
Obsoletes: %name-kde4
Obsoletes: %name-mad

%package mini
Summary: Minimalist version of VLC media player
Group: Video
Requires: lib%name = %EVR
%vlcobsolete %mergedplugins

%package maxi
Summary: Maxi package for VLC media player
Group: Video
Requires: vlc
Requires: vlc-interface-ncurses
Requires: vlc-interface-skins2
Requires: vlc-interface-lirc
Requires: vim-plugin-vlc-syntax
%vlcrequires %restplugins
BuildArch: noarch

%package interface-lirc
Summary: Lirc inteface plugin for VLC media player
Group: Video
Requires: lib%name = %EVR
Provides: vlc-plugin-lirc = %EVR
Obsoletes: vlc-plugin-lirc

%package interface-ncurses
Summary: ncurses plugin for VLC media player
Group: Video
Requires: lib%name = %EVR
Provides: %name-plugin-ncurses = %EVR

%package interface-skins2
Summary: Skins2 plugin for VLC media player
Group: Video
Requires: lib%name = %EVR
Requires: vlc-interface-qt = %EVR

%package interface-qt
Summary: QT interface plugin for VLC media player
Group: Video
Requires: lib%name = %EVR
Provides: %name-plugin-qt4 = %EVR
Obsoletes: %name-interface-qt4 < %EVR
Provides: %name-interface-qt4 = %EVR
Obsoletes: vlc-interface-wxwidgets

%package -n lib%name
Summary: VLC media player library
Group: System/Libraries
License: LGPLv2
Conflicts: %name-mini < %EVR

%package -n lib%name-devel
Summary: Development files for VLC media player
Group: Development/C
License: LGPLv2
Requires: lib%name = %EVR

%package plugin-aa
Summary: ASCII art video output plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-ass
Summary: ASS codec (subtitles) plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-audiocd
Summary: AudioCD access plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-bluray
Summary: Bluray access plugin for VLC media player
Group: Video
Requires: lib%name = %EVR
Requires: libaacs

%package plugin-chromaprint
Summary: Audio fingerprinting plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-dbus
Summary: DBUS plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-dv
Summary: DC1394/DV (firewire) plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-dvdnav
Summary: DVDNav input plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-dvdread
Summary: DVDRead input (DVD without a menu) plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-ffmpeg
Summary: FFMPeg plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-flac
Summary: FLAC codec plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-framebuffer
Summary: Framebuffer output plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-fluidsynth
Summary: Fluidsynth codec plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-freetype
Summary: FreeType OSD plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-globalhotkeys
Summary: Global Hotkeys control plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-gnutls
Summary: GNU TLS plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-goom
Summary: GOOM plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-h264
Summary: h264 output plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-h265
Summary: h265 output plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-jack
Summary: Jack audio output plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-live555
Summary: LiveMedia (RTSP) demuxing support for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-linsys
Summary: Linear Systems access module for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-matroska
Summary: Matroska Video demuxer plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-modplug
Summary: modplug demuxer plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-mpeg2
Summary: MPEG1/2 codec plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-mtp
Summary: MTP Service Discovery plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-musepack
Summary: Musepack demuxer plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-notify
Summary: Notify SDP plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-ogg
Summary: OGG/Vorbis/Kate codec plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-opus
Summary: OPUS codec plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-png
Summary: PNG plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-podcast
Summary: Podcast SDP plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-projectm
Summary: ProjectM visualisation plugin for VLC media player
Group: Video
Requires: lib%name = %EVR
Requires: /usr/share/fonts/ttf/dejavu/DejaVuSans.ttf
Requires: /usr/share/fonts/ttf/dejavu/DejaVuSansMono.ttf

%package plugin-pulseaudio
Summary: PulseAudio output plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%if_enabled freerdp
%package plugin-rdp
Summary: RDP and VNC access plugin for VLC media player
Group: Video
Requires: lib%name = %EVR
%endif

%package plugin-realrtsp
Summary: REAL RTSP access plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-schroedinger
Summary: Dirac codec (via libschroedinger) plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-shout
Summary: SHOUT access output plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-smb
Summary: SMB access plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-snapshot
Summary: Snapshot video output plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-speex
Summary: speex codec support plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-svg
Summary: SVG plugin plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-taglib
Summary: Taglib meta engine plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-theora
Summary: Theora codec plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-twolame
Summary: TwoLAME encoding plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-upnp
Summary: Intel UPNP Service Discovery plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-v4l
Summary: Video4Linux input plugin for VLC media player
Group: Video
Provides: vlc-plugin-v4l2 = %EVR
Requires: lib%name = %EVR

%package plugin-videocd
Summary: VideoCD input plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-vpx
Summary: VP8 output plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-xcb
Summary: X11 output / Service Discovery plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package plugin-xml
Summary: XML plugin for VLC media player
Group: Video
Requires: lib%name = %EVR

%package -n vim-plugin-vlc-syntax
Summary: VIm syntax for VLC media player
Group: Video
BuildArch: noarch

%package -n fortunes-vlc
Summary: VLC fortunes
Group: Video
PreReq: fortune-mod >= 1.0-ipl33mdk
BuildArch: noarch

# {{{ descriptions

%description
VLC media player is a free network-aware MPEG1, MPEG2, MPEG4 (aka DivX),
DVD and many-many-more-player-and-streamer.

The VLC media player allows to play MPEG2 Transport Streams from the
network or from a file, as well as direct DVD playback.

This version includes MPEG1 support, direct DVD support, DVD decryption,
arbitrary, seeking in the stream, pause, fast forward and slow motion,
hardware YUV acceleration and a few new interface features including
drag'n'drop... and more more more. :)

%description mini
VLC media player is a free network-aware MPEG1, MPEG2, MPEG4 (aka DivX),
DVD and many-many-more-player-and-streamer.

The VLC media player allows to play MPEG2 Transport Streams from the
network or from a file, as well as direct DVD playback.

This version includes MPEG1 support, direct DVD support, DVD decryption,
arbitrary, seeking in the stream, pause, fast forward and slow motion,
hardware YUV acceleration and a few new interface features including
drag'n'drop... and more more more. :)

You probably should install vlc package instead of this one.

%description maxi
This is a virtual package with every plugin or feature of VLC media player.

%description -n lib%name
This is a base VLC library.

%description -n lib%name-devel
This package provides files needed to develop plugins for VLC media player.

%description interface-lirc
This package is an infrared lirc interface for VLC media player.
To activate it, use the `--intf lirc' flag.

%description interface-ncurses
This package is an ncurses interface for VLC media player.

%description interface-skins2
This package is an skins2 interface for VLC media player.

%description interface-qt
This package is an QT interface for VLC media player.

%description plugin-aa
This is an ASCII art video output plugin for VLC media player.
To activate it, use the `--vout aa' flag or select the `aa'
vout plugin from the preferences menu.

%description plugin-ass
This package contains ASS subtitles support plugin for VLC media player.

%description plugin-audiocd
This package contains AudioCD access plugin for VLC media player.

%description plugin-bluray
This package contains Bluray disc access plugin for VLC media player.

%description plugin-chromaprint
This package contains client-side audio fingerprinting plugin,
based on AcoustID project chromaprint library.

%description plugin-dbus
This package contains DBUS control plugin for VLC media player.

%description plugin-dv
This package contains DC1394/DV (firewire) access plugin for VLC media player.

%description plugin-dvdnav
This package adds capability of DVDNav (DVD w/ menu) input to VLC media player.

%description plugin-dvdread
This package adds support of DVDRead (DVD w/o menu) input to VLC media player.

%description plugin-ffmpeg
This package adds support for ffmpeg decoders, encoders and demuxers
in VLC media player.

%description plugin-framebuffer
This package adds support for framebuffer video output in VLC media player.

%description plugin-flac
This package contains FLAC codec plugin for VLC media player.

%description plugin-fluidsynth
This package contains fluidsynth codec plugin for VLC media player.

%description plugin-freetype
This package contains freetype subtitles and OSD text output plugin 
to VLC media player.

%description plugin-globalhotkeys
This package contains Global Hotkeys control plugin for VLC media player.

%description plugin-gnutls
This package contains GNU TLS plugin for VLC media player.

%description plugin-goom
This package contains GOOM visualization plugin for VLC media player.

%description plugin-h264
This package contains h264 coder/packetizer plugin for VLC media player.

%description plugin-h265
This package contains h265 coder/packetizer plugin for VLC media player.

%description plugin-jack
This package contains Jack audio output plugin for VLC media player.

%description plugin-live555
This package contains LiveMedia (RTSP) demuxer support for VLC media player.

%description plugin-linsys
This package contains Linear Systems access plugins for VLC media player.

%description plugin-matroska
This package contains Matroska Video demuxing plugin for VLC media player.

%description plugin-modplug
This package contains modplug demuxing plugin for VLC media player.

%description plugin-mpeg2
This package contains MPEG1/2 decoder plugin for VLC media player.

%description plugin-mtp
This package contains MTP Service Discovery plugin for VLC media player.

%description plugin-musepack
This package contains musepack demuxer plugin for VLC media player.

%description plugin-notify
This package contains notify plugin for VLC media player.

%description plugin-ogg
This package contains OGG codec and Vorbis muxer/demuxer
plugin for VLC media player.

%description plugin-opus
This package contains OPUS codec plugin for VLC media player.

%description plugin-png
This package contains PNG codec plugin for VLC media player.

%description plugin-podcast
This package contains podcast discovery plugin for VLC media player.

%description plugin-projectm
This package contains ProjectM visualisation plugin for VLC media player.

%description plugin-pulseaudio
This package containts PulseAudio output plugin for VLC media player.

%description plugin-realrtsp
This package contains REAL RTSP access plugin for VLC media player.

%if_enabled freerdp
%description plugin-rdp
This package contains RDP and VNC access plugins for VLC media player.
%endif

%description plugin-schroedinger
This package contains dirac codec (via libschroedinger) plugin for VLC media
player.

%description plugin-shout
This package adds support for SHOUT output access/services discovery
to VLC media player.

%description plugin-smb
This package contains SMB access plugin to VLC media player.

%description plugin-snapshot
This package contains snapshot video output plugin to VLC media player.

%description plugin-speex
This package contains SPEEX plugin for VLC media player.

%description plugin-svg
This package contains SVG plugin for VLC media player.

%description plugin-taglib
This package contains taglib meta engine support for VLC media player.

%description plugin-theora
This package contains Theora codec support for VLC media player.

%description plugin-twolame
This package contains TwoLAME mpeg2 encoder plugin for VLC media player.

%description plugin-upnp
This package contains Intel UPNP Service Discovery plugin for VLC media player.

%description plugin-v4l
This package adds support for Video4Linux and Video4Linux2 to VLC media player.

%description plugin-videocd
This package contains VideoCD access plugin for VLC media player.

%description plugin-vpx
This package contains VP8 coder/packetizer plugin for VLC media player.

%description plugin-xcb
This package adds support for XCB video output and Service Discovery to VLC
media player.

%description plugin-xml
This package contains XML plugin to VLC media player.

%description -n vim-plugin-vlc-syntax
This package contains VIm syntax for VLC media player.

%description -n fortunes-vlc
This package contains fortunes from VLC media player.

# }}}

%define vlc_libdir %_libdir/%name
%define vlc_plugindir %vlc_libdir/plugins

%prep
%setup
echo %version-%release > src/revision.txt

%ifarch %e2k
# lcc 1.23 isn't quite gcc5 regarding builtins as well
%patch -p1
# EDG frontend bug
sed -i 's,const ATTR_USED,const,' modules/video_filter/deinterlace/yadif.h
# modules/demux/adaptive/PlaylistManager.cpp:638: undefined reference to `__pthread_register_cancel' ...
%add_optflags -pthread
%endif

%patch1 -p1

%build
%add_optflags -I%_includedir/samba-4.0
export BUILDCC=gcc

./bootstrap

%configure \
	%{subst_enable debug} \
	--disable-rpath \
	--disable-static \
	--enable-a52 \
	--enable-aa \
	--enable-alsa \
	--enable-avcodec \
	--enable-avformat \
	--enable-dca \
	--enable-dvbpsi \
	--enable-dvdnav \
	--enable-dvdread \
	--enable-egl \
	--enable-flac \
	--enable-freetype \
	--enable-fribidi \
	--enable-gles2 \
	--enable-gnutls \
	%{subst_enable goom} \
	--enable-httpd \
	--enable-jack \
	--enable-kate \
	--enable-libass \
	--enable-libcddb \
	--enable-libmpeg2 \
	--enable-libxml2 \
	--enable-lirc \
	--enable-live555 \
	--enable-mad \
	--enable-mkv \
	--enable-mod \
	--enable-mpc \
	--enable-ncurses \
	--enable-notify \
	--enable-ogg \
	--enable-omxil \
	--enable-omxil-vout \
	--enable-opus \
	--enable-png \
	--enable-postproc \
	--enable-pulse \
	--enable-realrtsp \
	--enable-schroedinger \
	--enable-sftp \
	--enable-shout \
	--enable-skins2 \
	--enable-smbclient \
	--enable-speex \
	--enable-svg \
	--enable-swscale \
	--enable-theora \
	--enable-twolame \
	--enable-upnp \
	--enable-vcd \
	--enable-vcdx \
	--enable-vlm \
	--enable-vorbis \
	--enable-x264 \
	--enable-xcb \
	--enable-wayland \
	%{subst_enable freerdp} \
%if_enabled firewire
	--enable-dc1394 \
	--enable-dv1394 \
%endif
%if_enabled visualization
	--enable-projectm \
%endif
	--disable-oss \
	--disable-quicktime \
	--disable-sdl \
	--with-kde-solid=%_datadir/kf5/solid/actions \
	--without-contrib \
        --with-default-font=/usr/share/fonts/ttf/dejavu/DejaVuSerif-Bold.ttf \
        --with-default-monospace-font=/usr/share/fonts/ttf/dejavu/DejaVuSansMono.ttf \
	--with-default-font-family="Sans Serif" \
	--with-default-monospace-font-family="Monospace" \
	#

%make_build

%install

mkdir -p %buildroot%_libdir
%make_install DESTDIR="%buildroot" install

install -pD -m644 doc/vlc.1 %buildroot/%_man1dir/vlc.1

# freedesktop menu
mkdir -p %buildroot%_datadir/applications 
install -pm644 share/vlc.desktop %buildroot%_datadir/applications/vlc.desktop

# remove non-packaged files
rm -rf %buildroot%_docdir/%name
find %buildroot -type f -name "*.la" -print -delete

# vim stuff
mkdir -p %buildroot%vim_syntax_dir
cp extras/analyser/vlc.vim %buildroot%vim_syntax_dir/

# fortunes stuff
mkdir -p %buildroot%_gamesdatadir/fortune
cp doc/fortunes.txt %buildroot%_gamesdatadir/fortune/vlc
strfile %buildroot%_gamesdatadir/fortune/vlc %buildroot%_gamesdatadir/fortune/vlc.dat

# vlc filetrigger to regenerate cache
mkdir -p %buildroot%_libexecdir/rpm

cat << __EOF__ > %buildroot%_libexecdir/rpm/vlc.filetrigger
#!/bin/sh -e
grep -qs '^%vlc_plugindir/.*\.so\$' || exit 0
%vlc_libdir/vlc-cache-gen %vlc_plugindir ||:
__EOF__

chmod 755 %buildroot%_libexecdir/rpm/vlc.filetrigger

%find_lang --output=%name.files %name

%files mini -f %name.files
%_bindir/vlc
%_bindir/cvlc
%_bindir/rvlc
%_bindir/vlc-wrapper
%vlc_libdir/vlc-cache-gen
%_libexecdir/rpm/vlc.filetrigger
%dir %vlc_libdir
%dir %vlc_plugindir
%exclude %_datadir/%name/skins2
%_datadir/%name
%dir %_datadir/metainfo
%_datadir/metainfo/vlc.appdata.xml
%_man1dir/*

%_iconsdir/hicolor/*/apps/vlc*.png
%_iconsdir/hicolor/*/apps/vlc*.xpm

%dir %vlc_plugindir/access
%vlc_plugindir/access/libaccess_alsa_plugin.so
%vlc_plugindir/access/libaccess_concat_plugin.so
%vlc_plugindir/access/libaccess_imem_plugin.so
%vlc_plugindir/access/libaccess_mms_plugin.so
%vlc_plugindir/access/libattachment_plugin.so
%vlc_plugindir/access/libdtv_plugin.so
%vlc_plugindir/access/libdvb_plugin.so
%vlc_plugindir/access/libfilesystem_plugin.so
%vlc_plugindir/access/libftp_plugin.so
%vlc_plugindir/access/libhttp_plugin.so
%vlc_plugindir/access/libhttps_plugin.so
%vlc_plugindir/access/libidummy_plugin.so
%vlc_plugindir/access/libimem_plugin.so
%vlc_plugindir/access/libnfs_plugin.so
%vlc_plugindir/access/librist_plugin.so
%vlc_plugindir/access/librtp_plugin.so
%vlc_plugindir/access/libsatip_plugin.so
%vlc_plugindir/access/libsdp_plugin.so
%vlc_plugindir/access/libsftp_plugin.so
%vlc_plugindir/access/libshm_plugin.so
%vlc_plugindir/access/libtcp_plugin.so
%vlc_plugindir/access/libtimecode_plugin.so
%vlc_plugindir/access/libudp_plugin.so
%vlc_plugindir/access/libvdr_plugin.so
%vlc_plugindir/access/libvnc_plugin.so


%dir %vlc_plugindir/access_output
%vlc_plugindir/access_output/libaccess_output_dummy_plugin.so
%vlc_plugindir/access_output/libaccess_output_file_plugin.so
%vlc_plugindir/access_output/libaccess_output_http_plugin.so
%vlc_plugindir/access_output/libaccess_output_rist_plugin.so
%vlc_plugindir/access_output/libaccess_output_udp_plugin.so
%vlc_plugindir/access_output/libaccess_output_livehttp_plugin.so

%dir %vlc_plugindir/audio_filter
%vlc_plugindir/audio_filter/libscaletempo_pitch_plugin.so
%vlc_plugindir/audio_filter/libdolby_surround_decoder_plugin.so
%vlc_plugindir/audio_filter/libheadphone_channel_mixer_plugin.so
%vlc_plugindir/audio_filter/libtrivial_channel_mixer_plugin.so
%vlc_plugindir/audio_filter/libugly_resampler_plugin.so
%vlc_plugindir/audio_filter/libaudio_format_plugin.so
%vlc_plugindir/audio_filter/libequalizer_plugin.so
%vlc_plugindir/audio_filter/libnormvol_plugin.so
%vlc_plugindir/audio_filter/libsamplerate_plugin.so
%vlc_plugindir/audio_filter/libsimple_channel_mixer_plugin.so
%vlc_plugindir/audio_filter/libparam_eq_plugin.so
%vlc_plugindir/audio_filter/libmad_plugin.so
%vlc_plugindir/audio_filter/libmono_plugin.so
%vlc_plugindir/audio_filter/libscaletempo_plugin.so
%vlc_plugindir/audio_filter/libspatializer_plugin.so
%vlc_plugindir/audio_filter/libaudiobargraph_a_plugin.so
%vlc_plugindir/audio_filter/libchorus_flanger_plugin.so
%vlc_plugindir/audio_filter/libcompressor_plugin.so
%vlc_plugindir/audio_filter/libkaraoke_plugin.so
%vlc_plugindir/audio_filter/libgain_plugin.so
%vlc_plugindir/audio_filter/libremap_plugin.so
%vlc_plugindir/audio_filter/libsoxr_plugin.so
%vlc_plugindir/audio_filter/libstereo_widen_plugin.so
%vlc_plugindir/audio_filter/libtospdif_plugin.so

%dir %vlc_plugindir/audio_mixer
%vlc_plugindir/audio_mixer/libfloat_mixer_plugin.so
%vlc_plugindir/audio_mixer/libinteger_mixer_plugin.so

%dir %vlc_plugindir/audio_output
%vlc_plugindir/audio_output/libalsa_plugin.so
%vlc_plugindir/audio_output/libafile_plugin.so
%vlc_plugindir/audio_output/libadummy_plugin.so
%vlc_plugindir/audio_output/libamem_plugin.so

%dir %vlc_plugindir/codec
%vlc_plugindir/codec/liba52_plugin.so
%vlc_plugindir/codec/libadpcm_plugin.so
%vlc_plugindir/codec/libaes3_plugin.so
%vlc_plugindir/codec/libaom_plugin.so
%vlc_plugindir/codec/libaraw_plugin.so
%vlc_plugindir/codec/libcc_plugin.so
%vlc_plugindir/codec/libcdg_plugin.so
%vlc_plugindir/codec/libcvdsub_plugin.so
%vlc_plugindir/codec/libddummy_plugin.so
%vlc_plugindir/codec/libdav1d_plugin.so
%vlc_plugindir/codec/libdca_plugin.so
%vlc_plugindir/codec/libdvbsub_plugin.so
%vlc_plugindir/codec/libedummy_plugin.so
%vlc_plugindir/codec/libg711_plugin.so
%vlc_plugindir/codec/libjpeg_plugin.so
%vlc_plugindir/codec/liblpcm_plugin.so
%vlc_plugindir/codec/libmpg123_plugin.so
%vlc_plugindir/codec/liboggspots_plugin.so
%vlc_plugindir/codec/libomxil_plugin.so
%vlc_plugindir/codec/libomxil_vout_plugin.so
%vlc_plugindir/codec/librawvideo_plugin.so
%vlc_plugindir/codec/librtpvideo_plugin.so
%vlc_plugindir/codec/libsdl_image_plugin.so
%vlc_plugindir/codec/libscte18_plugin.so
%vlc_plugindir/codec/libscte27_plugin.so
%vlc_plugindir/codec/libspdif_plugin.so
%vlc_plugindir/codec/libspudec_plugin.so
%vlc_plugindir/codec/libstl_plugin.so
%vlc_plugindir/codec/libsubsdec_plugin.so
%vlc_plugindir/codec/libsubstx3g_plugin.so
%vlc_plugindir/codec/libsubsusf_plugin.so
%vlc_plugindir/codec/libt140_plugin.so
%vlc_plugindir/codec/libtelx_plugin.so
%vlc_plugindir/codec/libtextst_plugin.so
%vlc_plugindir/codec/libttml_plugin.so
%vlc_plugindir/codec/libuleaddvaudio_plugin.so
%vlc_plugindir/codec/libvaapi_plugin.so
%vlc_plugindir/codec/libwebvtt_plugin.so
%vlc_plugindir/codec/libxwd_plugin.so

%dir %vlc_plugindir/control
%vlc_plugindir/control/liboldrc_plugin.so
%vlc_plugindir/control/libgestures_plugin.so
%vlc_plugindir/control/libhotkeys_plugin.so
%vlc_plugindir/control/libmotion_plugin.so
%vlc_plugindir/control/libnetsync_plugin.so
%vlc_plugindir/control/libdummy_plugin.so

%dir %vlc_plugindir/demux
%vlc_plugindir/demux/libadaptive_plugin.so
%vlc_plugindir/demux/libaiff_plugin.so
%vlc_plugindir/demux/libasf_plugin.so
%vlc_plugindir/demux/libau_plugin.so
%vlc_plugindir/demux/libavi_plugin.so
%vlc_plugindir/demux/libcaf_plugin.so
%vlc_plugindir/demux/libdemux_cdg_plugin.so
%vlc_plugindir/demux/libdemux_chromecast_plugin.so
%vlc_plugindir/demux/libdemux_stl_plugin.so
%vlc_plugindir/demux/libdemuxdump_plugin.so
%vlc_plugindir/demux/libdiracsys_plugin.so
%vlc_plugindir/demux/libdirectory_demux_plugin.so
%vlc_plugindir/demux/libes_plugin.so
%vlc_plugindir/demux/libh26x_plugin.so
%vlc_plugindir/demux/libimage_plugin.so
%vlc_plugindir/demux/libmjpeg_plugin.so
%vlc_plugindir/demux/libmp4_plugin.so
%vlc_plugindir/demux/libmpgv_plugin.so
%vlc_plugindir/demux/libnoseek_plugin.so
%vlc_plugindir/demux/libnsc_plugin.so
%vlc_plugindir/demux/libnsv_plugin.so
%vlc_plugindir/demux/libnuv_plugin.so
%vlc_plugindir/demux/libplaylist_plugin.so
%vlc_plugindir/demux/libps_plugin.so
%vlc_plugindir/demux/libpva_plugin.so
%vlc_plugindir/demux/librawaud_plugin.so
%vlc_plugindir/demux/librawdv_plugin.so
%vlc_plugindir/demux/librawvid_plugin.so
%vlc_plugindir/demux/libreal_plugin.so
%vlc_plugindir/demux/libsmf_plugin.so
%vlc_plugindir/demux/libsid_plugin.so
%vlc_plugindir/demux/libsubtitle_plugin.so
%vlc_plugindir/demux/libts_plugin.so
%vlc_plugindir/demux/libtta_plugin.so
%vlc_plugindir/demux/libty_plugin.so
%vlc_plugindir/demux/libvc1_plugin.so
%vlc_plugindir/demux/libvobsub_plugin.so
%vlc_plugindir/demux/libvoc_plugin.so
%vlc_plugindir/demux/libwav_plugin.so
%vlc_plugindir/demux/libxa_plugin.so

%dir %vlc_plugindir/gui

%dir %vlc_plugindir/keystore
%vlc_plugindir/keystore/libfile_keystore_plugin.so
%vlc_plugindir/keystore/libkwallet_plugin.so
%vlc_plugindir/keystore/libmemory_keystore_plugin.so
%vlc_plugindir/keystore/libsecret_plugin.so

%dir %vlc_plugindir/logger
%vlc_plugindir/logger/libsd_journal_plugin.so
%vlc_plugindir/logger/libconsole_logger_plugin.so
%vlc_plugindir/logger/libfile_logger_plugin.so
%vlc_plugindir/logger/libsyslog_plugin.so

%dir %vlc_plugindir/misc
%vlc_plugindir/misc/liblogger_plugin.so
%vlc_plugindir/misc/libvod_rtsp_plugin.so
%vlc_plugindir/misc/libexport_plugin.so
%vlc_plugindir/misc/libaudioscrobbler_plugin.so
%vlc_plugindir/misc/libstats_plugin.so
%vlc_plugindir/misc/libfingerprinter_plugin.so
%vlc_plugindir/misc/libxdg_screensaver_plugin.so
%vlc_plugindir/misc/libaddonsfsstorage_plugin.so
%vlc_plugindir/misc/libaddonsvorepository_plugin.so

%ifarch ppc ppc64
%dir %vlc_plugindir/altivec
%vlc_plugindir/altivec/libmemcpyaltivec_plugin.so
%vlc_plugindir/altivec/libi420_yuy2_altivec_plugin.so
%endif

%dir %vlc_plugindir/video_splitter
%vlc_plugindir/video_splitter/libclone_plugin.so
%vlc_plugindir/video_splitter/libwall_plugin.so

%dir %vlc_plugindir/services_discovery
%vlc_plugindir/services_discovery/libavahi_plugin.so
%vlc_plugindir/services_discovery/libmediadirs_plugin.so
%vlc_plugindir/services_discovery/libsap_plugin.so
%vlc_plugindir/services_discovery/libudev_plugin.so

%dir %vlc_plugindir/mux
%vlc_plugindir/mux/libmux_asf_plugin.so
%vlc_plugindir/mux/libmux_avi_plugin.so
%vlc_plugindir/mux/libmux_dummy_plugin.so
%vlc_plugindir/mux/libmux_mp4_plugin.so
%vlc_plugindir/mux/libmux_mpjpeg_plugin.so
%vlc_plugindir/mux/libmux_ps_plugin.so
%vlc_plugindir/mux/libmux_ts_plugin.so
%vlc_plugindir/mux/libmux_wav_plugin.so

%dir %vlc_plugindir/packetizer
%vlc_plugindir/packetizer/libpacketizer_a52_plugin.so
%vlc_plugindir/packetizer/libpacketizer_copy_plugin.so
%vlc_plugindir/packetizer/libpacketizer_dts_plugin.so
%vlc_plugindir/packetizer/libpacketizer_hevc_plugin.so
%vlc_plugindir/packetizer/libpacketizer_av1_plugin.so
%vlc_plugindir/packetizer/libpacketizer_mpeg4audio_plugin.so
%vlc_plugindir/packetizer/libpacketizer_mpeg4video_plugin.so
%vlc_plugindir/packetizer/libpacketizer_mpegaudio_plugin.so
%vlc_plugindir/packetizer/libpacketizer_mpegvideo_plugin.so
%vlc_plugindir/packetizer/libpacketizer_vc1_plugin.so
%vlc_plugindir/packetizer/libpacketizer_mlp_plugin.so
%vlc_plugindir/packetizer/libpacketizer_dirac_plugin.so
%vlc_plugindir/packetizer/libpacketizer_flac_plugin.so

%dir %vlc_plugindir/spu
%vlc_plugindir/spu/libaudiobargraph_v_plugin.so
%vlc_plugindir/spu/libdynamicoverlay_plugin.so
%vlc_plugindir/spu/liblogo_plugin.so
%vlc_plugindir/spu/libmarq_plugin.so
%vlc_plugindir/spu/libmosaic_plugin.so
%vlc_plugindir/spu/libremoteosd_plugin.so
%vlc_plugindir/spu/librss_plugin.so
%vlc_plugindir/spu/libsubsdelay_plugin.so

%dir %vlc_plugindir/stream_extractor
%vlc_plugindir/stream_extractor/libarchive_plugin.so

%dir %vlc_plugindir/stream_out
%vlc_plugindir/stream_out/libstream_out_chromecast_plugin.so
%vlc_plugindir/stream_out/libstream_out_display_plugin.so
%vlc_plugindir/stream_out/libstream_out_dummy_plugin.so
%vlc_plugindir/stream_out/libstream_out_duplicate_plugin.so
%vlc_plugindir/stream_out/libstream_out_es_plugin.so
%vlc_plugindir/stream_out/libstream_out_standard_plugin.so
%vlc_plugindir/stream_out/libstream_out_bridge_plugin.so
%vlc_plugindir/stream_out/libstream_out_cycle_plugin.so
%vlc_plugindir/stream_out/libstream_out_description_plugin.so
%vlc_plugindir/stream_out/libstream_out_gather_plugin.so
%vlc_plugindir/stream_out/libstream_out_mosaic_bridge_plugin.so
%vlc_plugindir/stream_out/libstream_out_rtp_plugin.so
%vlc_plugindir/stream_out/libstream_out_stats_plugin.so
%vlc_plugindir/stream_out/libstream_out_transcode_plugin.so
%vlc_plugindir/stream_out/libstream_out_autodel_plugin.so
%vlc_plugindir/stream_out/libstream_out_record_plugin.so
%vlc_plugindir/stream_out/libstream_out_smem_plugin.so
%vlc_plugindir/stream_out/libstream_out_delay_plugin.so
%vlc_plugindir/stream_out/libstream_out_setid_plugin.so

%dir %vlc_plugindir/stream_filter
%vlc_plugindir/stream_filter/libdecomp_plugin.so
%vlc_plugindir/stream_filter/librecord_plugin.so
%vlc_plugindir/stream_filter/libadf_plugin.so
%vlc_plugindir/stream_filter/libcache_block_plugin.so
%vlc_plugindir/stream_filter/libcache_read_plugin.so
%vlc_plugindir/stream_filter/libhds_plugin.so
%vlc_plugindir/stream_filter/libinflate_plugin.so
%vlc_plugindir/stream_filter/libprefetch_plugin.so
%vlc_plugindir/stream_filter/libskiptags_plugin.so

%dir %vlc_plugindir/text_renderer
%vlc_plugindir/text_renderer/libtdummy_plugin.so

%dir %vlc_plugindir/video_chroma
%vlc_plugindir/video_chroma/libchain_plugin.so
%vlc_plugindir/video_chroma/libi420_10_p010_plugin.so
%vlc_plugindir/video_chroma/libi420_nv12_plugin.so
%vlc_plugindir/video_chroma/libi420_rgb_plugin.so
%vlc_plugindir/video_chroma/libi420_yuy2_plugin.so
%vlc_plugindir/video_chroma/libi422_yuy2_plugin.so
%vlc_plugindir/video_chroma/libgrey_yuv_plugin.so
%vlc_plugindir/video_chroma/libi422_i420_plugin.so
%vlc_plugindir/video_chroma/libyuy2_i420_plugin.so
%vlc_plugindir/video_chroma/libyuy2_i422_plugin.so
%vlc_plugindir/video_chroma/libyuvp_plugin.so
%vlc_plugindir/video_chroma/librv32_plugin.so
%ifarch %ix86 x86_64
%vlc_plugindir/video_chroma/libi420_rgb_mmx_plugin.so
%vlc_plugindir/video_chroma/libi420_yuy2_mmx_plugin.so
%vlc_plugindir/video_chroma/libi422_yuy2_mmx_plugin.so
%vlc_plugindir/video_chroma/libi420_rgb_sse2_plugin.so
%vlc_plugindir/video_chroma/libi420_yuy2_sse2_plugin.so
%vlc_plugindir/video_chroma/libi422_yuy2_sse2_plugin.so
%endif

%dir %vlc_plugindir/video_filter
%vlc_plugindir/video_filter/libadjust_plugin.so
%vlc_plugindir/video_filter/libalphamask_plugin.so
%vlc_plugindir/video_filter/libantiflicker_plugin.so
%vlc_plugindir/video_filter/libball_plugin.so
%vlc_plugindir/video_filter/libblend_plugin.so
%vlc_plugindir/video_filter/libblendbench_plugin.so
%vlc_plugindir/video_filter/libbluescreen_plugin.so
%vlc_plugindir/video_filter/libcanvas_plugin.so
%vlc_plugindir/video_filter/libcolorthres_plugin.so
%vlc_plugindir/video_filter/libcroppadd_plugin.so
%vlc_plugindir/video_filter/libdeinterlace_plugin.so
%vlc_plugindir/video_filter/libedgedetection_plugin.so
%vlc_plugindir/video_filter/liberase_plugin.so
%vlc_plugindir/video_filter/libextract_plugin.so
%vlc_plugindir/video_filter/libfps_plugin.so
%vlc_plugindir/video_filter/libfreeze_plugin.so
%vlc_plugindir/video_filter/libgaussianblur_plugin.so
%vlc_plugindir/video_filter/libgradfun_plugin.so
%vlc_plugindir/video_filter/libgradient_plugin.so
%vlc_plugindir/video_filter/libgrain_plugin.so
%vlc_plugindir/video_filter/libhqdn3d_plugin.so
%vlc_plugindir/video_filter/libinvert_plugin.so
%vlc_plugindir/video_filter/libmagnify_plugin.so
%vlc_plugindir/video_filter/libmirror_plugin.so
%vlc_plugindir/video_filter/libmotionblur_plugin.so
%vlc_plugindir/video_filter/libmotiondetect_plugin.so
%vlc_plugindir/video_filter/liboldmovie_plugin.so
%vlc_plugindir/video_filter/libposterize_plugin.so
%vlc_plugindir/video_filter/libpsychedelic_plugin.so
%vlc_plugindir/video_filter/libpuzzle_plugin.so
%vlc_plugindir/video_filter/libripple_plugin.so
%vlc_plugindir/video_filter/librotate_plugin.so
%vlc_plugindir/video_filter/libscale_plugin.so
%vlc_plugindir/video_filter/libscene_plugin.so
%vlc_plugindir/video_filter/libsepia_plugin.so
%vlc_plugindir/video_filter/libsharpen_plugin.so
%vlc_plugindir/video_filter/libtransform_plugin.so
%vlc_plugindir/video_filter/libwave_plugin.so
%vlc_plugindir/video_filter/libvhs_plugin.so

%dir %vlc_plugindir/video_output
%vlc_plugindir/video_output/libglconv_vaapi_drm_plugin.so
%vlc_plugindir/video_output/libglconv_vaapi_wl_plugin.so
%vlc_plugindir/video_output/libglconv_vaapi_x11_plugin.so
%vlc_plugindir/video_output/libglconv_vdpau_plugin.so
%vlc_plugindir/video_output/libvdummy_plugin.so
%vlc_plugindir/video_output/libvmem_plugin.so
%vlc_plugindir/video_output/libyuv_plugin.so
%vlc_plugindir/video_output/libegl_wl_plugin.so
%vlc_plugindir/video_output/libflaschen_plugin.so
%vlc_plugindir/video_output/libwl_shell_plugin.so
%vlc_plugindir/video_output/libwl_shm_plugin.so
%vlc_plugindir/video_output/libxdg_shell_plugin.so

%dir %vlc_plugindir/visualization
%vlc_plugindir/visualization/libvisual_plugin.so

%dir %vlc_plugindir/meta_engine
%vlc_plugindir/meta_engine/libfolder_plugin.so

%vlc_plugindir/lua
%vlc_libdir/lua


%doc AUTHORS README NEWS THANKS

%files interface-ncurses
%_bindir/nvlc
%vlc_plugindir/gui/libncurses_plugin.so

%files interface-skins2
%_bindir/svlc
%vlc_plugindir/gui/libskins2_plugin.so
%_datadir/%name/skins2

%files interface-lirc
%vlc_plugindir/control/liblirc_plugin.so

%files interface-qt
%_bindir/qvlc
%vlc_plugindir/gui/libqt_plugin.so
%_datadir/applications/vlc.desktop

%files plugin-schroedinger
%vlc_plugindir/codec/libschroedinger_plugin.so

%files plugin-jack
%vlc_plugindir/audio_output/libjack_plugin.so
%vlc_plugindir/access/libaccess_jack_plugin.so

%files plugin-bluray
%vlc_plugindir/access/liblibbluray_plugin.so

%files plugin-linsys
%vlc_plugindir/access/liblinsys_sdi_plugin.so
%vlc_plugindir/access/liblinsys_hdsdi_plugin.so

%if_enabled goom
%files plugin-goom
%vlc_plugindir/visualization/libgoom_plugin.so
%endif

%files plugin-v4l
%vlc_plugindir/access/libv4l2_plugin.so

%files plugin-live555
%vlc_plugindir/access/liblive555_plugin.so

%files plugin-matroska
%vlc_plugindir/demux/libmkv_plugin.so

%files plugin-modplug
%vlc_plugindir/demux/libmod_plugin.so

%files plugin-mpeg2
%vlc_plugindir/codec/liblibmpeg2_plugin.so
%vlc_plugindir/codec/libzvbi_plugin.so

%files plugin-mtp
%vlc_plugindir/access/libaccess_mtp_plugin.so
%vlc_plugindir/services_discovery/libmtp_plugin.so

%files plugin-musepack
%vlc_plugindir/demux/libmpc_plugin.so

%files plugin-notify
%vlc_plugindir/notify/libnotify_plugin.so

%files plugin-speex
%vlc_plugindir/codec/libspeex_plugin.so
%vlc_plugindir/audio_filter/libspeex_resampler_plugin.so

%files plugin-ogg
%vlc_plugindir/mux/libmux_ogg_plugin.so
%vlc_plugindir/demux/libogg_plugin.so
%vlc_plugindir/codec/libvorbis_plugin.so
%vlc_plugindir/codec/libkate_plugin.so

%files plugin-opus
%vlc_plugindir/codec/libopus_plugin.so

%files plugin-flac
%vlc_plugindir/demux/libflacsys_plugin.so
%vlc_plugindir/codec/libflac_plugin.so

%files plugin-fluidsynth
%vlc_plugindir/codec/libfluidsynth_plugin.so

%files plugin-h264
%vlc_plugindir/codec/libx264_plugin.so
%vlc_plugindir/packetizer/libpacketizer_h264_plugin.so

%files plugin-h265
%vlc_plugindir/codec/libx265_plugin.so

%files plugin-vpx
%vlc_plugindir/codec/libvpx_plugin.so

%files plugin-aa
%vlc_plugindir/video_output/libaa_plugin.so

%files plugin-chromaprint
%vlc_plugindir/stream_out/libstream_out_chromaprint_plugin.so

%files plugin-taglib
%vlc_plugindir/meta_engine/libtaglib_plugin.so

%files plugin-theora
%vlc_plugindir/codec/libtheora_plugin.so

%files plugin-globalhotkeys
#vlc_plugindir/control/libglobalhotkeys_plugin.so

%files plugin-ffmpeg
%vlc_plugindir/access/libavio_plugin.so
%vlc_plugindir/codec/libavcodec_plugin.so
%vlc_plugindir/demux/libavformat_plugin.so
%vlc_plugindir/video_chroma/libswscale_plugin.so
%vlc_plugindir/video_filter/libpostproc_plugin.so
%vlc_plugindir/packetizer/libpacketizer_avparser_plugin.so

%files plugin-framebuffer
%vlc_plugindir/video_output/libfb_plugin.so

%files plugin-shout
%vlc_plugindir/access_output/libaccess_output_shout_plugin.so

%if_enabled freerdp
%files plugin-rdp
%vlc_plugindir/access/libvnc_plugin.so
%vlc_plugindir/access/librdp_plugin.so
%endif

%files plugin-xcb
%dir %vlc_plugindir/vdpau
%dir %vlc_plugindir/vaapi
%_libdir/vlc/libvlc_vdpau.so*
%vlc_plugindir/access/libxcb_screen_plugin.so
%vlc_plugindir/codec/libvaapi_drm_plugin.so
%vlc_plugindir/control/libxcb_hotkeys_plugin.so
%vlc_plugindir/services_discovery/libxcb_apps_plugin.so
%vlc_plugindir/vdpau/libvdpau_sharpen_plugin.so
%vlc_plugindir/vdpau/libvdpau_display_plugin.so
%vlc_plugindir/vdpau/libvdpau_deinterlace_plugin.so
%vlc_plugindir/vdpau/libvdpau_avcodec_plugin.so
%vlc_plugindir/vdpau/libvdpau_adjust_plugin.so
%vlc_plugindir/vdpau/libvdpau_chroma_plugin.so
%vlc_plugindir/vaapi/libvaapi_filters_plugin.so
%vlc_plugindir/video_output/libxcb_window_plugin.so
%vlc_plugindir/video_output/libxcb_x11_plugin.so
%vlc_plugindir/video_output/libxcb_xv_plugin.so
%vlc_plugindir/video_output/libegl_x11_plugin.so
%vlc_plugindir/video_output/libgl_plugin.so
%vlc_plugindir/video_output/libgles2_plugin.so
%vlc_plugindir/video_output/libglx_plugin.so
%vlc_plugindir/video_filter/libanaglyph_plugin.so
%vlc_plugindir/video_splitter/libpanoramix_plugin.so
%vlc_plugindir/visualization/libglspectrum_plugin.so

%files plugin-xml
%vlc_plugindir/misc/libxml_plugin.so

%files plugin-png
%vlc_plugindir/codec/libpng_plugin.so

%files plugin-podcast
%vlc_plugindir/services_discovery/libpodcast_plugin.so

%files plugin-pulseaudio
%vlc_plugindir/audio_output/libpulse_plugin.so
%vlc_plugindir/services_discovery/libpulselist_plugin.so
%vlc_plugindir/access/libpulsesrc_plugin.so

%files plugin-upnp
%vlc_plugindir/services_discovery/libupnp_plugin.so

%files plugin-realrtsp
%vlc_plugindir/access/libaccess_realrtsp_plugin.so

%files plugin-dbus
%vlc_plugindir/control/libdbus_plugin.so
%vlc_plugindir/misc/libdbus_screensaver_plugin.so

%if_enabled firewire
%files plugin-dv
%vlc_plugindir/access/libdc1394_plugin.so
%vlc_plugindir/access/libdv1394_plugin.so
%endif

%files plugin-twolame
%vlc_plugindir/codec/libtwolame_plugin.so

%files plugin-dvdnav
%vlc_plugindir/access/libdvdnav_plugin.so

%files plugin-dvdread
%vlc_plugindir/access/libdvdread_plugin.so

%files plugin-freetype
%vlc_plugindir/text_renderer/libfreetype_plugin.so

%files plugin-gnutls
%vlc_plugindir/misc/libgnutls_plugin.so

%files plugin-smb
%vlc_plugindir/access/libsmb_plugin.so

%files plugin-svg
%vlc_plugindir/codec/libsvgdec_plugin.so
%vlc_plugindir/text_renderer/libsvg_plugin.so

%files plugin-videocd
%vlc_plugindir/access/libvcd_plugin.so
%vlc_plugindir/codec/libsvcdsub_plugin.so

%files plugin-audiocd
%vlc_plugindir/access/libcdda_plugin.so

%files plugin-ass
%vlc_plugindir/codec/liblibass_plugin.so

%if_enabled visualization
%files plugin-projectm
%vlc_plugindir/visualization/libprojectm_plugin.so
%endif

%files -n lib%name
%dir %vlc_libdir
%_libdir/libvlccore.so.*
%_libdir/libvlc.so.*
%_libdir/vlc/libvlc_pulse.so.*
%_libdir/vlc/libvlc_xcb_events.so.*

%files -n lib%name-devel
%_pkgconfigdir/*.pc
%_includedir/*
%_libdir/vlc/libcompat.a
%_libdir/libvlccore.so
%_libdir/libvlc.so
%_libdir/vlc/libvlc_pulse.so
%_libdir/vlc/libvlc_xcb_events.so

%files -n vim-plugin-vlc-syntax
%vim_syntax_dir/vlc.vim

%files -n fortunes-vlc
%_gamesdatadir/fortune/vlc*

%files
%_datadir/kf5/solid/actions/vlc-openbd.desktop
%_datadir/kf5/solid/actions/vlc-opencda.desktop
%_datadir/kf5/solid/actions/vlc-opendvd.desktop
%_datadir/kf5/solid/actions/vlc-openvcd.desktop

%files maxi

%changelog
