%define build_type RelWithDebInfo
%define _cmake %cmake -DCMAKE_BUILD_TYPE=%build_type -DCMAKE_VERBOSE_MAKEFILE:BOOL=ON

Name: vulkan
Version: 1.2.196
Release: alt1.p9.1
Summary: Khronos group Vulkan API SDK

Group: System/Libraries
License: Apache-2.0
Url: http://www.khronos.org/

# https://github.com/KhronosGroup/Vulkan-Loader
Source0: vulkan-loader.tar
# https://github.com/KhronosGroup/Vulkan-Headers
Source1: vulkan-headers.tar
# https://github.com/KhronosGroup/Vulkan-Tools
Source2: vulkan-tools.tar
# https://github.com/KhronosGroup/Vulkan-ValidationLayers
Source3: vulkan-layers.tar

BuildRequires: bison chrpath
BuildRequires(pre): cmake gcc-c++ rpm-build-python3
BuildRequires: libImageMagick-devel libpciaccess-devel libsystemd-devel
BuildRequires: python3-devel libxcb-devel libXau-devel libXdmcp-devel libX11-devel libXrandr-devel
BuildRequires: wayland-devel libwayland-server-devel libwayland-client-devel libwayland-cursor-devel libwayland-egl-devel
# strict requires due internal dependency
BuildRequires: glslang-devel = 11.7.0
BuildRequires: libspirv-tools-devel = 2021.4
BuildRequires: spirv-headers >= 1.5.4-alt3
# -layers need it
BuildRequires: librobin-hood-hashing-devel

# textrel due asm optimisation in loader code
%ifarch i586
%set_verify_elf_method textrel=relaxed
%endif

# filter out self-provided requires
%add_python3_req_skip spec_tools.util

%description
Vulkan is a new generation graphics and compute API that provides
high-efficiency, cross-platform access to modern GPUs used in a wide
variety of devices from PCs and consoles to mobile phones and embedded
platforms.

This package contains the reference ICD loader and API validation layer for
Vulkan.

%package -n lib%{name}1
Summary: Vulkan loader libraries
Group: System/Libraries
Requires: vulkan-filesystem = %version-%release
Provides: %name = %version-%release
Obsoletes: %name

%description -n lib%{name}1
Vulkan is a new generation graphics and compute API that provides
high-efficiency, cross-platform access to modern GPUs used in a wide
variety of devices from PCs and consoles to mobile phones and embedded
platforms.

This package contains the reference ICD loader for Vulkan.

%package validation-layers
Summary: Vulkan API validation layers
Group: Development/C++
Requires: lib%{name}1 = %version-%release

%description validation-layers
Vulkan API validation layer for developers.

%package -n lib%name-devel
Summary: Vulkan development package
Group: Development/C++
Requires: lib%{name}1 = %version-%release
Provides: %name-devel = %version-%release
Obsoletes: %name-devel

%description -n lib%name-devel
Development headers for Vulkan applications.

%package filesystem
Summary: Vulkan filesystem package
Group: System/Base
BuildArch: noarch

%description filesystem
Filesystem for Vulkan API.

%package tools
Summary: Vulkan tools and utilities
Group: System/X11
Requires: lib%{name}1 = %version-%release
Obsoletes: %name-demos

%description tools
Tools and utilities that can assist development by enabling developers to
verify their applications correct use of the Vulkan API.

%prep
%setup -n %name-loader -b0 -b1 -b2 -b3
pushd ../vulkan-layers
# sigh inttypes
sed -i 's/inttypes.h/cinttypes/' layers/*.{cpp,h}
popd

%build
%ifarch %e2k
# lcc 1.24.11 considers parameter_validation_utils.cpp partially meaningless
# and vk_mem_alloc.h somewhat pointless and overdeclaring
%add_optflags -Wno-error=ignored-qualifiers -Wno-error=type-limits -Wno-error=unused-variable
%endif
# vulkan-headers first
pushd %_builddir/vulkan-headers
%_cmake
%cmake_build
%cmakeinstall_std
popd

# then vulkan-loader and layers
for dir in loader layers; do
pushd %_builddir/vulkan-"$dir"
%_cmake \
           -DSPIRV_TOOLS_SEARCH_PATH=%_libdir \
           -DSPIRV_TOOLS_OPT_SEARCH_PATH=%_libdir \
	   -DVULKAN_HEADERS_INSTALL_DIR=%buildroot \
	   -DGLSLANG_INSTALL_DIR=%_prefix \
	   -DSPIRV_HEADERS_INSTALL_DIR=%_prefix \
	   -DVulkanHeaders_INCLUDE_DIR=%buildroot%_includedir \
	   -DVulkanRegistry_DIR=%buildroot%_datadir \
	   -DROBIN_HOOD_HASHING_INCLUDE_DIR=%_includedir
%cmake_build
%cmakeinstall_std
popd
done

# end finally -tools
pushd %_builddir/vulkan-tools
%_cmake \
	   -DCMAKE_PREFIX_PATH=%buildroot%prefix \
	   -DGLSLANG_INSTALL_DIR=%_prefix
%cmake_build
%cmakeinstall_std
popd

%install
# do it again
for dir in headers layers loader tools; do
pushd %_builddir/vulkan-"$dir"
%cmakeinstall_std
popd
done
mkdir -p %buildroot%_sysconfdir/vulkan/explicit_layer.d
mkdir -p %buildroot%_datadir/vulkan/{explicit,implicit}_layer.d/ ||:
mkdir -p %buildroot%_datadir/vulkan/icd.d ||:

# remove RPATH
chrpath -d %buildroot%_bindir/vulkaninfo

# remove static libs to make LTO checks happy
rm -rf %buildroot%_libdir/libVkLayer*.a ||:

%files tools
%_bindir/*

%files -n lib%{name}1
%doc README.md LICENSE.txt
%_libdir/libvulkan.so.1*

%files -n lib%name-devel
%dir %_includedir/vulkan
%dir %_includedir/vk_video
%_includedir/vulkan
%_includedir/vk_video
%_libdir/libvulkan.so
%_pkgconfigdir/vulkan.pc
%_datadir/vulkan/registry
# requires vulkan-docs tools
%exclude %_datadir/vulkan/registry/genvk.py

%files validation-layers
%_datadir/vulkan/explicit_layer.d/*.json
%_libdir/libVkLayer*.so

%files filesystem
%dir %_sysconfdir/vulkan
%dir %_sysconfdir/vulkan/explicit_layer.d
%dir %_datadir/vulkan
%dir %_datadir/vulkan/icd.d
%dir %_datadir/vulkan/explicit_layer.d
%dir %_datadir/vulkan/implicit_layer.d

%changelog
