Name: winetricks
Version: 20230505
Release: alt1

Summary: Work around common problems in Wine

License: LGPLv2+
Group: File tools
Url: https://github.com/Winetricks/winetricks

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/Winetricks/winetricks/archive/refs/heads/master.zip
#Source-url: %url/archive/%version/%name-%version.tar.gz
Source: %name-%version.tar

Patch2: 0001-winetricks-try-use-xvt-as-terminal.patch

BuildArch: noarch

ExclusiveArch: %ix86 x86_64 %arm aarch64

#BuildRequires: wine-common
BuildRequires: desktop-file-utils

# runtime dependencies
#Requires: /usr/bin/wine
Requires: cabextract gzip unzip wget which

#Requires: hicolor-icon-theme
Conflicts: wine-vanilla < 3.18
Conflicts: wine < 3.18
Conflicts: wine-etersoft < 4.0

%description
Winetricks is an easy way to work around common problems in Wine.

It has a menu of supported games/apps for which it can do all the
workarounds automatically. It also lets you install missing DLLs
or tweak various Wine settings individually.
 
%prep
%setup
%patch2 -p1

# fix req. Disable autoreq at all?
%__subst 's|fusermount|a= fusermount|' src/winetricks

sed -i -e "s:steam::" -e "s:flash::" tests/*

%build
subst 's|WINETRICKS_VERSION=.*|WINETRICKS_VERSION=%version-%release|' src/winetricks
# disable version checking
subst 's|winetricks_latest_version_check$||' src/winetricks

%install
%makeinstall_std
# some tarballs do not install appdata
install -m0644 -D -t %buildroot%_datadir/metainfo src/%name.appdata.xml
# hack for empty output to console
subst 's|Terminal=false|Terminal=true|' %buildroot%_desktopdir/%name.desktop

%check
desktop-file-validate %buildroot%_desktopdir/%name.desktop

%files
%doc COPYING debian/copyright
%doc README.md
%_bindir/%name
%_man1dir/%name.1*
%_iconsdir/hicolor/scalable/apps/%name.svg
%_desktopdir/%name.desktop
%_datadir/metainfo/%name.appdata.xml
%_datadir/bash-completion/completions/winetricks
#exclude %_datadir/appdata/%name.appdata.xml

%changelog
