%define luaver 5.1
Name: wxlua
Version: 3.0.0.8
Release: alt1
Summary: Lua IDE with a GUI debugger and binding generator
License: wxWidgets License
Group: Development/Other
Url: http://wxlua.sourceforge.net/

# https://github.com/pkulchenko/wxlua/
Source: %name-%version.tar

BuildRequires: lua%luaver lua%luaver-devel
#BuildRequires: doxygen graphviz
# Automatically added by buildreq on Thu Oct 05 2017 (-bi)
# optimized out: at-spi2-atk cmake-modules elfutils fontconfig glibc-kernheaders-x86 libX11-devel libat-spi2-core libcairo-gobject libgdk-pixbuf libgpg-error libgst-plugins1.0 libstdc++-devel libwayland-client libwayland-cursor libwayland-egl libwayland-server lua5.3 perl python-base python-module-mpl_toolkits python-modules xorg-xproto-devel
BuildRequires: cmake desktop-file-utils gcc-c++ glibc-kernheaders-generic libGL-devel libwxGTK3.1-devel libwxstedit-devel

Provides: lib%name = %version
Obsoletes: lib%name < 3

%description
wxLua is a set of bindings to the C++ wxWidgets cross-platform GUI library for
the Lua programming language. Nearly all of the functionality of wxWidgets is
exposed to Lua, meaning that your programs can have windows, dialogs, menus,
toolbars, controls, image loading and saving, drawing, sockets, streams,
printing, clipboard access... and much more.

Additionally, wxLua can be used in your C++ programs to embed a Lua interpreter
with the wxWidgets API.

%package apps
Group: Development/Other
Summary: set of apps demonstrating wxLua
Requires: %name = %version-%release

%description apps
wxLua is a set of bindings to the C++ wxWidgets cross-platform GUI library for
the Lua programming language. Nearly all of the functionality of wxWidgets is
exposed to Lua, meaning that your programs can have windows, dialogs, menus,
toolbars, controls, image loading and saving, drawing, sockets, streams,
printing, clipboard access... and much more.

This package contains Integrated Development Environments (IDE, written in
wxLua) with a GUI debugger, a binding generator and wxWidgets bindings usable
as a module.

%package -n lib%name-devel
Group: Development/C++
Summary: Development files of lib%name
Requires: %name-apps = %version-%release

%description -n lib%name-devel
wxLua is a set of bindings to the C++ wxWidgets cross-platform GUI library for
the Lua programming language. Nearly all of the functionality of wxWidgets is
exposed to Lua, meaning that your programs can have windows, dialogs, menus,
toolbars, controls, image loading and saving, drawing, sockets, streams,
printing, clipboard access... and much more.

This package contains files required for compiling and linking
applications with lib%name.

%if_enabled static
%package -n lib%name-devel-static
Group: Development/C++
Summary: Static library of %name
Requires: %name-devel = %version-%release

%description -n lib%name-devel-static
This package contains the static library required for statically linking
applications with %name.

%endif #enabled static

%prep
%setup
rm -rf modules/{lua-*,wxstedit}/*
sed -r -i 's|LIBRARY DESTINATION .*$|LIBRARY DESTINATION %_lib|' \
	CMakeLists.txt

# prepare external wxstedit
mkdir -p modules/wxstedit
ln -s /usr/include modules/wxstedit/
echo "project( wxStEdit )" > modules/wxstedit/CMakeLists.txt

%build
make -C bindings \
	clean all \
	LUA=%_bindir/lua%luaver

# Build for ZBS, hence add some patches and tricks from
#   https://github.com/pkulchenko/ZeroBraneStudio/blob/master/build/build-linux.sh#L300
# possible option:	-DBUILD_SHARED_LIBS=FALSE
%cmake \
	-DwxLua_LUA_LIBRARY_USE_BUILTIN=FALSE \
	-DwxStEdit_ROOT_DIR=$PWD/modules/wxstedit \
	-DCMAKE_CXX_FLAGS="-DLUA_COMPAT_MODULE" \
	-DwxWidgets_COMPONENTS="xrc;xml;stc;gl;html;aui;adv;core;net;base" \
	-DwxLuaBind_COMPONENTS="xrc;xml;stc;gl;html;aui;adv;core;net;base" \

%cmake_build
if [ -x /usr/bin/doxygen ]; then
	%cmake_build wxLua_doxygen
fi

%install
%cmakeinstall_std

mkdir -p \
	%buildroot%_desktopdir/ \
	%buildroot%_libdir/lua/%luaver \
	%buildroot%_iconsdir/hicolor/scalable/apps/
install -p art/wxlualogo.svg %buildroot%_iconsdir/hicolor/scalable/apps/
mv %buildroot%_libdir/libwx.so %buildroot%_libdir/lua/%luaver/wx.so
install -p distrib/autopackage/%name.desktop %buildroot%_desktopdir/
sed -r -i "s|wxluaedit|wxLuaEdit|" %buildroot%_desktopdir/%name.desktop
desktop-file-install --dir %buildroot%_desktopdir \
	--remove-category=Application \
	--add-category=IDE \
	%buildroot%_desktopdir/%name.desktop
rm -rf docs2distribute{,-apps} ; mkdir docs2distribute-apps
mv %buildroot%_datadir/%name/doc docs2distribute
mv %buildroot%_datadir/%name/samples docs2distribute-apps/

%files
%_libdir/lua/%luaver/*.so
%doc docs2distribute/*

%files apps
%_bindir/*
%_libdir/*.so
%_desktopdir/*.desktop
%_iconsdir/hicolor/scalable/apps/*
%_datadir/%name
%doc docs2distribute-apps/*

%files -n lib%name-devel
%_includedir/%name
#%%doc BUILD/doc-wxLua/*

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%changelog
