%def_with python
%def_with python3
%def_with ruby
%def_without doc

Name: xapian-bindings
Version: 1.4.15
Release: alt1

Summary: Xapian search engine bindings

License: GPL
Group: Development/Other
Url: http://www.xapian.org/

Source: http://www.oligarchy.co.uk/xapian/%version/%name-%version.tar
Source100: xapian-bindings.watch

Patch1: %name-%version-alt-no-docs.patch

%setup_python_module %name

# Automatically added by buildreq on Thu Dec 05 2013
# optimized out: elfutils gnu-config libncurses-devel libstdc++-devel libtinfo-devel pam0_userpass python-base python-modules python-modules-compiler ruby ruby-stdlibs xz
BuildRequires: gcc-c++ libruby-devel libxapian-devel python-devel
%if_with doc
BuildRequires: python-module-sphinx-devel python-module-sphinx
%endif
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-dev
%if_with doc
BuildRequires: python3-module-sphinx-devel python3-module-sphinx
%endif
%endif

%{?_with_python:BuildRequires: python-devel}
%{?_with_ruby:BuildRequires: libruby-devel}

BuildRequires: libxapian-devel = %version

%description
Xapian is an Open Source Probabilistic Information Retrieval framework.
It offers a highly adaptable toolkit that allows developers to easily
add advanced indexing and search facilities to applications.

This package contains programming language bindings.

%package -n python-module-xapian
Summary: Python bindings for Xapian search engine
License: GPL
Group: Development/Python
# force rebuild with libxapian
Requires: libxapian = %version

%description -n python-module-xapian
Xapian is an Open Source Probabilistic Information Retrieval framework.
It offers a highly adaptable toolkit that allows developers to easily
add advanced indexing and search facilities to applications.

This package provides the files needed for developing Python scripts
which use Xapian.

%package -n python3-module-xapian
Summary: Python 3 bindings for Xapian search engine
License: GPL
Group: Development/Python3
# force rebuild with libxapian
Requires: libxapian = %version

%description -n python3-module-xapian
Xapian is an Open Source Probabilistic Information Retrieval framework.
It offers a highly adaptable toolkit that allows developers to easily
add advanced indexing and search facilities to applications.

This package provides the files needed for developing Python 3 scripts
which use Xapian.

%package -n ruby-xapian
Summary: Ruby bindings for Xapian search engine
License: GPL
Group: Development/Ruby
Requires: libxapian = %version

%description -n ruby-xapian
Xapian is an Open Source Probabilistic Information Retrieval framework.
It offers a highly adaptable toolkit that allows developers to easily
add advanced indexing and search facilities to applications.

This package provides the files needed for developing Ruby scripts
which use Xapian.

%prep
%setup
%if_without doc
%patch1 -p2
%endif

%build
%ifarch %e2k
# http://stackoverflow.com/questions/14892101/
%add_optflags -ftls-model=global-dynamic
%endif
%autoreconf
%configure %{subst_with python} %{subst_with python3} %{subst_with ruby}
%make_build
# FIXME: maybe we should drop %version there as well and get rid of this

%install
%makeinstall_std
rm -rf %buildroot%_defaultdocdir/%name/

%if_with python
%files -n python-module-xapian
%doc README python/docs/*
%python_sitelibdir/*
%endif

%if_with python3
%files -n python3-module-xapian
%doc README python/docs/*
%python3_sitelibdir/*
%endif

%if_with ruby
%files -n ruby-xapian
%doc README ruby/docs/*
%ruby_sitearchdir/_xapian.so
%ruby__sitelibdir/xapian.rb
%endif

# TODO:
# - package other bindings (perl, tcl...)
# - package docs/examples properly

# NOTE:
# - do NOT build this package from git unless you want to maintain it,
#   I use watch file and it's more convenient to do that with srpms

%changelog
