%define _userunitdir %(pkg-config systemd --variable systemduserunitdir)
%define _libexecdir %_prefix/libexec
%def_disable docs

Name: xdg-desktop-portal
Version: 1.2.0
Release: alt1

Summary: Portal frontend service to Flatpak
Group: Graphical desktop/GNOME
License: LGPLv2+
Url: https://github.com/flatpak/%name

Source: %url/releases/download/%version/%name-%version.tar.xz

%define geoclue_ver 2.5.2

Requires: dbus
Requires: flatpak >= 1.2.0
Requires: /usr/bin/fusermount
Requires: pipewire
Requires: geoclue2 >= %geoclue_ver

BuildRequires: pkgconfig(flatpak)
BuildRequires: pkgconfig(fuse)
BuildRequires: pkgconfig(gio-unix-2.0)
BuildRequires: pkgconfig(libpipewire-0.2)
BuildRequires: pkgconfig(fontconfig)
BuildRequires: pkgconfig(libgeoclue-2.0) >= %geoclue_ver
BuildRequires: pkgconfig(systemd)
%{?_enable_docs:BuildRequires: xmlto docbook-dtds docbook-style-xsl}

%description
xdg-desktop-portal works by exposing a series of D-Bus interfaces known as
portals under a well-known name (org.freedesktop.portal.Desktop) and object
path (/org/freedesktop/portal/desktop). The portal interfaces include APIs for
file access, opening URIs, printing and others.

%package devel
Summary: Development files for %name
Group: Development/C
BuildArch: noarch
Requires: %name = %version-%release

%description devel
The pkg-config file for %name.

%prep
%setup

%build
%autoreconf
%configure %{?_disable_docs:--disable-docbook-docs}
%make_build

%install
%makeinstall_std
# directory for portals such as xdg-desktop-portal-gtk
install -d -m755 %buildroot/%_datadir/%name/portals

%find_lang %name

%files -f %name.lang
%_libexecdir/%name
%_libexecdir/xdg-document-portal
%_libexecdir/xdg-permission-store
%_datadir/dbus-1/interfaces/org.freedesktop.portal.*.xml
%_datadir/dbus-1/interfaces/org.freedesktop.impl.portal.*.xml
%_datadir/dbus-1/services/org.freedesktop.portal.Desktop.service
%_datadir/dbus-1/services/org.freedesktop.portal.Documents.service
%_datadir/dbus-1/services/org.freedesktop.impl.portal.PermissionStore.service
%_datadir/%name/
%_userunitdir/%name.service
%_userunitdir/xdg-document-portal.service
%_userunitdir/xdg-permission-store.service
%doc README.md NEWS
%{?_enable_docs:%doc %_docdir/%name}

%files devel
%_datadir/pkgconfig/%name.pc


%changelog
