%define xfce_ver 4.13
%def_enable introspection
%def_enable vala

Name: xfce4-panel
Version: 4.14.4
Release: alt1

Summary: Panel for Xfce
Summary(ru_RU.UTF-8): Панель для окружения рабочего стола Xfce
License: GPLv2+
Group: Graphical desktop/XFce
Url: https://www.xfce.org/

Vcs: git://git.xfce.org/xfce/xfce4-panel
Source: %name-%version.tar
Patch: %name-%version-%release.patch
Packager: Xfce Team <xfce@packages.altlinux.org>

BuildPreReq: rpm-build-xfce4 >= 0.1.0 xfce4-dev-tools
BuildPreReq: libxfce4ui-gtk3-devel >= %xfce_ver libexo-gtk3-devel >= 0.6.0 libgarcon-gtk3-devel
BuildRequires: gtk-doc libwnck3-devel libICE-devel libXext-devel libSM-devel
BuildRequires: libgtk+3-devel
BuildRequires: libgtk+2-devel
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libgtk+3-gir-devel libxfce4util-gir-devel}
%{?_enable_vala:BuildRequires: vala-tools}

Requires: libxfce4panel = %version-%release
Requires: xfce4-common

Obsoletes: xfce4-showdesktop-plugin, xfce4-windowlist-plugin

%define libxfce4panel_name_gtk2 libxfce4panel-1.0
%define libxfce4panel_name_gtk3 libxfce4panel-2.0
%define wrapper_name_gtk3 wrapper-2.0

%define _unpackaged_files_terminate_build 1

%description
%name is the panel for the Xfce desktop environment.

%description -l ru_RU.UTF-8
Данный пакет содержит в себе панель для окружения рабочего стола Xfce.

%package -n libxfce4panel
Summary: Library for Xfce panel (GTK+2)
License: LGPLv2.1+
Group: Development/C

%description -n libxfce4panel
This package contains library for Xfce panel plugins
(GTK+2 variant).

%package -n libxfce4panel-devel
Summary: Development files to build Xfce panel plugins (GTK+2)
License: LGPLv2.1+
Group: Development/C
Requires: libxfce4panel = %version-%release
Provides: %name-devel = %version-%release
Obsoletes: %name-devel < 4.8.0

%description -n libxfce4panel-devel
This package contains files to develop plugins for Xfce panel
(GTK+2 variant).

%package -n libxfce4panel-devel-doc
Summary: Documentation files to build Xfce panel plugins
Group: Development/Documentation
Requires: libxfce4panel-devel = %version-%release
Provides: %name-devel-doc = %version-%release
Obsoletes: %name-devel-doc < 4.8.0
BuildArch: noarch

%description -n libxfce4panel-devel-doc
This package contains files to develop plugins for Xfce panel.

%package -n libxfce4panel-gtk3
Summary: Library for Xfce panel (GTK+3)
License: LGPLv2.1+
Group: Development/C

%description -n libxfce4panel-gtk3
This package contains library for Xfce panel plugins
(GTK+3 variant).

%package -n libxfce4panel-gtk3-devel
Summary: Development files to build Xfce panel plugins (GTK+3)
License: LGPLv2.1+
Group: Development/C
Requires: libxfce4panel-gtk3 = %version-%release

%description -n libxfce4panel-gtk3-devel
This package contains files to develop plugins for Xfce panel
(GTK+3 variant).

%if_enabled introspection
%package -n libxfce4panel-gtk3-gir
Summary: GObject introspection data for libxfce4panel-gtk3
Group: System/Libraries
Requires: libxfce4panel-gtk3 = %EVR

%description -n libxfce4panel-gtk3-gir
GObject introspection data for libxfce4panel-gtk3.

%package -n libxfce4panel-gtk3-gir-devel
Summary: GObject introspection devel data for libxfce4panel-gtk3
Group: System/Libraries
BuildArch: noarch
Requires: libxfce4panel-gtk3-gir = %EVR
Requires: libxfce4panel-gtk3-devel = %EVR

%description -n libxfce4panel-gtk3-gir-devel
GObject introspection devel data for libxfce4panel-gtk3.
%endif

%if_enabled vala
%package -n libxfce4panel-gtk3-vala
Summary: Vala bindings for libxfce4panel-gtk3
Group: System/Libraries
Requires: libxfce4panel-gtk3-devel = %EVR
BuildArch: noarch

%description -n libxfce4panel-gtk3-vala
Vala bindings for libxfce4panel-gtk3.
%endif


%prep
%setup
%patch -p1

%build
# Don't use git tag in version.
%xfce4_drop_gitvtag xfce4_panel_version_tag configure.ac.in
%xfce4reconf
%configure \
	--disable-static \
	--enable-maintainer-mode \
	%{subst_enable introspection} \
	%{subst_enable vala} \
	--enable-gtk-doc \
	--enable-gtk2 \
	--enable-debug=minimum
%make_build

%install
%makeinstall_std
%find_lang %name

%files -f %name.lang
%doc AUTHORS NEWS README
%config(noreplace) %_sysconfdir/xdg/xfce4/*
%_bindir/*
%_libdir/xfce4/panel/
%exclude %_libdir/xfce4/panel/%wrapper_name_gtk3
%_iconsdir/hicolor/*/*/*
%_datadir/xfce4/panel/
%_desktopdir/*.desktop
%exclude %_libdir/xfce4/panel/plugins/*.la

%files -n libxfce4panel
%_libdir/%libxfce4panel_name_gtk2.so.*

%files -n libxfce4panel-devel
%_libdir/pkgconfig/%libxfce4panel_name_gtk2.pc
%_libdir/%libxfce4panel_name_gtk2.so
%_includedir/xfce4/%libxfce4panel_name_gtk2/

%files -n libxfce4panel-devel-doc
%doc %_datadir/gtk-doc/html/libxfce4panel-*/

%files -n libxfce4panel-gtk3
%_libdir/%libxfce4panel_name_gtk3.so.*
%_libdir/xfce4/panel/%wrapper_name_gtk3

%files -n libxfce4panel-gtk3-devel
%_libdir/pkgconfig/%libxfce4panel_name_gtk3.pc
%_libdir/%libxfce4panel_name_gtk3.so
%_includedir/xfce4/%libxfce4panel_name_gtk3/

%if_enabled introspection
%files -n libxfce4panel-gtk3-gir
%_libdir/girepository-1.0/*.typelib

%files -n libxfce4panel-gtk3-gir-devel
%_datadir/gir-1.0/*.gir
%endif

%if_enabled vala
%files -n libxfce4panel-gtk3-vala
%_datadir/vala/vapi/libxfce4panel-*
%endif

%changelog
