%define _unpackaged_files_terminate_build 1

Name: xpdf
Version: 4.03
Release: alt1

Summary: The PDF viewer and tools
License: GPLv2 or GPLv3
Group: Office
Packager: Andrew Savchenko <bircoph@altlinux.org>

URL: https://www.xpdfreader.com
# https://xpdfreader-dl.s3.amazonaws.com/%name-%version.tar.gz
Source0: xpdf-%version.tar
Source1: xpdf.desktop

Source2: xpdf-arabic.tar
Source3: xpdf-chinese-simplified.tar
Source4: xpdf-chinese-traditional.tar
Source5: xpdf-cyrillic.tar
Source6: xpdf-greek.tar
Source7: xpdf-hebrew.tar
Source8: xpdf-japanese.tar
Source9: xpdf-korean.tar
Source10: xpdf-latin2.tar
Source11: xpdf-thai.tar
Source12: xpdf-turkish.tar

# Gentoo patches
Patch1: xpdf-automagic.patch
Patch2: xpdf-visibility.patch
Patch3: xpdf-shared-libs.patch

BuildRequires(pre): rpm-macros-cmake
BuildRequires: gcc-c++ cmake
BuildRequires: libcups-devel qt5-base-devel libpaper-devel libpng-devel
BuildRequires: libfreetype-devel fontconfig-devel zlib-devel
BuildRequires: desktop-file-utils librsvg-utils

# xpdf is a virtual package with is a full setup of xpdf
Requires: %name-viewer = %EVR %name-utils = %EVR
Requires: %name-i18n = %EVR %name-desktop = %EVR

%define desc \
The Xpdf open source project includes a PDF viewer along with a \
collection of command line tools which perform various functions on \
PDF files.

%description
%desc

%package common
Summary: The PDF viewer and tools --- common files
Group: Office
BuildArch: noarch
Requires: fonts-type1-urw

%description common
%desc

This package contains common files (config and common documentation)
needed by the other xpdf packages.

%package viewer
Summary: The PDF viewer and tools --- the PDF viewer
Group: Office
Requires: %name-common = %EVR qt5-svg
Obsoletes: xpdf-reader

%description viewer
%desc

This package contains xpdf itself, a PDF viewer for X11. xpdf is designed to
be small and efficient. xpdf supports encrypted PDF files. Standard X fonts,
Truetype fonts and Type 1 fonts are supported.

%package utils
Summary: The PDF viewer and tools --- the PDF utils
Group: Office
Requires: %name-common = %EVR

%description utils
%desc

This package contains various xpdf tools to process and convert PDF
files.

%package i18n
Summary: The PDF viewer and tools --- i18n encoding maps
Group: Office
BuildArch: noarch
Obsoletes: xpdf-chinese-simplified xpdf-chinese-traditional xpdf-japanese xpdf-korean
License: (GPLv2 or GPLv3) and BSD

%description i18n
%desc

This package provides encoding maps required to support non-UTF-8
national fonts for various languages: arabic, chinese-simplified,
chinese-traditional, cyrillic, greek, hebrew, japanes, korean,
latin2, thai, turkish.

%package desktop
Summary: The PDF viewer and tools --- desktop files
Group: Office
BuildArch: noarch
Requires: %name-viewer = %EVR

%description desktop
%desc

This package contains desktop integration files for the XPDF
viewer.

%prep
%setup -a2 -a3 -a4 -a5 -a6 -a7 -a8 -a9 -a10 -a11 -a12
%patch1 -p1
%patch2 -p1
%patch3 -p1

sed -i \
    "s|/usr/local/etc|%_sysconfdir|;
     s|/usr/local|%_prefix|;
     s|^#fontFile|fontFile|;
     s|/ghostscript/fonts|/type1/urw|;
     s|^#textEncoding|textEncoding|;
     s|^#enableFreeType|enableFreeType|;
     s|^#antialias|antialias|;
     " \
    doc/sample-xpdfrc

sed -i "s|/usr/local|%_prefix|" */add-to-xpdfrc

%build
mycmakeargs=(
    -DBUILD_SHARED_LIBS=ON
    -DCMAKE_SKIP_RPATH=OFF
    -DCMAKE_SKIP_INSTALL_RPATH=OFF
    -DA4_PAPER=ON
    -DNO_FONTCONFIG=OFF
    -DNO_TEXT_SELECT=ON
    -DOPI_SUPPORT=ON
    -DSPLASH_CMYK=ON
    -DWITH_LIBPAPER=ON
    -DWITH_LIBPNG=ON
    -DXPDFWIDGET_PRINTING=ON
    -DSYSTEM_XPDFRC="%_sysconfdir/xpdfrc"
)
%cmake "${mycmakeargs[@]}"

%cmake_build VERBOSE=1

# xpdf upstream provides only svg icon, so generate png icons
sizes="16 22 24 32 36 48 64 72 96 128 192 256 384 512 1024"
cd xpdf-qt
mkdir $sizes
for i in $sizes; do
    rsvg-convert xpdf-icon.svg -w $i -h $i -o $i/xpdf.png
done

%install
%cmakeinstall_std

desktop-file-install --dir %buildroot%_desktopdir %{SOURCE1}

# install icons
sizes="16 22 24 32 36 48 64 72 96 128 192 256 384 512 1024"
mkdir -p %buildroot%_iconsdir/hicolor/scalable/apps
cp xpdf-qt/xpdf-icon.svg %buildroot%_iconsdir/hicolor/scalable/apps/
for s in $sizes; do
	mkdir -p %buildroot%_iconsdir/hicolor/${s}x${s}/apps
	cp xpdf-qt/$s/xpdf.png %buildroot%_iconsdir/hicolor/${s}x${s}/apps/
done

mkdir -p %buildroot%_sysconfdir
cp doc/sample-xpdfrc %buildroot%_sysconfdir/xpdfrc

# rename pdf* -> xpdf* to avoid file collisions
for d in "bin" "share/man/man1"; do
	pushd "%buildroot%_prefix/${d}"
	for i in pdf*; do
		mv "${i}" "x${i}"
	done
	popd
done

# install i18n files and update xpdfrc
for i in arabic chinese-simplified chinese-traditional cyrillic greek \
		 hebrew japanese korean latin2 thai turkish; do
	mkdir -p "%buildroot%_datadir/xpdf/${i}"
	cp -a -t "%buildroot%_datadir/xpdf/${i}" \
		$(find -O3 "xpdf-${i}" -maxdepth 1 -mindepth 1 \
			! -name README ! -name add-to-xpdfrc)

	cat "xpdf-${i}/add-to-xpdfrc" >> "%buildroot%_sysconfdir/xpdfrc"
done

%files

%files common
%doc ANNOUNCE CHANGES README
%config(noreplace) %_sysconfdir/xpdfrc
%_man5dir/*

%files viewer
%_bindir/xpdf
%_man1dir/xpdf.1*

%files utils
%exclude %_bindir/xpdf
%_bindir/xpdf*
%exclude %_man1dir/xpdf.1*
%_man1dir/xpdf*
%_libdir/xpdf/*.so

%files i18n
%_datadir/xpdf/*

%files desktop
%_desktopdir/*
%_iconsdir/hicolor/*/apps/*

%changelog
