Group: Toys
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/perl
# END SourceDeps(oneline)
%define fedora 29
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary:	Render a planetary image into an X window
Name:		xplanet
Version:	1.3.1
Release:	alt1_10.1

License:	GPLv2+
Source:		http://downloads.sourceforge.net/%{name}/%{name}-%{version}.tar.gz
Patch0:		https://gitweb.gentoo.org/repo/gentoo.git/plain/x11-misc/xplanet/files/xplanet-1.3.1-giflib.patch
URL:		http://%{name}.sourceforge.net

BuildRequires:	gcc-c++
BuildRequires:	libexpat-devel
BuildRequires:	glib2-devel libgio libgio-devel
BuildRequires:	libXScrnSaver-devel
BuildRequires:	libXt-devel
BuildRequires:	libjpeg-devel
BuildRequires:	libgif-devel
BuildRequires:	libtiff-devel libtiffxx-devel
BuildRequires:	libnetpbm-devel
BuildRequires:	libpango-devel libpango-gir-devel
Requires:	fonts-ttf-gnu-freefont-mono
Source44: import.info

%description
Xplanet is similar to Xearth, where an image of the earth is rendered
into an X window.  Azimuthal, Mercator, Mollweide, orthographic, or
rectangular projections can be displayed as well as a window with a
globe the user can rotate interactively.  The other terrestrial
planets may also be displayed. The Xplanet home page has links to
locations with map files.


%prep
%setup -q
%patch0 -p1 -b .gif

%if 0%{?fedora} >= 24
LANG=C grep -rl "inFile\.getline" . | \
	xargs sed -i.c++11 \
		-e '\@inFile\.getline@s|\(inFile\.getline[ \t]*\)\((.*)\)[ \t]*!= NULL|static_cast<bool> (\1\2)|' \
		-e '\@inFile\.getline@s|\(inFile\.getline[ \t]*\)\((.*)\)[ \t]*== NULL|(!(static_cast<bool> (\1\2)))|'
%endif

%build
%add_optflags -I%_includedir/netpbm
%configure --with-pnm
%make_build -k

%install
CPPROG="cp -p" make DESTDIR=%{buildroot} install

ln -sf ../fonts/ttf/gnu-free/FreeMonoBold.ttf \
	%{buildroot}%{_datadir}/%{name}/FreeMonoBold.ttf

%files
%doc AUTHORS ChangeLog NEWS README TODO
%doc --no-dereference COPYING
%{_bindir}/*
%{_mandir}/man1/*
%{_datadir}/xplanet

%changelog
