Name: zerofree
Version: 1.0.3
Release: alt1

Summary: Utility to force unused ext2 inodes and blocks to zero
License: GPLv2
Group: File tools

Url: http://intgat.tigress.co.uk/rmy/uml/
Source0: %url/%name-%version.tgz
Source1: %url/sparsify.c
Source2: %url/index.html
Source3: zerofree.sgml
Packager: Michael Shigorin <mike@altlinux.org>

BuildRequires: libe2fs-devel
BuildRequires: docbook-to-man OpenSP docbook-dtds

%description
zerofree is a utility to set unused filesystem inodes and blocks of an
ext2 filesystem to zero.  This can improve the compressibility and
privacy of an ext2 filesystem.

This tool was inspired by the ext2fs privacy (i.e. secure deletion)
patch described in a Linux kernel mailing list thread.

This package also includes the sparsify utility which will scan all
files in an ext2 filesystem and ensure that they are maximally sparse.

See http://intgat.tigress.co.uk/rmy/uml/index.html for more info.

WARNING: The filesystem to be processed should be unmounted or mounted
read-only.  The tool tries to check this before running, but you
should be careful.

%prep
%setup
cp -p %SOURCE1 .
cp -p %SOURCE2 .

%build
export CFLAGS="%optflags"
make
gcc %optflags -o sparsify sparsify.c -lext2fs
docbook-to-man %SOURCE3 > zerofree.8

%install
install -pDm0755 zerofree %buildroot%_sbindir/zerofree
install -pDm0755 sparsify %buildroot%_sbindir/sparsify
install -Dm644 zerofree.8 %buildroot%_man8dir/zerofree.8

%files
%doc index.html
%_sbindir/zerofree
%_sbindir/sparsify
%_man8dir/zerofree.8*

%changelog
