%define _unpackaged_files_terminate_build 1

%define pkgname	dirsrv
%define groupname %pkgname.target
%define _libexecdir %_usr/libexec

%def_without selinux
%def_with check
%def_without debug
%def_with cockpit

%if_with cockpit
%define cockpit_version 247
%endif

%define get_dep_ge() %(rpm -q --qf '%%{NAME} >= %%{EVR}' %1 2>/dev/null || echo '%1 >= unknown')

Name: 389-ds-base
Version: 2.2.10
Release: alt2.p10.1

Summary: 389 Directory Server (base)
License: GPLv3+
Group: System/Servers
Url: https://www.port389.org/
VCS: https://github.com/389ds/389-ds-base

Source0: %name-%version.tar
%if_with cockpit
Source1: vendor_nodejs.tar
%endif
Source2: vendor_rust.tar
Patch: %name-%version-alt.patch

ExcludeArch: %ix86

# python deps
BuildRequires(pre): rpm-build-python3
# build backend and its deps
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)

BuildRequires: cracklib-devel
BuildRequires: doxygen
BuildRequires: gcc-c++
%if_with debug
BuildRequires: libasan5
%endif
BuildRequires: libdb5.3-devel
BuildRequires: liblmdb-devel
BuildRequires: libevent-devel
BuildRequires: libicu-devel
BuildRequires: libkrb5-devel
BuildRequires: libldap-devel
BuildRequires: libnet-snmp-devel
BuildRequires: libnspr-devel
BuildRequires: libnss-devel
BuildRequires: libpam0-devel
BuildRequires: libpcre2-devel
BuildRequires: libsasl2-devel
BuildRequires: libsystemd-devel
# log compression
BuildRequires: zlib-devel
# audit logs
BuildRequires: libjson-c-devel

BuildRequires: python3(build_manpages)
BuildRequires: python3(argcomplete)
BuildRequires: python3(dateutil)
BuildRequires: python3(ldap)
BuildRequires: python3-module-cryptography

BuildRequires: rsync

%if_with cockpit
BuildRequires: npm
# https://bugzilla.altlinux.org/47191
BuildRequires: node
%endif

%if_with check
BuildRequires: /proc
BuildRequires: libcmocka-devel
%endif

# rust deps
BuildRequires: /proc
BuildRequires: rust
BuildRequires: rust-cargo

%add_findprov_skiplist %_datadir/%pkgname/script-templates/*
%add_findreq_skiplist %_datadir/%pkgname/script-templates/* %_sbindir/*-%pkgname

# still packaged Perl script, which requires perl-devel
# Perl is linked against libdb4.8 for now, but 389-ds requires 5.3
%add_findprov_skiplist %_bindir/logconv.pl
%add_findreq_skiplist %_bindir/logconv.pl

# use Python3 everywhere
%add_python3_path %_datadir/gdb/auto-load/
%add_python3_compile_exclude %_datadir/gdb/auto-load/

%add_python3_path %_libdir/%pkgname/python/
%add_python3_compile_exclude %_libdir/%pkgname/python/

# we don't want python gdb
%filter_from_requires /python3(gdb\(\..*\)\?)/d
# requires self
%add_python3_req_skip __main__

# shell.req wrongly marks restorecon as a dep
%add_findreq_skiplist %_libexecdir/%pkgname/ds_selinux_restorecon.sh

%ifarch armh
# combo of rustix, glibc < 2.34 and 32bit arch make __clock_gettime64
# GLIBC_PRIVATE
%filter_from_requires /^libc.so.6(GLIBC_PRIVATE)/d
%endif

Requires: libjemalloc2
Requires: cracklib-words

%description
389 Directory Server is an LDAPv3 compliant server. The base package includes
the LDAP server and command line utilities for server administration.

%package libs
Summary: Core libraries for 389 Directory Server
Group: System/Libraries
# svrcore has been merged into 389-ds
# https://pagure.io/389-ds-base/issue/49369
Provides: libsvrcore = 4.1.4
Obsoletes: libsvrcore <= 4.1.3
Conflicts: libsvrcore

%description libs
Core libraries for the 389 Directory Server base package. These libraries are
used by the main package and the -devel package. This allows the -devel package
to be installed with just the -libs package and without the main package.

%package devel
Summary: Development libraries for 389 Directory Server
Group: Development/C
Requires: %name = %EVR
# svrcore has been merged into 389-ds
# https://pagure.io/389-ds-base/issue/49369
Provides: libsvrcore-devel = 4.1.4
Obsoletes: libsvrcore-devel <= 4.1.3
Conflicts: libsvrcore-devel

%description devel
Development Libraries and headers for 389 Directory Server.

%package -n python3-module-lib389
Summary: A library for accessing, testing, and configuring the 389 Directory Server
BuildArch: noarch
Group: Development/Python3
Requires: nss-utils
Requires: %get_dep_ge libnss

%description -n python3-module-lib389
This module contains tools and libraries for accessing, testing, and
configuring the 389 Directory Server.

%if_with cockpit
%package -n cockpit-389-ds
Summary: Cockpit UI Plugin for configuring and administering the 389 Directory Server
BuildArch: noarch
Group: System/Base

Requires: cockpit-bridge >= %cockpit_version
Requires: cockpit-shell >= %cockpit_version
Requires: cockpit-systemd >= %cockpit_version
Requires: cockpit-ws >= %cockpit_version
%py3_requires lib389

Obsoletes: 389-console
Obsoletes: 389-adminutil
Obsoletes: 389-ds-console
Obsoletes: 389-dsgw

%description -n cockpit-389-ds
A cockpit UI Plugin for configuring and administering the 389 Directory Server
%endif

%prep
%setup %{?_with_cockpit:-a1} -a2
%patch -p1

grep -qsF 'sysctldir = @prefixdir@/lib/sysctl.d' Makefile.am || exit 1
sed -i 's|sysctldir = .*|sysctldir = %_sysctldir|' Makefile.am

grep -qsr 'LD_PRELOAD=.*/libjemalloc.so.2' || exit 1
grep -rl 'LD_PRELOAD=.*/libjemalloc.so.2' | \
xargs sed -i 's|LD_PRELOAD=.*/libjemalloc.so.2|LD_PRELOAD=libjemalloc.so.2|g'

grep -qsr '/sasl2\( \|"\)' || exit 1
grep -rl '/sasl2\( \|"\)' | xargs sed -i 's/\/sasl2\( \|"\)/\/sasl2-3\1/g'

grep -qsr '/usr/bin/\(ls\|echo\)' || exit 1
grep -rl '/usr/bin/\(ls\|echo\)' | \
xargs sed -i 's/\/usr\(\/bin\/\(ls\|echo\)\)/\1/g'

grep -qs 'saslpath = "/usr/lib/aarch64-linux-gnu"' \
ldap/servers/slapd/ldaputil.c || exit 1
sed -i 's|\(saslpath = "/usr/\)lib\(/aarch64-linux-gnu"\)|\1lib64\2|g' \
ldap/servers/slapd/ldaputil.c

%build
%ifarch mipsel
export LDFLAGS='-latomic'
%endif
%ifarch %e2k
# 1.4.1.8: asm crc32
%add_optflags -U__SSE4_2__
%endif

# replace hardcoded version = "1.4.0.1",
# https://github.com/389ds/389-ds-base/issues/5203
sed -i 's/^version[[:space:]]*=.*$/version = "%version"/' src/lib389/setup.py

%autoreconf

%configure  \
        %{subst_with selinux} \
	--localstatedir=/var \
        --libexecdir=%_libexecdir/%pkgname \
	--with-systemd \
	--with-systemdsystemunitdir=%_unitdir \
	--with-systemdsystemconfdir=%_sysconfdir/systemd/system \
	--with-systemdgroupname=%groupname \
        --with-tmpfiles-d=%_sysconfdir/tmpfiles.d \
%if_with debug
        --enable-asan \
        --enable-debug \
%endif
        %{?_with_check:--enable-cmocka } \
        %{?_without_cockpit:--disable-cockpit } \
        --enable-rust-offline \
        --with-libldap-r=no \
        %nil

%make_build

%if_with cockpit
# cockpit plugin
SKIP_AUDIT_CI=yes NODE_ENV=production %make 389-console
%endif

# Python3 bindings
pushd ./src/lib389
%pyproject_build
popd

# argparse-manpage dynamic man pages have hardcoded man v1 in header,
# need to change it to v8
sed -i  "1s/\"1\"/\"8\"/" ./src/lib389/man/ds{conf,ctl,idm,create}.8

%check
%make VERBOSE=1 check

%install
%makeinstall_std

# python stuff
pushd src/lib389
%pyproject_install
popd

# doesn't support PEP517
# upstream ticket: TBD
chmod +x %buildroot%python3_sitelibdir_noarch/%_sbindir/*
chmod +x %buildroot%python3_sitelibdir_noarch/%_libexecdir/%pkgname/*

for d in %_sbindir %_man8dir %_libexecdir; do
    mkdir -p %buildroot/$d
    cp -a %buildroot%python3_sitelibdir_noarch/$d/* -t %buildroot/$d/
done
rm -r %buildroot%python3_sitelibdir_noarch/%_usr

mkdir -p %buildroot/{%_lockdir,%_localstatedir,%_logdir}/%pkgname

# for systemd
mkdir -p %buildroot%_sysconfdir/systemd/system/%groupname.wants

# remove libtool and static libs
find %buildroot -type f \( -name "*.la" -o -name "*.a" \) -delete

# move main libraries to common directory
mv %buildroot%_libdir/%pkgname/*.so* %buildroot%_libdir/

# Copy in our docs from doxygen
mkdir -p %buildroot%_man3dir
cp man/man3/* %buildroot%_man3dir

%if_without cockpit
# ends up unpackaged otherwise thus breaking build
rm -f %buildroot%_datadir/metainfo/389-console/org.port389.cockpit_console.metainfo.xml
%endif

%pre
%define _dirsrv_user dirsrv
%define _dirsrv_group dirsrv
%define _dirsrv_home %_localstatedir/dirsrv
/usr/sbin/groupadd -r -f %_dirsrv_group ||:
/usr/sbin/useradd -g %_dirsrv_group -c 'user for 389-ds-base' \
		  -d %_dirsrv_home -s /sbin/nologin -r %_dirsrv_user \
		  > /dev/null 2>&1 ||:

%post
sysctl --system &> /dev/null ||:

%preun
# Removal
if [ $1 -eq 0 ]; then
    # disabling all templated units
    /bin/systemctl -q disable %pkgname@
    # remove templated units
    rm -rf %_sysconfdir/systemd/system/%groupname.wants/* >/dev/null 2>&1 ||:
    # stopping by mask
    /bin/systemctl stop %pkgname@*.service
fi
%preun_service %pkgname-snmp

%files
%doc README.md
%dir %_sysconfdir/%pkgname
%dir %_sysconfdir/%pkgname/schema
%config(noreplace)%_sysconfdir/%pkgname/schema/*.ldif
%dir %_sysconfdir/%pkgname/config
%dir %_sysconfdir/systemd/system/%groupname.wants
%config(noreplace)%_sysconfdir/%pkgname/config/slapd-collations.conf
%config(noreplace)%_sysconfdir/%pkgname/config/certmap.conf
%config(noreplace)%_sysconfdir/%pkgname/config/ldap-agent.conf
%dir %_datadir/%pkgname
%_datadir/%pkgname/data/
%_datadir/%pkgname/inf/
%_datadir/%pkgname/mibs/
%_datadir/%pkgname/schema/
%_unitdir/dirsrv-snmp.service
%_unitdir/dirsrv.target
%_unitdir/dirsrv@.service
%dir %_unitdir/dirsrv@.service.d
%_unitdir/dirsrv@.service.d/custom.conf

%_bindir/dbscan
%_bindir/ds-replcheck
%_bindir/ds-logpipe.py
%_bindir/ldclt
%_bindir/logconv.pl
%_bindir/pwdhash

%_sbindir/ldap-agent
%_sbindir/ns-slapd
%_sbindir/openldap_to_ds

%dir %_libexecdir/%pkgname
%_libexecdir/%pkgname/ds_systemd_ask_password_acl
%_libexecdir/%pkgname/ds_selinux_restorecon.sh
%dir %_libdir/%pkgname/python
%_libdir/%pkgname/python/*.py*
%dir %_libdir/%pkgname/plugins
%_libdir/%pkgname/plugins/*.so
%_datadir/gdb/auto-load/*
%_sysctldir/70-dirsrv.conf
%dir %_localstatedir/%pkgname
%dir %_logdir/%pkgname
%ghost %dir %_lockdir/%pkgname
%_man1dir/dbscan.1.*
%_man1dir/ds-replcheck.1.*
%_man1dir/ds-logpipe.py.1.*
%_man1dir/ldclt.1.*
%_man1dir/logconv.pl.1.*
%_man1dir/pwdhash.1.*
%_man1dir/ldap-agent.1.*
%_man8dir/ns-slapd.8.*
%_man5dir/99user.ldif.5.*
%_man5dir/certmap.conf.5.*
%_man5dir/slapd-collations.conf.5.*
%_man5dir/dirsrv.5.*
%_man5dir/dirsrv.systemd.5.*
%_man8dir/openldap_to_ds.8.*

%files devel
%_includedir/%pkgname/
%_includedir/svrcore.h
%_libdir/libsvrcore.so
%_libdir/libslapd.so
%_libdir/libns-dshttpd.so
%_libdir/libldaputil.so
%_libdir/librewriters.so
%_pkgconfigdir/dirsrv.pc
%_pkgconfigdir/svrcore.pc
%_man3dir/*.3.*

%files libs
%dir %_libdir/%pkgname
%_libdir/libsvrcore.so.*
%_libdir/libns-dshttpd.so.*
%_libdir/libslapd.so.*
%_libdir/libldaputil.so.*
%_libdir/librewriters.so.*

%files -n python3-module-lib389
%_sbindir/dsconf
%_sbindir/dscreate
%_sbindir/dsctl
%_sbindir/dsidm
%_libexecdir/%pkgname/dscontainer
%_man8dir/dsconf.8.*
%_man8dir/dscreate.8.*
%_man8dir/dsctl.8.*
%_man8dir/dsidm.8.*
%python3_sitelibdir_noarch/lib389/
%python3_sitelibdir_noarch/lib389-%version.dist-info/

%if_with cockpit
%files -n cockpit-389-ds
%dir %_datadir/metainfo/389-console
%_datadir/metainfo/389-console/org.port389.cockpit_console.metainfo.xml
%dir %_datadir/cockpit/389-console
%_datadir/cockpit/389-console/manifest.json
%_datadir/cockpit/389-console/*.html.gz
%_datadir/cockpit/389-console/*.js.gz
%_datadir/cockpit/389-console/*.css.gz
%exclude %_datadir/cockpit/389-console/index.js.LICENSE.txt.gz
%endif

%changelog
