%def_without dbus
%define origver 2020.3.17

Name: FlightGear
Version: %origver
Release: alt1

Summary: open-source flight simulator
License: GPLv2+
Group: Games/Arcade

Url: http://www.flightgear.org
# Source0-url: https://sourceforge.net/projects/flightgear/files/release-%origver/flightgear-%version.tar.bz2
Source0: %name-%version.tar
Source2: FlightGear.menu
Source3: FlightGear-22x22.xpm
Source4: FlightGear-32x32.xpm
Source5: FlightGear-48x48.xpm
Source10: fg-16.png
Source11: fg-32.png
Source12: fg-48.png
Source13: fg-64.png
Source14: fg-128.png
Source15: FlightGear.desktop
Patch1: 0001-check-to-be-sure-that-n-is-not-being-set-as-format-t.patch
Patch2: 0002-make-ShivaVG-and-FGAdminUI-static-libraries.patch
Patch5: 0005-explicitely-link-with-libX11.patch
Patch6: 0006-make-fglauncher-a-static-library.patch

Requires: FlightGear-data = %version
#Requires: fgrun >= 1.6.1

BuildRequires: libsimgear-devel = %version
BuildRequires: libOpenSceneGraph-devel >= 3.4.0
BuildRequires: boost-devel >= 1.44
BuildRequires: plib-devel >= 1.8.5

# TODO: fltk??
BuildRequires: rpm-macros-cmake cmake gcc-c++ imake libalut-devel libfltk-devel libfreeglut-devel libjpeg-devel libpng-devel

BuildRequires: libpng-devel libfltk-devel libudev-devel
BuildRequires: libXres-devel libXi-devel libXmu-devel
BuildRequires: libXtst-devel libXcomposite-devel libXcursor-devel
BuildRequires: libXdamage-devel libXdmcp-devel libXfixes-devel
BuildRequires: libXft-devel libXinerama-devel libxkbfile-devel
BuildRequires: libXpm-devel libXrandr-devel libXrender-devel
BuildRequires: libXScrnSaver-devel libXv-devel libXxf86misc-devel
BuildRequires: libXxf86vm-devel libXxf86vm-devel libapr1-devel
BuildRequires: liblzma-devel

%if_with dbus
# disables screensaver; requires running messagebus service
BuildRequires: libdbus-devel
Requires: dbus
%endif

%ifarch %e2k
# had to disable in OpenSceneGraph => unmets followed up
%global __find_debuginfo_files %nil
%endif

%description
FlightGear is a free, open-source, multi-platform, and sophisticated
flight simulator framework for the development and pursuit
of interesting flight simulator ideas.

This package contains the engine; see also fgrun or fgo to start
FlightGear conveniently.

You will also need some experience and probably a tutorial:
http://ericbrasseur.org/flight_simulator_tutorial.html

%prep
%setup
%patch1 -p1
#patch2 -p1
#patch5 -p1
%patch6 -p1

sed -i 's/\r//' docs-mini/AptNavFAQ.FlightGear.html
for ext in Cygwin IRIX Joystick Linux MSVC MSVC8 MacOS SimGear Unix \
	Win32-X autoconf mingw plib src xmlsyntax; do
	rm -f docs-mini/README.$ext
done
for f in docs-mini/README.xmlparticles Thanks; do
	iconv -f iso-8859-1 -t utf-8 -o ${f}.utf8 ${f}
	mv -f ${f}.utf8 ${f}
done

# argh
sed -i 's,/lib/FlightGear,/share/flightgear,' CMakeLists.txt

# TODO: link with external sqlite3?
%ifarch %e2k
# unsupported as of lcc-1.23.21
sed -i 's,-fno-fast-math,,' 3rdparty/sqlite3/CMakeLists.txt
%endif

# rename version file to flightgear_version because it's incorrectly detected as header file
# by boost-1.73.0, and compilation fails when it's being incorrectly used as header file
mv version flightgear_version

%build
# FIXME: tests got linking problems with lcc 1.23.20, cf. mcst#3675?
%cmake \
%ifarch %e2k
	-DENABLE_TESTS:BOOL=OFF \
%endif
	%nil
%cmake_build

%install
%cmakeinstall_std

rm -rf %buildroot%_datadir/locale
rm -rf %buildroot%_datadir/bash-completion/ %buildroot%_datadir/zsh/

%files
%_bindir/*
%_mandir/*/*
%_iconsdir/*/*/*/flightgear.*
%_desktopdir/org.flightgear.FlightGear.desktop
%_datadir/metainfo/*.xml

%changelog
