# 7.4.2.3
%def_without python
%def_with parallelism
%def_without fetch
%def_enable lto
%def_enable dconf

# enable kde5 UI
%def_enable kf5

%ifarch mipsel
%def_without java
%else
%def_with java
%endif
%if_enabled kf5
%def_enable qt5
%else
%def_disable qt5
%endif
%def_disable mergelibs

Name: LibreOffice
%define hversion 7.4
%define urelease 2.3
Version: %hversion.%urelease
%define uversion %version.%urelease
%define lodir %_libdir/%name
%define uname libreoffice
%define conffile %_sysconfdir/sysconfig/%uname
Release: alt4
Summary: LibreOffice Productivity Suite
License: MPL-2.0
Group: Office
URL: http://www.libreoffice.org

Requires: %name-integrated = %EVR
Requires: %name-common = %EVR
Requires: %name-extensions = %EVR
%if_with java
Requires: libreoffice-languagetool
%endif

Provides: %name-full = %EVR
Provides: libreoffice = %EVR
Obsoletes: libreoffice < 3.99
Obsoletes: %name-full < %EVR

%define with_lang en-US ru be de fr uk pt-BR es kk tt
Requires: gst-libav

Source:         libreoffice-%version.tar.xz
Source1:        libreoffice-dictionaries-%version.tar.xz
Source2:        libreoffice-help-%version.tar.xz
Source3:        libreoffice-translations-%version.tar.xz

Source10:       libreoffice-ext_sources.%version.tar
Source100:      forky.c
Source200:      key.gpg
Source300:      libreoffice.unused

## FC patches
Patch1: FC-0001-don-t-suppress-crashes.patch
Patch2: FC-0001-disble-tip-of-the-day-dialog-by-default.patch
Patch3: FC-0001-Resolves-rhbz-1432468-disable-opencl-by-default.patch
Patch4: FC-0001-Revert-tdf-101630-gdrive-support-w-oAuth-and-Drive-A.patch
Patch5: FC-0001-disable-libe-book-support.patch

## Long-term FC patches

## ALT patches
Patch401: alt-001-MOZILLA_CERTIFICATE_FOLDER.patch
Patch402: alt-002-tmpdir.patch
#Patch403: alt-003-skia-freetype-2.11.patch
Patch404: alt-004-shortint.patch
Patch405: alt-005-svg-icons-1.patch
Patch406: alt-006-svg-icons-2.patch
Patch407: alt-007-svg-icons-3.patch

Patch500: alt-010-mips-fix-linking-with-libatomic.patch

# content of patch shared to Weblate-LibreOffice by @NeuroFreak
Patch600: LibreOffice-7.4.2.3-update-russian-translation.patch

%set_verify_elf_method unresolved=relaxed
%add_findreq_skiplist %lodir/share/config/webcast/*
%add_findreq_skiplist %lodir/sdk/examples/python/toolpanel/toolpanel.py 
%add_findreq_skiplist %lodir/sdk/classes
%add_findreq_skiplist %lodir/sdk/docs
%add_findreq_skiplist %lodir/sdk/idl
%add_findreq_skiplist %lodir/sdk/include
%filter_from_requires /com[.]sun[.]/d
%add_python3_req_skip pyuno strings

# Automatically added by buildreq on Wed Feb 13 2019
# optimized out: ant-lib apache-commons-logging at-spi2-atk bash4 boost-devel boost-devel-headers cppunit dconf fontconfig fontconfig-devel gcc-c++ glib-networking glib2-devel glibc-kernheaders-generic glibc-kernheaders-x86 gobject-introspection gobject-introspection-devel gstreamer1.0-devel hamcrest-core icu-utils java java-headless javapackages-tools javazi kf5-kconfig-devel kf5-kcoreaddons-devel libGL-devel libICE-devel libSM-devel libX11-devel libXext-devel libXinerama-devel libXrandr-devel libXrender-devel libXt-devel libat-spi2-core libatk-devel libatk-gir-devel libboost_numpy3-1.67.0 libboost_python3-1.67.0 libcairo-devel libcairo-gobject libcairo-gobject-devel libclucene-contribs-lib libclucene-core libclucene-shared libcrypt-devel libcurl-devel libe-book libfreetype-devel libgdk-pixbuf libgdk-pixbuf-devel libgdk-pixbuf-gir-devel libgio-devel libglvnd-devel libgpg-error libgpg-error-devel libgraphite2-devel libgst-plugins1.0 libgtk+3-devel libharfbuzz-devel libharfbuzz-icu libicu-devel libltdl7-devel libnspr-devel libnss-devel libpango-devel libpango-gir-devel libpng-devel libpoppler-devel libpq-devel libqt5-core libqt5-gui libqt5-network libqt5-widgets libqt5-x11extras librasqal-devel librevenge-devel libsasl2-3 libstdc++-devel libwayland-client libwayland-client-devel libwayland-cursor libwayland-egl libxcb-devel libxml2-devel libxmlsec1-devel libxmlsec1-nss libxslt-devel pentaho-libxml perl pkg-config python-base python-modules python-modules-compiler python-modules-distutils python3 python3-base python3-module-lxml qt5-base-devel raptor2-devel sac sh4 termutils wayland-devel xml-common xml-utils xorg-proto-devel xz zlib-devel
BuildRequires: boost-filesystem-devel boost-locale-devel boost-signals-devel cppunit-devel doxygen flex fontforge fonts-ttf-liberation git-core gperf graphviz gst-plugins1.0-devel imake libGConf libabw-devel libavahi-devel libbluez-devel libcdr-devel libclucene-core-devel libcmis-devel libcups-devel libdbus-devel libe-book-devel libepoxy-devel libepubgen-devel libetonyek-devel libexpat-devel libexttextcat-devel libfreehand-devel libglm-devel libgpgme-devel libgtk+2-devel libgtk+3-gir-devel libhunspell-devel libhyphen-devel libjpeg-devel liblangtag-devel liblcms2-devel libldap-devel liblpsolve-devel libmspub-devel libmwaw-devel libmysqlclient-devel libmythes-devel libneon-devel libnumbertext-devel libodfgen-devel liborcus-devel libpagemaker-devel libpoppler-cpp-devel libqxp-devel libredland-devel libsane-devel libssl-devel libstaroffice-devel libunixODBC-devel libvisio-devel libwpd10-devel libwpg-devel libwps-devel libxmlsec1-nss-devel libzmf-devel mdds-devel postgresql-devel unzip xorg-cf-files xsltproc zip

# 6.4
BuildRequires: libeot-devel libqrcodegen-cpp-devel

# 7.1
BuildRequires: libbox2d-devel

# 7.2
BuildRequires: libpixman-devel

# 7.3
BuildRequires: libcuckoo-devel libopenjpeg2.0-devel libabseil-cpp-devel

# 7.4
BuildRequires: libwebp-devel libtiff-devel

%if_with java
BuildRequires: java-devel >= 9.0.0 junit ant bsh pentaho-reporting-flow-engine 
%endif

%if_enabled qt5
BuildRequires: qt5-base-devel qt5-svg-devel qt5-x11extras-devel 
BuildRequires: libxcbutil-icccm-devel
BuildRequires: libpixman-devel
%endif

%if_enabled kf5
BuildRequires: kf5-ki18n-devel kf5-kio-devel kf5-kwindowsystem-devel
%endif

%if_without python
BuildRequires: python3-dev
%endif

%if_enabled dconf
BuildRequires: libdconf-devel
%endif

%description
LibreOffice is a productivity suite that is compatible with other major
office suites.

This package provides maximum possible installation of %name along winth
other office packages, except of language packs and GNOME/KDE bindings.

%package common
Summary: Basic installation of %name
Group: Office
AutoReqProv: yes, noshell, nopython
%description common
Common part of %name that does not interfere with other packages

%package integrated
Summary: Binaries, icons and desktop files for %name
Group: Office
Provides: %uname = %EVR
Requires: %name-common = %EVR
%if_with java
Requires: pentaho-reporting-flow-engine
%endif
Provides: %name-mimetypes
%description integrated
Wrapper scripts, icons and desktop files for running %name

%package gtk3
Summary: GTK3 Extensions for %name
Group:  Office
Requires: %uname = %EVR
Requires: %name-common = %EVR
Provides: %name-gnome = %EVR
Obsoletes: %name-gnome %name-gtk %name-gtk2
%description gtk3
GTK3 extensions for %name

%if_enabled qt5
%package qt5
Summary: Qt5 Extensions for %name
Group:  Office
Requires: %uname = %EVR
Requires: %name-common = %EVR
%description qt5
qt5 extensions for %name
%endif

%if_enabled kf5
%package kde5
Summary: KDE5 Extensions for %name
Group:  Office
Requires: %uname = %EVR
Requires: %name-common = %EVR
Provides: %name-kde = %EVR
Provides: %name-kf5 = %EVR
%description kde5
KDE5 extensions for %name

%package gtk3-kde5
Summary: GTK3 Extensions for %name with KDE5 filepicker
Group:  Office
Requires: %uname = %EVR
Requires: %name-common = %EVR
%description gtk3-kde5
GTK3 Extensions for %name with KDE5 filepicker
%endif

%package -n libreofficekit
Summary: A library providing access to LibreOffice functionality
Group: Graphical desktop/GNOME
License: MPL-2.0
%description -n libreofficekit
LibreOfficeKit can be used to access LibreOffice functionality
through C/C++, without any need to use UNO.

%package -n libreofficekit-devel
Summary: Development files for libreofficekit
Group: Development/GNOME and GTK+
License: MPL-2.0
%description -n libreofficekit-devel
The libreofficekit-devel package contains libraries and header files for
developing applications that use libreofficekit.


%package extensions
Summary: Additional extensions for %name
Group:  Office
Requires: %uname = %EVR
AutoReqProv: yes, noshell, nopython
%description extensions
Additional extensions for %name.
One can choose either to install this package at once,
or to download and install (possibly newer) extensions manually.

%package sdk
Group: Development/Other
Summary: Software Development Kit for LibreOffice

%description sdk
The SDK is a development kit for LibreOffice 5.3, which
eases the development of office components. It provides a set of
libraries, binaries, header, and IDL files which have final API's
and can only be extended with new functionality. This set of libraries
and binaries is the minimum set of functions needed to use system
abstraction for base functionality and for using UNO (Universal
Network Objects) component technology. The UNO component model is the
base of the whole Office API. The SDK provides everything necessary
to use the Office API from external programs (e.g. Java, C++) or to
extend the Office functionality with new components (e.g. new filter
components, CalcAddin functions). It is compatible over several
versions because the API remains unaffected and will only be extended
with new functions.

%package postgresql
Group:  Office
Summary: PostgrSQL connector for LibreOffice
%description postgresql
%summary

# TODO redefine %%lang adding corr langpack
# define macro for quick langpack description
%define langpack(l:n:mhs:o:v:) \
%define lang %{-l:%{-l*}}%{!-l:%{error:Language code not defined}} \
%define lng %{-s:%{-s*}}%{!-s:%{lang}} \
%define pkgname langpack-%{lang} \
%define langname %{-n:%{-n*}}%{!-n:%{error:Language name not defined}} \
\
%package %{pkgname} \
Summary: %{langname} language pack for %name \
Group:  Office \
Requires: %uname = %EVR \
%{-m:Requires: mythes-%lng} \
%{-h:Requires: hyphen-%lng} \
%{-o:Obsoletes: %{name}-langpack-%{-o*} < %{-v*}} \
%{-o:Conflicts: %{name}-langpack-%{-o*} < %{-v*}} \
%description %{pkgname} \
Provides additional %{langname} translations and resources for %name. \
\
%files %{pkgname} -f %{lang}.lang \
%{nil}

%prep
%setup -q -n libreoffice-%version -a10 -b1 -b2 -b3

## FC apply patches
#patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
#patch5 -p1

## Long-term FC patches applying

## ALT apply patches
%patch401 -p0
%patch402 -p1
%patch404 -p1
%patch405 -p1
##patch406 -p1 # Doesn't compile
%patch407 -p1

%patch500 -p0
# Patch with russian translation update
%patch600 -p1

# TODO move officebean to SDK or separate package
# Hack in -Wl,-rpath=/usr/lib/jvm/jre-11-openjdk/lib
sed -i 's@JAVA_HOME/lib/ -ljawt@JAVA_HOME/lib/ -Wl,-rpath=/usr/lib/jvm/jre/lib -ljawt@' configure.ac

# Hack out lowercasing install_dirname
sed -i 's/\(^INSTALLDIRNAME=\).*/\1AC_PACKAGE_NAME/' configure.ac
sed -i 's/\(^add_wrapper.*"\)libreoffice-/\1%name-/
s/\(gid_Module_Optional_Xsltfiltersamples.*\)libreoffice-/\1%name-/' bin/distro-install-desktop-integration

%filter_from_requires /libjawt[.]so/d

# Choose right path to kcoreaddons_version.h
if [ -e "%_includedir/KF5/KCoreAddons/kcoreaddons_version.h" ]; then  
    sed -i -e 's|kf5_test_include="KF5/kcoreaddons_version.h"|kf5_test_include="KF5/KCoreAddons/kcoreaddons_version.h"|' configure.ac
fi

# Hack in ALT pixman path
sed -i 's@ -I@ -I /usr/include/pixman-1 -I@' canvas/Library_cairocanvas.mk

# Hack in python shebang
find . -name \*.py | while read F; do
    sed -i '1i#!/usr/bin/python3
/^#!.*python/d' "$F"
done

# Hack in proper LibreOffice PATH in libreofficekit
sed -i 's@/libreoffice/@/LibreOffice/@g' libreofficekit/Library_libreofficekitgtk.mk

# Hack hardcoded lsattr path
for f in `grep -rl '/usr/sbin/lsattr' *`; do sed -i 's@/usr/sbin/lsattr@/usr/bin/lsattr@g' $f; done

# Hack in MimeType=application/vnd.ms-visio.drawing.main+xml
grep -Fq "application/vnd.ms-visio.drawing.main+xml" sysui/desktop/menus/draw.desktop || sed -i 's@MimeType=@MimeType=application/vnd.ms-visio.drawing.main+xml;@' sysui/desktop/menus/draw.desktop

# hack hardcoded libodbc version
sed -i 's/libodbc.so.1/libodbc.so.2/g' connectivity/source/drivers/odbc/OFunctions.cxx

# Hack in relative ln -s

sed -i '/program.soffice/s/ln -sf \("*\$\)/ln --relative -sf $DESTDIR\1/' sysui/desktop/share/create_tree.sh
sed -i '/share.xdg/s/ln -sf \("*\$\)/cp -va $DESTDIR\1/' sysui/desktop/share/create_tree.sh
sed -i 's/ln -sf \("*\$\)/ln --relative -sf $DESTDIR\1/' bin/distro-install-sdk
sed -i 's/ln -sf \("*\$\)/ln --relative -sf $DESTDIR\1/' bin/distro-install-desktop-integration

rm -fr %name-tnslations/git-hooks

# Now create a config file
grep -r getenv * | sed -n 's/.*getenv *( *"\([^"]*\).*/\1/p' | sort -u | grep -E 'STAR_|SAL_|OOO_' > %name.config.ENV

sed -n '/# STAR_PROFILE_LOCKING_DISABLED/,/#.*JITC_PROCESSOR_TYPE_EXPORT/p' < desktop/scripts/soffice.sh > libreoffice.config
test -n "libreoffice.config"
sed -i '/# STAR_PROFILE_LOCKING_DISABLED/i\
test -r %conffile && . %conffile ||:
/# STAR_PROFILE_LOCKING_DISABLED/,/#.*JITC_PROCESSOR_TYPE_EXPORT/d' desktop/scripts/soffice.sh

%build
grep -l GCC_VERSION configure* | while read F; do
        sed -i '/GCC_VERSION=.*AWK/s/.*/GCC_VERSION="${_gcc_version%%%%.*}"/' $F
done
%ifarch mipsel
export CFLAGS="-Os --param ggc-min-expand=20 --param ggc-min-heapsize=32768 -g1"
export CXXFLAGS="$CFLAGS"
%endif

# XXX no "thin" LTO option in GCC!
sed -i 's/-flto=thin/-flto=jobserver/g' solenv/gbuild/platform/com_GCC_defs.mk

PARALLEL=$(nproc)

%ifarch ppc64le
# reduce excessive resource use
if [ "$PARALLEL" -gt 24 ] ; then
        PARALLEL=24
fi
%endif

export ac_cv_prog_LO_CLANG_CXX=""
export ac_cv_prog_LO_CLANG_CC=""
./autogen.sh \
        --prefix=%_prefix \
        --libdir=%_libdir \
        --with-vendor="ALT Linux Team" \
        %{subst_enable lto} \
        %{subst_enable mergelibs} \
        --enable-odk \
        --disable-firebird-sdbc \
        --disable-coinmp \
        --enable-dbus \
        --enable-evolution2 \
        --enable-gio \
        --enable-build-opensymbol \
        --enable-avahi \
        %{subst_with java} \
        --without-fonts \
        --without-myspell-dicts \
        \
        --with-external-dict-dir=%_datadir/myspell \
        --with-external-hyph-dir=%_datadir/hyphen \
        --with-external-thes-dir=%_datadir/mythes \
        --with-lang="%with_lang" \
        --with-external-tar=`pwd`/ext_sources \
        \
        --enable-ext-nlpsolver \
        --enable-ext-numbertext \
        --enable-ext-wiki-publisher \
  \
        --enable-release-build \
        --with-help \
  \
        %{subst_enable kf5} \
        %{subst_enable qt5} \
        %{subst_enable dconf} \
        --enable-gtk3 \
%if_enabled kf5 \
        --enable-gtk3-kde5 \
%endif
        --enable-introspection \
        --enable-cipher-openssl-backend \
        --enable-eot \
        --enable-formula-logger \
        --disable-zxing \
  \
%if_with parallelism
        --with-parallelism="$PARALLEL" \
%else   
        --without-parallelism \
%endif
%if_with python
        --enable-python=internal \
%endif
%if_with fetch
        --enable-fetch-external
%else
        --with-system-libs \
        --without-system-poppler \
        --without-system-dragonbox \
        --without-system-libfixmath \
        --disable-fetch-external
%endif

        ## --without-system-libtiff \

# TODO  --enable-vlc --enable-zxing --with-system-dragonbox

%make bootstrap

%if_with parallelism
export _JAVA_OPTIONS="-XX:ParallelGCThreads=4 $_JAVA_OPTIONS"
%endif

%make verbose=true build

export DESTDIR=../output
export KDEMAINDIR=/usr
export GNOMEDIR=/usr
export GNOME_MIME_THEME=hicolor
export PREFIXDIR=/usr
. ./bin/get_config_variables PRODUCTVERSIONSHORT PRODUCTVERSION SRCDIR WORKDIR PKG_CONFIG INSTDIR
export PRODUCTVERSIONSHORT PRODUCTVERSION SRCDIR WORKDIR PKG_CONFIG INSTDIR
$WORKDIR/CustomTarget/sysui/share/libreoffice/create_tree.sh

%install
unset RPM_PYTHON

%make DESTDIR=%buildroot INSTALLDIR=%lodir distro-pack-install
rm -f %buildroot%lodir/sdk/config.*

# Drop compatibility symlinks
# https://bugzilla.altlinux.org/34619
rm -f %buildroot%lodir/sdk/classes
sed -i '/^\/usr\/%{_lib}\/LibreOffice\/sdk\/classes$/d' file-lists/sdk_list.txt
rm -f %buildroot%lodir/sdk/idl
sed -i '/^\/usr\/%{_lib}\/LibreOffice\/sdk\/idl$/d' file-lists/sdk_list.txt
rm -f %buildroot%lodir/sdk/docs
sed -i '/^\/usr\/%{_lib}\/LibreOffice\/sdk\/docs$/d' file-lists/sdk_doc_list.txt
rm -f %buildroot%lodir/sdk/include
sed -i '/^\/usr\/%{_lib}\/LibreOffice\/sdk\/include$/d' file-lists/sdk_list.txt

# XXX create versioned links (mentioned in desktop files)
ln -sr %buildroot%lodir/program/soffice %buildroot%_bindir/%uname%hversion
for F in `find %buildroot%_iconsdir/*/*/apps -type f -name "%name-*.*"`; do
        ll=`echo "$F" | sed "s@apps/%name-@apps/%uname%hversion-@"`
        ln -sr "$F" "$ll"
done

# Pick up LOO-generated file lists
for l in %with_lang; do
        ll="`echo "$l" | tr '-' '_'`"
        grep -v '^%%dir' file-lists/lang_${ll}_list.txt > $ll.lang
done

# Reuse upstream SDK plugin list
grep -vh '^%%dir' file-lists/sdk_doc_list.txt file-lists/sdk_list.txt | grep -vF '/sdk/config.' > files.sdk

# Reuse upstream "GNOME" plugin list
grep -vh '^%%dir' file-lists/gnome_list.txt > files.gtk3

# Create qt5 plugin list
find %buildroot%lodir -name "*qt5*"   | sed 's@^%buildroot@@' > files.qt5

# Create kde5 plugin list
find %buildroot%lodir -name "*kf5*" | sed 's@^%buildroot@@' > files.kde5

# Create gkt3-kde5 plugin list
find %buildroot%lodir -name "*kde5*" | sed 's@^%buildroot@@' > files.gtk3-kde5

grep %lodir file-lists/common_list.txt | \
        grep -Ev '/share/extensions/.|%lodir/sdk/.|so[.]debug$|libreofficekit' | \
        cat > files.common
# TODO lo5 or something for stand-alone

grep -v %lodir file-lists/common_list.txt | \
        sed -E 's@(/man/.*)[.]gz@\1.*@' | \
        cat > files.integrated

# Hack out "Education" category from Math
sed -i 's/Education;//' %buildroot%lodir/share/xdg/math.desktop

# TODO some other hack with sysui/desktop/ stuff ?
mkdir %buildroot%_datadir/mimelnk
install sysui/desktop/mimetypes/*.desktop %buildroot%_datadir/mimelnk/
find %buildroot%_iconsdir -type f -name LibreOffice-oasis-\* | while read File; do
        Name=`basename $File`
        Dir=`dirname $File`
        Ext=${File##*.}
        Target=""
        case $Name in
               LibreOffice-oasis-web.*) Target=text-html;;
               LibreOffice-oasis-drawing.*) Target=image-x-generic;;
               LibreOffice-oasis-document.*) Target=x-office-document;;
               LibreOffice-oasis-presentation.*) Target=x-office-presentation;;
               LibreOffice-oasis-spreadsheet.*) Target=x-office-spreadsheet;;
        esac
        test -z "$Target" || ln -sr "$Dir/$Name" "$Dir/$Target.$Ext"
done

# Config file
install -D libreoffice.config %buildroot%conffile

# Typelib/GIR stuff

install -D workdir/CustomTarget/sysui/share/libreofficedev/*.typelib %buildroot%_typelibdir/LOKDocView-0.1.typelib
install -D workdir/CustomTarget/sysui/share/libreofficedev/*.gir %buildroot%_girdir/LOKDocView-0.1.gir
ln -s --relative %buildroot%lodir/program/liblibreofficekitgtk.so %buildroot%_libdir/
mkdir -p %buildroot%_includedir/LibreOfficeKit
install -p include/LibreOfficeKit/* %{buildroot}%{_includedir}/LibreOfficeKit

%files

%files sdk -f files.sdk

%files postgresql -f file-lists/postgresql_list.txt

%files common -f files.common
%config %conffile
%_bindir/%uname%hversion
%_iconsdir/*/*/apps/%uname%hversion-*
%if_with java
%lodir/program/classes/ScriptProviderForBeanShell.jar
%lodir/program/services/scriptproviderforbeanshell.rdb
%endif

%files integrated -f files.integrated
%_datadir/metainfo/LibreOffice*
%_datadir/mimelnk/*
%_iconsdir/*/*/mimetypes/[^Ll]*.*
%_bindir/%name

%files gtk3 -f files.gtk3

%if_enabled qt5
%files qt5 -f files.qt5
%endif

%if_enabled kf5
%files kde5 -f files.kde5
%_datadir/metainfo/*kde*

%files gtk3-kde5 -f files.gtk3-kde5
%endif

%files extensions
%lodir/share/extensions/*

%langpack -m -h -l en_US -s en -n English
%langpack -m -h -l ru          -n Russian
%langpack    -h -l be          -n Belorussian
%langpack -m -h -l de          -n German
%langpack -m -h -l fr          -n French
%langpack -m -h -l uk          -n Ukrainian
%langpack -m -h -l pt_BR -s pt -n Brazilian Portuguese -o pt-BR -v 7.4.2.1-alt1
%langpack -m -h -l es          -n Espanian
%langpack       -l kk          -n Kazakh
%langpack    -h -l tt          -n Tatar

%files -n libreofficekit
%_typelibdir/LOKDocView-*.typelib
%lodir/program/liblibreofficekitgtk.so
%_libdir/liblibreofficekitgtk.so
%lodir/share/libreofficekit

%files -n libreofficekit-devel
%_girdir/LOKDocView-*.gir
%_includedir/LibreOfficeKit

%changelog
