%define nm_version 1.20.0
%define ppp_version %(pkg-config --modversion pppd 2>/dev/null || (%{__awk} '/^#define VERSION/ { print $NF }' /usr/include/pppd/patchlevel.h 2>/dev/null||echo none)|/usr/bin/tr -d '"')

%define _unpackaged_files_terminate_build 1

%def_without gtk4

Name: NetworkManager-l2tp
Version: 1.20.20
Release: alt0.p10.1
License: GPLv2+
Group: System/Configuration/Networking
Summary:  NetworkManager VPN plugin for l2tp
Url: https://networkmanager.dev/docs/vpn/
Vcs: https://github.com/nm-l2tp/NetworkManager-l2tp.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch
Requires: NetworkManager-daemon >= %nm_version
Requires: NetworkManager-ppp >= %nm_version
Requires: xl2tpd
Requires: ppp = %ppp_version

Requires: strongswan

BuildRequires: ppp-devel
BuildRequires: libnm-devel >= %nm_version
BuildRequires: libnma-devel
BuildRequires: libgtk+3-devel
BuildRequires: libsecret-devel
# We consider it as system library
BuildRequires: libssl-devel
BuildRequires: libnss-devel
BuildRequires: gettext
%{?_with_gtk4:BuildRequires: libgtk4-devel libnma-gtk4-devel}

%description
This package contains software for integrating the l2tp VPN software
with NetworkManager.

%package gtk-common
License: GPLv2+
Summary: Common part of %name GTK support
Group: Graphical desktop/GNOME
Requires: NetworkManager-l2tp = %version-%release

%description gtk-common
This package contains common part for %name GTK support.

%package gtk3
License: GPLv2+
Summary: Files for GTK3 applications to use %name
Group: Graphical desktop/GNOME
Requires: %name-gtk-common = %version-%release

Obsoletes: %name-gnome < 0.9.8-alt2
Provides: %name-gnome = %version-%release

Obsoletes: %name-gtk < 1.20.4-alt1
Provides: %name-gtk = %version-%release

%description gtk3
This package contains files for GTK3 applications to use %name.

%if_with gtk4
%package gtk4
License: GPLv2+
Summary: Files for GTK4 applications to use %name
Group: Graphical desktop/GNOME
Requires: %name-gtk-common = %version-%release

%description gtk4
This package contains files for GTK4 applications to use %name.
%endif

%prep
%setup
%patch -p1

%build
%autoreconf
%configure \
	--disable-static \
	--libexecdir=%_libexecdir/NetworkManager \
	--localstatedir=%_var \
	--with-pppd-plugin-dir=%_libdir/pppd/%ppp_version \
	--with-nm-ipsec-secrets=/etc/strongswan/ipsec.secrets \
	--with-nm-ipsec-secrets-dir=/etc/strongswan/ipsec.d \
	%{subst_with gtk4} \
	--disable-silent-rules \
	--enable-more-warnings=yes
%make_build

%install
%makeinstall_std
%find_lang %name

%files
%doc AUTHORS NEWS README.md
%config %_datadir/dbus-1/system.d/nm-l2tp-service.conf
%_libexecdir/NetworkManager/nm-l2tp-service
%_libdir/pppd/%ppp_version/*.so
%_libdir/NetworkManager/libnm-vpn-plugin-l2tp.so
%config %_libexecdir/NetworkManager/VPN/nm-l2tp-service.name

%files gtk-common -f %name.lang
%_libexecdir/NetworkManager/nm-l2tp-auth-dialog
%_datadir/metainfo/*.xml

%files gtk3
%_libdir/NetworkManager/libnm-vpn-plugin-l2tp-editor.so

%if_with gtk4
%files gtk4
%_libdir/NetworkManager/libnm-gtk4-vpn-plugin-l2tp-editor.so
%endif

%exclude %_libdir/NetworkManager/*.la
%exclude %_libdir/pppd/%ppp_version/*.la

%changelog
