%def_without libnm_glib

Name: NetworkManager-strongswan
Version: 1.5.0
Release: alt1

Summary: NetworkManager strongSwan IPSec VPN plug-in

License: GPLv2+
Group: System/Servers
Url: https://www.strongswan.org/

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: https://download.strongswan.org/NetworkManager/%name-%version.tar.bz2

BuildRequires: pkgconfig(gtk+-3.0)
BuildRequires: pkgconfig(libsecret-1)
BuildRequires: pkgconfig(libnm) >= 1.1.0
BuildRequires: pkgconfig(libnma) >= 1.1.0
BuildRequires: intltool
BuildRequires: libtool

%if_with libnm_glib
BuildRequires: pkgconfig(dbus-glib-1) >= 0.30
BuildRequires: pkgconfig(NetworkManager) >= 1.1.0
BuildRequires: pkgconfig(libnm-util)
BuildRequires: pkgconfig(libnm-glib)
BuildRequires: pkgconfig(libnm-glib-vpn)
BuildRequires: pkgconfig(libnm-gtk)
%endif

Requires: NetworkManager
Requires: strongswan-charon-nm >= 5.8.3

%description
This package contains software for integrating the strongSwan IPSec VPN
with NetworkManager.

%package gnome
Summary: NetworkManager VPN plugin for strongswan - GNOME files
Group: System/Servers

Requires: NetworkManager-strongswan = %EVR

%description gnome
This package contains software for integrating the strongSwan IPSec VPN
with the graphical desktop.

%prep
%setup

%build
%configure \
        --disable-static \
%if_without libnm_glib
        --without-libnm-glib \
%endif
        --with-charon=%_libdir/strongswan/ipsec/charon-nm \
        --enable-more-warnings=no
%make_build

%install
%makeinstall_std
%find_lang %name

%files -f %name.lang
%_libexecdir/NetworkManager/VPN/nm-strongswan-service.name
%doc NEWS

%files gnome
%_datadir/gnome-vpn-properties/strongswan
%_libexecdir/NetworkManager/nm-strongswan-auth-dialog
%_libdir/NetworkManager/libnm-vpn-plugin-strongswan.so
%exclude %_libdir/NetworkManager/libnm-vpn-plugin-strongswan.la
%_datadir/appdata/NetworkManager-strongswan.appdata.xml

%if_with libnm_glib
%_libdir/NetworkManager/libnm-*-properties.so
%_sysconfdir/NetworkManager/VPN/nm-strongswan-service.name
%exclude %_libdir/NetworkManager/libnm-strongswan-properties.la
%endif

%changelog
