# vim: set ft=spec: -*- rpm-spec -*-

Name: PokerTH
Version: 1.1.2
Release: alt7

Summary: Texas Hold'em poker game
Group: Games/Cards
License: AGPL-3.0+
Url: http://www.pokerth.net/

Source: %name-%version.tar
Patch: %name-%version-%release.patch

# https://github.com/pokerth/pokerth/issues/368
Patch1: PokerTH-upstream-boost-compat-1.patch
Patch2: PokerTH-upstream-boost-compat-2.patch

Patch3: %name-%version-alt-boost-1.73.0-compat.patch

BuildRequires: boost-asio-devel boost-filesystem-devel boost-program_options-devel boost-interprocess-devel gcc-c++ libSDL-devel libSDL_mixer-devel libcurl-devel libgnutls-openssl-devel libgsasl-devel qt5-base-devel

BuildPreReq: libgcrypt-devel zlib-devel libsqlite3-devel tinyxml-devel libircclient-devel libprotobuf-devel
BuildPreReq: protobuf-compiler

Requires: %name-data = %version-%release

%define _unpackaged_files_terminate_build 1

%description
PokerTH is a poker game written in C++/Qt5. You can play the popular
"Texas Hold'em" poker variant against up to nine computer-opponents or
play network games with people all over the world.

%package data
Summary: Data files for %name
Group: Games/Cards
License: ALT-Public-Domain and GPLv2+
BuildArch: noarch
Requires: %name = %version-%release

%description data
PokerTH is a poker game written in C++/Qt5. You can play the popular
"Texas Hold'em" poker variant against up to nine computer-opponents or
play network games with people all over the world.

This package contents data files for %name.

%prep
%setup
%patch -p1

pushd src/third_party/websocketpp
%patch1 -p1
%patch2 -p1
popd

%patch3 -p2

%build
%add_optflags -fno-strict-aliasing

# regenerate protobuf files
qmake-qt5 pokerth_protocol.pro

qmake-qt5 \
	QMAKE_CFLAGS_RELEASE="%optflags" \
	QMAKE_CXXFLAGS_RELEASE="%optflags" \
	pokerth.pro
%make_build
qmake-qt5 \
	QMAKE_CFLAGS_RELEASE="%optflags" \
	QMAKE_CXXFLAGS_RELEASE="%optflags" \
	pokerth_game.pro
%make_build

%install
%makeinstall_std INSTALL_ROOT=%buildroot
mkdir -p %buildroot%_bindir
install -pm755 pokerth bin/pokerth_server %buildroot%_bindir

# remove bundled font (see ALT 25328)
rm %buildroot%_datadir/pokerth/data/fonts/DejaVuSans-Bold.ttf

%files
%_bindir/*

%files data
%_datadir/pokerth
%_desktopdir/pokerth.desktop
%_pixmapsdir/pokerth.png

%changelog
