%define origver 2020.3.17
%def_enable openmp

Name: SimGear
Version: %origver
Release: alt1

Summary: Simulator Construction Tools
License: GPLv2+
Group: System/Libraries

Url: http://www.flightgear.org
# Source-url: https://sourceforge.net/projects/flightgear/files/release-%origver/simgear-%version.tar.bz2
Source: %name-%version.tar
Patch0: simgear-3.2.0-fedora-format.patch
Patch1: simgear-3.6.0-fedora-aarch64.patch
Patch2: %name-g++8.patch
Packager: Michael Shigorin <mike@altlinux.org>

# Automatically added by buildreq on Sat Mar 03 2012
# optimized out: cmake-modules libGL-devel libICE-devel libOpenThreads-devel libSM-devel libX11-devel libXau-devel libXext-devel libopenal-devel libstdc++-devel xorg-kbproto-devel xorg-xproto-devel
BuildRequires: boost-devel-headers cmake gcc-c++ libGLU-devel libOpenSceneGraph-devel libXi-devel libXt-devel libalut-devel libapr1-devel zlib-devel libcurl-devel libstdc++-devel

BuildRequires: cmake libapr1-devel
BuildRequires: libexpat-devel
BuildRequires: liblzma-devel
%if_enabled openmp
BuildRequires: libgomp-devel
%endif

%ifarch %e2k
# had to disable in OpenSceneGraph => unmets followed up
%global __find_debuginfo_files %nil
%endif

%description
SimGear is a set of open-source libraries designed to be used
as building blocks for quickly assembling 3d simulations, games,
and visualization applications.

%package -n libsimgear
Summary: Simulation library
Group: System/Libraries

%description -n libsimgear
SimGear is a set of open-source libraries designed to be used
as building blocks for quickly assembling 3d simulations, games,
and visualization applications.

%package -n libsimgear-devel
Summary: Simulation library (development part)
Group: Development/C
Provides: SimGear = %version
Provides: SimGear-devel = %version
Obsoletes: SimGear-devel < 1.0.0
Conflicts: SimGear-devel < 1.0.0

# from SimGearTargets.cmake
Requires: libOpenSceneGraph-devel libOpenThreads-devel
Requires: zlib-devel libcurl-devel libopenal-devel libGL-devel libGLU-devel

%description -n libsimgear-devel
SimGear is a set of open-source libraries designed to be used as
building blocks for quickly assembling 3d simulations, games,
and visualization applications.

This package contains header files for SimGear.

%prep
%setup
%patch0 -p1
%patch1 -p1
%ifarch %e2k
sed -i "/__x86_64__/{N;/<x86intrin.h>/s/__x86_64__/__e2k__/}" simgear/math/simd.hxx
%else
%patch2 -p2
%endif
#sed -i "s|\${CMAKE_INSTALL_LIBDIR}/cmake/SimGear|%_libdir/cmake/SimGear|" CMakeLists.txt

# rename version file to simgear_version because it's incorrectly detected as header file
# by boost-1.73.0, and compilation fails when it's being incorrectly used as header file
mv version simgear_version

%build
%add_optflags %optflags_shared
# /usr/src/RPM/BUILD/SimGear-2020.1/simgear/io/HTTPRepository.cxx:267:16: error: return-statement with a value, in function returning 'void' [-fpermissive]
#         return "";
%add_optflags -fpermissive
%cmake \
%ifarch x86_64 aarch64 %e2k
	-DENABLE_SIMD_CODE=ON \
%endif
	-DCMAKE_BUILD_TYPE=Release \
	-DCMAKE_C_FLAGS_RELEASE="-DNDEBUG" \
	-DCMAKE_CXX_FLAGS_RELEASE="-DNDEBUG" \
%if_enabled openmp
	-DENABLE_OPENMP=ON \
%endif
	-DSIMGEAR_SHARED=ON \
	-DSYSTEM_EXPAT=ON \
	-DENABLE_TESTS=OFF
%cmake_build

%install
%cmake_install

%files -n libsimgear
%doc AUTHORS README* Thanks
%_libdir/*.so.*

%files -n libsimgear-devel
%_libdir/*.so
%_includedir/simgear
%_libdir/cmake/%name/

%changelog
